// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ForLoopStatement.cc,v 1.4.2.1 1999/11/06 15:16:19 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ForLoopStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_RangeTypeDefinition.hh"
#include "IIR_Label.hh"
#include "IIR_List.hh"
#include "IIR_SequentialStatementList.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_Attribute.hh"
#include "symbol_table.hh"
#include <strstream.h>
#include "IIR_AccessTypeDefinition.hh"

extern bool parse_error;

IIRScram_ForLoopStatement::~IIRScram_ForLoopStatement() {
}


void 
IIRScram_ForLoopStatement::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_iteration_scheme() != NULL);
  ASSERT(get_iteration_scheme()->_is_resolved() == TRUE);

  if (get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ": ";
  }
    
  _vhdl_out << "for ";
  get_iteration_scheme()->get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " in ";
  if(get_iteration_scheme()->_is_range_attribute() == TRUE) {
    get_iteration_scheme()->_get_attribute()->_publish_vhdl(_vhdl_out);
  } 
  else {
    get_iteration_scheme()->get_subtype()->_publish_vhdl(_vhdl_out);
//     _vhdl_out << " range ";
//     get_iteration_scheme()->get_subtype()->_publish_vhdl_range(_vhdl_out);
  }
  
  _vhdl_out << " loop" << endl;

  if (sequence_of_statements.num_elements() != 0) {
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }

  _vhdl_out << "end loop";
}

void 
IIRScram_ForLoopStatement::_publish_cc() {
  ASSERT(get_iteration_scheme() != NULL);
  ASSERT(get_iteration_scheme()->_is_resolved() == TRUE);

  _cc_out << *_get_label() << ":" << endl;
  _cc_out << "{" << endl;
  if(get_iteration_scheme()->_is_range_attribute() == TRUE) {
    _publish_cc_for_loop_stmt_with_range();
  } else {
    _cc_out << "assignVariable(";
    get_iteration_scheme()->_publish_cc();
    _cc_out << ", ";
    get_iteration_scheme()->_publish_cc_left();
    _cc_out << ", nullInfo, nullInfo);" << endl;

    _cc_out << "while(";
    if(get_iteration_scheme()->_is_ascending_range() == TRUE) {
      _cc_out << "SAVANT_BOOLEAN_TRUE == savantLessThanOrEqual";
    } else {
      _cc_out << "SAVANT_BOOLEAN_TRUE == savantGreaterThanOrEqual";
    }
    _cc_out << "(";
    get_iteration_scheme()->_publish_cc();
    _cc_out << ", ";
    get_iteration_scheme()->_publish_cc_right();
    _cc_out << ")) {" << endl;

    if (sequence_of_statements.num_elements() != 0) {
      sequence_of_statements._publish_cc();
    }

    _publish_cc_next_label();
    _cc_out << ":" << endl;

    get_iteration_scheme()->_publish_cc();
    _cc_out << ".";
    if(get_iteration_scheme()->_is_ascending_range() == TRUE) {
      _cc_out << "increment()";
    } else {
      _cc_out << "decrement()";
    }
    _cc_out << ";" << endl;

    _cc_out << "  if (";
    get_iteration_scheme()->_publish_cc();
    _cc_out << ".overflow() == true)  {\n    break;\n  }\n";
    
    _cc_out << "}" << endl;
  }
  //  if(_is_currently_publishing_subprogram() == TRUE) {
    _cc_out << "}" << endl;
    //  }
  _publish_cc_exit_label();
  _cc_out << ":;" << endl;
}

void 
IIRScram_ForLoopStatement::_publish_cc_attr_of_range_attribute( const char *attr, 
								IIR_Attribute* range_attr ){
  IIR_Boolean type_flag = FALSE;
  
  if(range_attr->get_prefix()->_is_object() == FALSE) {
    if(range_attr->get_prefix()->get_kind() == IIR_TYPE_DECLARATION){
      type_flag = TRUE;
      range_attr->get_prefix()->_publish_cc_type_name();
      _cc_out << "::" << attr << "(";
    }
  }
  else if(range_attr->get_prefix()->_is_access_type() == TRUE) {
    IIR_AccessTypeDefinition* access_type = (IIR_AccessTypeDefinition*)range_attr->get_prefix()->_get_subtype();
    if ((access_type->get_designated_type()->_is_array_type() == TRUE) && (access_type->get_designated_type()->_is_unconstrained_array_type() == FALSE)) {
      access_type->get_designated_type()->_publish_cc_type_name();
      _cc_out << "::" << attr << "(";
    }
    else {
      ASSERT ( access_type->get_designated_type() != NULL );
      _cc_out << "((";
      access_type->get_designated_type()->_publish_cc_type_name();
      _cc_out << " &)";
      _cc_out << "(";      
      range_attr->get_prefix()->_publish_cc();
      _cc_out << ".all()))." << attr << "_O(";
    }
  }
  else {
    range_attr->get_prefix()->_publish_cc();
    _cc_out << "." << attr << "_O(";
  }
  if(range_attr->_get_suffix() != NULL) {
    range_attr->_get_suffix()->_publish_cc();
    if (type_flag == TRUE) {
      // Need to publish the type_info also after the function call for types
      // as they are a part of the kernel now.
      _cc_out << ", ";
      range_attr->get_prefix()->_publish_cc_type_name();
      _cc_out << "_info";
    }    
  } else {
    _cc_out << "IntegerType(ObjectBase::VARIABLE, UniversalInteger(1)"
	    << ", SavantintegerType_info)";
  }

  _cc_out << ")";
}

void
IIRScram_ForLoopStatement::_publish_cc_low_of_range_attribute(IIR_Attribute* range_attr) {
  if( range_attr->get_kind() == IIR_RANGE_ATTRIBUTE ){
    _publish_cc_attr_of_range_attribute( "LEFT", range_attr );
  }
  else{
    _publish_cc_attr_of_range_attribute( "RIGHT", range_attr );
  }
}

void
IIRScram_ForLoopStatement::_publish_cc_high_of_range_attribute(IIR_Attribute* range_attr) {
  if(range_attr->get_kind() == IIR_RANGE_ATTRIBUTE) {
    _publish_cc_attr_of_range_attribute( "RIGHT", range_attr );  
  }
  else {
    _publish_cc_attr_of_range_attribute( "LEFT", range_attr );  
  }
}

void
IIRScram_ForLoopStatement::_publish_cc_ascending_of_range_attribute(IIR_Attribute* range_attr) {
  _publish_cc_attr_of_range_attribute( "ASCENDING", range_attr );  
}

void
IIRScram_ForLoopStatement::_publish_cc_for_loop_stmt_with_range() {
  IIR_Attribute* range_attr = get_iteration_scheme()->_get_attribute();

  ASSERT(range_attr != NULL);
  ASSERT(range_attr->_is_resolved());
  ASSERT(range_attr->get_kind() == IIR_RANGE_ATTRIBUTE ||
	 range_attr->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE);

  get_iteration_scheme()->_publish_cc();
  _cc_out << " = (const ";
  get_iteration_scheme()->_publish_cc_type_name();
  _cc_out << "&)";
  _publish_cc_low_of_range_attribute(range_attr);
  _cc_out << ";" <<endl << "while(((";
  _publish_cc_ascending_of_range_attribute(range_attr);
  _cc_out << " == SAVANT_BOOLEAN_TRUE) ? ";
  if(range_attr->get_kind() == IIR_RANGE_ATTRIBUTE) {
    _cc_out << "savantLessThanOrEqual(";
  }
  else {
    _cc_out << "savantGreaterThanOrEqual(";
  }
  get_iteration_scheme()->_publish_cc();
  _cc_out << ", ";
  _publish_cc_high_of_range_attribute(range_attr);
  _cc_out <<") : ";
  if(range_attr->get_kind() == IIR_RANGE_ATTRIBUTE) {
    _cc_out << "savantGreaterThanOrEqual(";
  }
  else {
    _cc_out << "savantLessThanOrEqual(";
  }
  get_iteration_scheme()->_publish_cc();
  _cc_out << ", ";
  _publish_cc_high_of_range_attribute(range_attr);
  _cc_out << ")) == SAVANT_BOOLEAN_TRUE) {" << endl;

  if (sequence_of_statements.num_elements() != 0) {
    sequence_of_statements._publish_cc();
  }

  _publish_cc_next_label();
  _cc_out << ":" << endl;

  _cc_out << "if (";
  _publish_cc_ascending_of_range_attribute(range_attr);
  _cc_out<< " == SAVANT_BOOLEAN_TRUE) {" << endl;
  get_iteration_scheme()->_publish_cc();
  _cc_out << "."; 
  if(range_attr->get_kind() == IIR_RANGE_ATTRIBUTE) {
    _cc_out << "increment();" << endl;
  }
  else {
    _cc_out << "decrement();" << endl;
  }
  _cc_out << " } else {" << endl;
  get_iteration_scheme()->_publish_cc();
  _cc_out << ".";
  if(range_attr->get_kind() == IIR_RANGE_ATTRIBUTE) {
    _cc_out << "decrement();" << endl;
  }
  else {
    _cc_out << "increment();" << endl;
  }
  
  _cc_out << "  if (";
  get_iteration_scheme()->_publish_cc();
  _cc_out << ".overflow() == true)  {\n    break;\n  }\n";
  
  _cc_out   << "}" << endl;

  _cc_out << "}" << endl;
}

void
IIRScram_ForLoopStatement::_publish_cc_decl_for_loop_iterator() {
  ASSERT(_is_currently_publishing_subprogram() == TRUE);

  get_iteration_scheme()->_publish_cc_type_name();
  _cc_out << " ";
  get_iteration_scheme()->_publish_cc();
  _cc_out << "(ObjectBase::VARIABLE);" << endl;

  sequence_of_statements._publish_cc_decl_for_loop_iterator();
}

void
IIRScram_ForLoopStatement::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  sequence_of_statements._build_wait_list(list);
}

void 
IIRScram_ForLoopStatement::_build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *list) {
  sequence_of_statements._build_procedure_call_stmt_list(list);
}

void
IIRScram_ForLoopStatement::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  sequence_of_statements._get_list_of_input_signals(list) ;
}

void
IIRScram_ForLoopStatement::_get_signal_source_info(set<IIR_Declaration>* siginfo) {
  sequence_of_statements._get_signal_source_info(siginfo);
}

void 
IIRScram_ForLoopStatement::_type_check(){
  ASSERT( get_iteration_scheme() != NULL );  
  get_iteration_scheme()->set_subtype( _type_check_iteration_scheme(get_iteration_scheme() ) );
}

IIR_Boolean 
IIRScram_ForLoopStatement::_type_check_return_statements( set<IIR_TypeDefinition> *context_set, IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval;

  ASSERT( get_iteration_scheme() != NULL && get_iteration_scheme()->_is_resolved() == TRUE );
  
  _get_symbol_table()->open_scope( this );
  _get_symbol_table()->make_visible( get_iteration_scheme() );

  retval = 
    IIR_SequentialStatement::_type_check_return_statements( context_set, &sequence_of_statements, subprogram_decl );

  _get_symbol_table()->close_scope( this );

  return retval;
}

set<IIR_Declaration> *
IIRScram_ForLoopStatement::_find_declarations( IIR_Name *to_find ){
  ASSERT( get_iteration_scheme() != NULL );
  IIR_TextLiteral *loop_param = get_iteration_scheme()->get_declarator();
  if( IIR_TextLiteral::_cmp( loop_param, to_find ) == 0 ){
    return new set<IIR_Declaration>(get_iteration_scheme());
  }
  else{
    return NULL;
  }
}

