// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran  urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LastEventAttribute.cc,v 1.4 1999/10/28 03:24:08 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_LastEventAttribute.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "StandardPackage.hh"
#include "set.hh"
#include "symbol_table.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_LastEventAttribute::~IIRScram_LastEventAttribute() {}

void 
IIRScram_LastEventAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'LAST_EVENT ";
}
  
IIR_TypeDefinition *
IIRScram_LastEventAttribute::_get_subtype(){

  return (IIR_TypeDefinition*)StandardPackage::time_type;
}

IIR_TextLiteral *
IIRScram_LastEventAttribute::_build_attribute_name() {
  char *name = "last_event";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_Declaration *
IIRScram_LastEventAttribute::_get_implicit_declaration( char *decl_name,
							IIR_TypeDefinition *decl_type ){ 
  return _build_function_declaration( decl_name, decl_type );
}

void 
IIRScram_LastEventAttribute::_publish_cc() {
  _publish_cc_signal_attribute("LastEvent");
}

void
IIRScram_LastEventAttribute::_publish_cc_init_val() {
  _cc_out << "UniversalInteger(0)";
}

void
IIRScram_LastEventAttribute::_publish_cc_necessary_decl_in_state() {
  IIR_Declaration* decl;
  IIR* prefix = get_prefix();
  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }
  if(!prefix->_is_published_attribute_in_state(IIR_Declaration::LAST_EVENT)) {
    if(decl->_is_scalar_type() == TRUE) {
      _cc_out << "  PhysicalType ";
    }
    else {
      decl->_get_subtype()->_publish_cc();
      _cc_out << "_lastevent ";
    }
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_last_event";
    _cc_out << ";" << endl;
    prefix->_add_published_attribute_in_state(IIR_Declaration::LAST_EVENT);
  }
}

void
IIRScram_LastEventAttribute::_publish_cc_name_in_caps() {
  _cc_out << "LAST_EVENT";
}

// Used in State::initialize for attribute[#].value.time
void
IIRScram_LastEventAttribute::_publish_cc_attrib_type() {
  _cc_out << "function";
}

void
IIRScram_LastEventAttribute::_publish_cc_necessary_decl_init(){ }

void
IIRScram_LastEventAttribute::_publish_cc_elaborate() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  get_prefix()->_publish_cc_elaborate();
  _cc_out << "_last_event";
}

void
IIRScram_LastEventAttribute::_publish_cc_sigtype() {
  _cc_out << "I_LAST_EVENT";
}

//void 
//IIRScram::_record() {}
//IIR * 
//IIRScram_LastEventAttribute::_transmute() {}


void
IIRScram_LastEventAttribute::_publish_cc_state_object_init() {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );

  IIR_Declaration* decl;
  IIR* prefix = get_prefix();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_constructor(IIR_Declaration::LAST_EVENT)) {
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_last_event(ObjectBase::VARIABLE";
    if(decl->_is_array_type() == TRUE) {
      _cc_out << ", ";
      decl->_get_subtype()->_publish_cc_range();
    }
    _cc_out << "), ";    
    _cc_out << endl;
    prefix->_add_published_attribute_in_constructor(IIR_Declaration::LAST_EVENT);
  }
}


void
IIRScram_LastEventAttribute::_publish_cc_init() {

  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );

  IIR_Declaration* decl;
  IIR* prefix = get_prefix();
  IIR_TypeDefinition* type_def = _get_explicit_signal_type();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_initstate(IIR_Declaration::LAST_EVENT)) {
    decl->_get_declarator()->_publish_cc();
    _cc_out << "_last_event = ";



    if(type_def->_is_scalar_type() == TRUE) {
      _cc_out << "PhysicalType(ObjectBase::VARIABLE";
      _cc_out << ", UniversalLongLongInteger(-1), SavanttimeType_info);";
    }
    else if((type_def->_is_array_type() == TRUE) || (type_def->_is_record_type() == TRUE)) {
      type_def->_publish_cc_type_name();
      _cc_out << "_lastevent(ObjectBase::VARIABLE";
      if((type_def->_is_array_type() == TRUE) &&
	 (type_def->_is_anonymous() == TRUE)){
	_cc_out << ", ";
	type_def->_publish_cc_range();
      }
      _cc_out << ", 1, new ElementAssociation(Others, new PhysicalType(ObjectBase::VARIABLE, UniversalLongLongInteger(-1), SavanttimeType_info))";
      _cc_out << "); ";    
    }
    _cc_out << endl;
    prefix->_add_published_attribute_in_initstate(IIR_Declaration::LAST_EVENT);
  }
}


IIR *
IIRScram_LastEventAttribute::_clone() {
  IIR_LastEventAttribute *clone = new IIR_LastEventAttribute;
  IIR_Attribute::_clone( clone );
  return clone;
}
