// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Literal.cc,v 1.2 1999/03/09 20:55:25 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_Literal.hh"
#include <iostream.h>
#include "IIR_DesignatorList.hh"
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "StandardPackage.hh"

IIRScram_Literal::~IIRScram_Literal() {}


IIR_Int32 
IIRScram_Literal::_char_to_int(IIR_Char digit) {
  IIR_Int32 retval;

  switch (digit) {
  case '0':
    retval = 0;
    break;
  case '1':
    retval = 1;
    break;
  case '2':
    retval = 2;
    break;
  case '3':
    retval = 3;
    break;
  case '4':
    retval = 4;
    break;
  case '5':
    retval = 5;
    break;
  case '6':
    retval = 6;
    break;
  case '7':
    retval = 7;
    break;
  case '8':
    retval = 8;
    break;
  case '9':
    retval = 9;
    break;
  case 'a':
  case 'A':
    retval = 10;
    break;
  case 'b':
  case 'B':
    retval = 11;
    break;
  case 'c':
  case 'C':
    retval = 12;
    break;
  case 'd':
  case 'D':
    retval = 13;
    break;
  case 'e':
  case 'E':
    retval = 14;
    break;
  case 'f':
  case 'F':
    retval = 15;
    break;
  default:
    cerr << "_char_to_int: cannot convert char (" << digit
	 << ") to a digit" << endl;

    abort();

    break;
  }
  return retval;
}

void
IIRScram_Literal::_get_list_of_input_signals(set<IIR_Declaration>*) {
  //nothing to be done here
}

void
IIRScram_Literal::_publish_cc_condition() {
  _report_undefined_scram_fn("_publish_cc_name_condition()");
}

void
IIRScram_Literal::_build_sensitivity_list(IIR_DesignatorList*) {
  //nothing to be done here
}

IIR_Boolean
IIRScram_Literal::_is_integer_literal() {
  return false;
}

IIR_Boolean
IIRScram_Literal::_is_literal() {
  return TRUE;
}

IIR_TypeDefinition *
IIRScram_Literal::_get_subtype(){
  return my_type;
}

IIR *
IIRScram_Literal::_rval_to_decl( IIR_TypeDefinition *my_new_type ){
  my_type = my_new_type;

  return this;
}

void 
IIRScram_Literal::_set_subtype( IIR_TypeDefinition *my_new_type ){
  my_type = my_new_type;
}

IIR_Boolean
IIRScram_Literal::_is_resolved(){
  if( _get_subtype() == NULL ){
    return FALSE;
  }
  else{
    return TRUE;
  }
}

IIR_Boolean 
IIRScram_Literal::_is_locally_static_primary(){
  if( _get_subtype()->_is_compatible( StandardPackage::time_type ) ){
    return FALSE;
  }
  else{
    return TRUE;
  }
}
