// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PackageDeclaration.cc,v 1.2 1999/03/09 20:55:48 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include <strstream.h>
#include "IIRScram_PackageDeclaration.hh"
#include "IIR_ObjectDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "resolution_func.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_SequentialStatementList.hh"
#include "symbol_table.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_PackageDeclaration::IIRScram_PackageDeclaration() {
  cgen_sym_tab_ptr = NULL;
}

IIRScram_PackageDeclaration::~IIRScram_PackageDeclaration() {}

void 
IIRScram_PackageDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  PublishedUnit oldUnit;
  
  context_items._publish_vhdl(_vhdl_out);

  oldUnit = _get_currently_publishing_vhdl_unit();
  _set_currently_publishing_vhdl_unit(IIRScram::PACKAGE);
  
  _vhdl_out << "package ";
  _get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";
  package_declarative_part._publish_vhdl_decl(_vhdl_out);
  _vhdl_out << "end package;\n";

  _set_currently_publishing_vhdl_unit(oldUnit);
}


void 
IIRScram_PackageDeclaration::_publish_vhdl(ostream &_vhdl_out) {
  _get_declarator()->_publish_vhdl(_vhdl_out);
}  

void 
IIRScram_PackageDeclaration::_publish_cc_package_name() {
  // This is not very elegant.  Will be changed shortly. -- SK.
  if(_is_textio() == TRUE) {
    _cc_out << "textio";
  } else if(_is_standard() == TRUE) {
    _cc_out << "standard";
  } else {
    _get_declarator()->_publish_cc();
    _cc_out << "Pkg";
  }
}

void 
IIRScram_PackageDeclaration::_publish_cc() {
  IIR_Char buf[256];
  ostrstream str(buf, 256, ios::out);
  IIR_Char *_prev_publish_name = _current_publish_name;	// Save previous value.
  IIR *_prev_publish_node = _current_publish_node;
  ostrstream package_name;
  symbol_table cgen_sym_tab( 4093, false );
  
  str << *_get_declarator() << ends;
  //  _current_publish_name = buf;
  _current_publish_node = this;

  package_name << *_get_declarator() << ends;
  _current_package_name = package_name.str();
  _current_publish_name = _current_package_name;

  _set_currently_publishing_unit(IIRScram::PACKAGE);

  cgen_sym_tab_ptr = &cgen_sym_tab;

  _publish_cc_header();
  _publish_cc_cc_file();
  _set_currently_publishing_unit(NONE);

  cgen_sym_tab_ptr = NULL;
  _current_publish_name = _prev_publish_name;
  _current_publish_node = _prev_publish_node;

  delete [] _current_package_name;
  _current_package_name = NULL;
}

void 
IIRScram_PackageDeclaration::_publish_cc_header() {
  _cc_out.set_file(true, _current_publish_name, "Pkg.hh");
  _cc_out << "#ifndef ";
  _publish_cc_package_name();
  _cc_out << "_HH" << endl
	  << "#define ";
  _publish_cc_package_name();
  _cc_out << "_HH" << endl;

  context_items._publish_cc();
  _publish_cc_headers();
  package_declarative_part._publish_cc_extern_type_info();
// Temporarily commented out the class declaration for a package.  Will
// revert back to it after the sharc model release. -- SK

//   _cc_out << "class ";
//   _publish_cc_package_name();
//   _cc_out << " {" << endl
// 	  << "public: " << endl;

//   // Publish the dummy constructor.
//   _publish_cc_package_name();
//   _cc_out << "() {};" << endl;

//   // Publish the dummy destructor.
//   _cc_out << "~";
//   _publish_cc_package_name();
//   _cc_out << "() {};" << endl;
  
  package_declarative_part._publish_cc_package_declarations();
  _cc_out.set_file(true, _current_publish_name, "Pkg.hh");
//   _cc_out << "};" << endl;
  _cc_out << endl << "#endif" << endl;
}

void 
IIRScram_PackageDeclaration::_publish_cc_headers() {
  IIR_Declaration *decl = package_declarative_part.first();
  set<IIR> headerSet;

  _cc_out << "#include \"VHDLKernel.hh\"" << endl
	  << "#include \"standard.hh\"" << endl;
  while (decl != NULL) {
    switch(decl->get_kind()) {
    case IIR_TYPE_DECLARATION:
    case IIR_SUBTYPE_DECLARATION:
      headerSet.add(decl);
      break;
    case IIR_FUNCTION_DECLARATION:
    case IIR_PROCEDURE_DECLARATION:
      decl->_get_headers(headerSet);
      break;
    case IIR_COMPONENT_DECLARATION:
      _cc_out << "#include \"SCOM";
      (decl->_get_declarator())->_publish_cc_elaborate();
      _cc_out << "_elab.hh\"\n";
      break;
    case IIR_USE_CLAUSE:
      decl->_publish_cc_headers();
      break;
    case IIR_ATTRIBUTE_SPECIFICATION:
      _cc_out << "extern ";
      decl->_publish_cc_decl();
      break;
    case IIR_SHARED_VARIABLE_DECLARATION:
    case IIR_FILE_DECLARATION:
    case IIR_ALIAS_DECLARATION:
    case IIR_DISCONNECT_SPECIFICATION:
    case IIR_GROUP_DECLARATION:
    case IIR_GROUP_TEMPLATE_DECLARATION:
      cerr << decl->get_kind_text() << " not supported in package yet" << endl;
      break;
    case IIR_ATTRIBUTE_DECLARATION:
      // Nothing to be done.
      break;
    default:
      break;
    }
    decl = package_declarative_part.successor(decl);
  }

  // Walk through the collected set of type declarations and publish headers
  IIR *typDecl = headerSet.get_element();
  while (typDecl != NULL) {
    _cc_out << "#include \"";
    typDecl->_publish_cc_type_name();
    _cc_out << ".hh\"" << endl;
    typDecl = headerSet.get_next_element();
  }
}  

void
IIRScram_PackageDeclaration::_publish_cc_cc_file() {
  IIR_Declaration *decl = package_declarative_part.first();
  _cc_out.set_file(true, _current_publish_name, "Pkg.cc");

  _cc_out << "#include \"";
  _publish_cc_package_name();
  _cc_out << ".hh\"" << endl << endl;

  
  //first publish the constants
  for(decl = package_declarative_part.first(); decl != NULL; decl = package_declarative_part.successor(decl)){
    switch(decl->get_kind()){
    case IIR_CONSTANT_DECLARATION:
      ((IIR_ConstantDeclaration *) decl)->_publish_cc_init_package_constant();
      break;
    default:
      break;
    }
  }
  
  package_declarative_part._publish_cc_type_info();
  _cc_out << endl;
  
  for(decl = package_declarative_part.first();decl != NULL; decl = package_declarative_part.successor(decl)) {
    switch(decl->get_kind()) {
    case IIR_CONSTANT_DECLARATION:
      // do nothing.
      //((IIR_ConstantDeclaration *) decl)->_publish_cc_init_package_constant();
      break;
    case IIR_SIGNAL_DECLARATION:
      if (decl->_get_subtype()->_is_scalar_type() == TRUE &&
	  decl->_get_subtype()->_is_kernel_type() == FALSE){
	decl->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	decl->_get_subtype()->_publish_cc_type_name();
      }
      _cc_out << " ";
      decl->_publish_cc_elaborate();
      _cc_out << "(ObjectBase::SIGNAL_NETINFO";
      if(decl->_get_subtype()->_is_array_type() &&
         decl->_get_subtype()->_is_anonymous() == TRUE) {
        _cc_out << ", ";
        decl->_get_subtype()->_publish_cc_range();
      } 
      else if(decl->_get_subtype()->_is_unconstrained_array_type()){
        ASSERT(decl->get_value() != NULL);
        if(decl->get_value()->get_kind() != IIR_CONCATENATION_OPERATOR){
          _cc_out << ", ";
          decl->get_value()->_publish_cc_range();
        }
      }
      _cc_out << ");" << endl;
      break;
    case IIR_TYPE_DECLARATION:
    case IIR_SUBTYPE_DECLARATION:
    case IIR_USE_CLAUSE:
      break;
    case IIR_PROCEDURE_DECLARATION:
    case IIR_FUNCTION_DECLARATION:
      decl->_publish_cc_decl();
      break;
    case IIR_ATTRIBUTE_SPECIFICATION:
      ((IIR_AttributeSpecification *) decl)->_publish_cc_decl_with_constructor();
      break;
    case IIR_COMPONENT_DECLARATION:
    case IIR_ATTRIBUTE_DECLARATION:
      // Nothing to be done.
      break;
    default:
      cerr << "Unimplemented declaration type: " << decl->get_kind_text()
	   << " in IIRScram_PackageDeclaration::_publish_cc_cc_file()." 
	   << endl;
      break;
    }
  }
//   _current_publish_name = _prev_publish_name;
//   _current_publish_node = _prev_publish_node;
}

void
IIRScram_PackageDeclaration::_publish_cc_elaborate() {
}

IIR_Declaration*
IIRScram_PackageDeclaration::_get_prefix_declaration() {
  return this;
}

IIR_Declaration*
IIRScram_PackageDeclaration::_get_package_declaration() {
  return this;
}


IIRScram_Declaration::declaration_type 
IIRScram_PackageDeclaration::_get_type(){
  return PACKAGE;
}


set<IIR_Declaration> *
IIRScram_PackageDeclaration::_find_declarations( IIR_Name *to_find ){
  return package_declarative_part._find_declarations( to_find );
}

void 
IIRScram_PackageDeclaration::_add_to_declarative_region( set<IIR_Declaration> *set_to_add ){
  IIR_Declaration::_add_to_declarative_region( package_declarative_part, set_to_add );
}

void 
IIRScram_PackageDeclaration::_make_interface_visible( symbol_table *sym_tab ){
  ASSERT( sym_tab != NULL );

  sym_tab->make_visible( this );
  context_items._make_visible_as_context_list( sym_tab );
  sym_tab->make_visible( &package_declarative_part );
}

void 
IIRScram_PackageDeclaration::_type_check( ){
  IIR_SequentialStatementList empty_list;

  package_declarative_part._type_check_attribute_specifications( empty_list );
  package_declarative_part._type_check_configuration_specifications( empty_list );
  package_declarative_part._type_check_disconnection_specifications(  );
  
}
