#ifndef IIRSCRAM_PROCESS_STATEMENT_HH
#define IIRSCRAM_PROCESS_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ececs.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Malolan Chetlur     mal@ececs.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ececs.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ProcessStatement.hh,v 1.3 1999/04/12 18:18:48 ssubrama Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ProcessStatement.hh"
class IIR_WaitStatement;


class IIRScram_ProcessStatement : public IIRBase_ProcessStatement {
public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _publish_cc_state();
  void _publish_cc_file_open();
  void _publish_cc_extern_declarations();
  void _publish_cc_file_declarations();

  // This was added by Dale Martin as part of a code optimization to
  // _publish_cc_headerfiles_for_cc().  If this code is wrong in some
  // context, rename this _publish_cc_headerfiles_for_cc and put in the
  // surrounding code that's required.
  void _publish_cc_binding_name( ostream &_cc_out );

  virtual void _publish_createNetInfo();
  void _add_declarations_in_initializations();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
#ifdef PROCESS_GRAPH
  void _publish_cc_driver_info();
#endif

  virtual void _type_check();
  virtual set<IIR_Declaration> *_find_declarations( IIR_Name * );
  IIR *_clone();

#ifdef PROCESS_COMBINATION
  void _static_elaborate( IIR_ArchitectureDeclaration*, 
			  IIR_DeclarationList*, char* );
  bool _convert_to_TWF();
#endif

  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _get_signal_source_info(set<IIR_Declaration>* siginfo);
  void _build_wait_list();

  // This function publishes all the implicit declarations of the
  // declarations visible in the process statement part
  void _publish_cc_implicit_declarations(IIR_Declaration* decl);

  dl_list<IIR_WaitStatement> _wait_stmt_list;

  void _publish_cc_concurrent_stmt_init(IIR_DeclarationList* decl_list);

protected:
  IIRScram_ProcessStatement();
  virtual ~IIRScram_ProcessStatement() = 0;
    
private:

  //The VHDL objects namely the signal and variable has to be specified
  //while declaring the type. The type of object namely the signal or
  //Variable is specified in the constructor of the state classes that is
  //generated.
  void _publish_cc_state_objects_init(set<IIR_Declaration>*);
  void _publish_cc_headers();
  void _publish_cc_state_class();
  void _publish_cc_constructor();
  void _publish_cc_initstate();
  void _publish_cc_cleanstate();
  void _publish_cc_locatesignal();
  void _publish_cc_ostream_operator();
  void _publish_cc_print();
  void _publish_cc_operator_equalto();
  void _publish_cc_wait_init();

  void _publish_cc_composite_resolved_signal_init();

  void _publish_cc_read_or_write(const char *, const char *);
  void _publish_cc_serialize_state(const char *procName);
  void _publish_cc_deserialize_state(const char *procName);
  
  //The following function clears the newly set code generation attributes
  //in any of the previous process Statements.
  //code generation attributes are the data members in the IIRScram* nodes.
  //NEED: 
  //The Signals and other objects that are defined in Architecture decls
  //are visible throughout. Certain attributes are added to such nodes
  //While generating code for process Statements. They should be cleared 
  //while publishing a new process Statement
  void _clear();

};
#endif
