// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_StringLiteral.cc,v 1.2 1999/03/09 20:56:47 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_StringLiteral.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "StandardPackage.hh"
#include "set.hh"
#include "IIR_AccessTypeDefinition.hh"
#include <ctype.h>

class IIR_AccessTypeDefinition;

IIRScram_StringLiteral::IIRScram_StringLiteral(){
}


IIRScram_StringLiteral::~IIRScram_StringLiteral(){
}


void
IIRScram_StringLiteral::_publish_cc_string() {
  IIRScram_TextLiteral::_publish_cc();
}


void
IIRScram_StringLiteral::_publish_cc() {
  IIR_TypeDefinition *type = _get_subtype();
  
  if(type != NULL) {
    ASSERT(type->_is_resolved() == TRUE);
    
    if (type->_is_anonymous() == TRUE) {
      if (type->_get_base_type() != NULL) {
	type = type->_get_base_type();
      }
      else {
	// Just ensuring other conditions that should be to be okay.
	if ( type->_get_type_mark() != NULL ) {
	  // Atta boy, Dale, thanks for the type_mark
	  // Just make sure this is not anonymous!!
	  ASSERT ( type->_get_type_mark()->_is_anonymous() == FALSE );
	  type = type->_get_type_mark();
	}
      }
    }
    
    if(type != StandardPackage::savant_null_type_definition) {
      type->_publish_cc_type_name();
    }
    else {
      _cc_out << "AccessType";
    }
    
    if (type->get_kind() != IIR_ACCESS_TYPE_DEFINITION) {
      _cc_out << "(ObjectBase::VARIABLE, ";
      if((type->_is_anonymous() == TRUE) || (type->_is_unconstrained_array_type() == TRUE)) {
	_publish_cc_range();
	_cc_out << ", ";	
      }
      _publish_cc_string();
      if ((type->_is_unconstrained_array_type() == TRUE) &&
	  (type->_get_element_subtype()->_is_scalar_type() == TRUE)) {
	type->_get_element_subtype()->_publish_cc_object_type_info();
      }
      _cc_out << ")";
    }
    else {
      ASSERT(IIR_TextLiteral::_cmp(this, "null") == 0);
      _cc_out << "()";
    }
  }  
  else {
    _publish_cc_string();
  }
}
  

void
IIRScram_StringLiteral::_publish_cc_range() {
  int i;
  IIR_Int32 length = get_text_length();
  int funkyChars = 0;
  IIR_TypeDefinition *index_type = _get_subtype()->_get_index_subtype();
  if (index_type->_is_scalar_type() == TRUE) {
    index_type->_get_base_type_left()->_publish_cc_value();
    _cc_out << ", ";
  }
  //   _cc_out << "1, to, ";
  // A string can be confined within quotes or percetages but if we 
  // have percentages as delimiters of strings we cannot have quotes inside
  if ((*this)[0] != '%') {
    for( i = 1; i < length-1; i++ ){
      // Check for two consecutive double quotes.
      if (((*this)[i] == '\"') && ((*this)[(i + 1)] == '\"')) {	//"
	i++;
	funkyChars++;
      }
    }
  } else {
    // A string whose delimiters are percentages
    for( i = 1; i < length-1; i++ ){
      // Check for two consecutive double quotes.
      if (((*this)[i] == '%') && ((*this)[(i + 1)] == '%')) {	
	i++;
	funkyChars++;
      }
    }
  }

  if (index_type->_get_base_type_direction()->_is_ascending_range() == TRUE) {
    _cc_out << " to, ";
    index_type->_get_base_type_left()->_publish_cc_value();
    _cc_out << " + ";
  }else {
    _cc_out << " downto, ";
    index_type->_get_base_type_left()->_publish_cc_value();
    _cc_out << " - ";
  }
  _cc_out << (length - funkyChars - 3); //omit quotes
}


void 
IIRScram_StringLiteral::_publish_cc_state_object_init() {
  _cc_out << " ";
  if(_get_subtype()->_is_iir_access_type_definition() != TRUE) {
    _cc_out << "*";
  }
  _cc_out << "(new ";
  _publish_cc();
  _cc_out << ")";
}


//This function is used to creat objects of corresponding type 
//when string literals are compared with objects of VHDLTypes
void 
IIRScram_StringLiteral::_publish_cc_condition() {
  //_current_publiish_node is set during conditions in case statements
  IIR_TypeDefinition* type;
  type = _current_publish_node->_get_subtype();
  ASSERT(type != NULL);
  type->_publish_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE, ";
  if(type->_is_anonymous() == TRUE) {
    _publish_cc_range();
    _cc_out << ", ";
  }
  _publish_cc_string();
  _cc_out << ")";
}


void 
IIRScram_StringLiteral::_publish_cc_initialization_value() {
  _publish_cc_string();
}


void 
IIRScram_StringLiteral::_publish_cc_without_quotes() {
  IIR_Int32 length = get_text_length();
  register int i;

  if((*this)[0] == '\'') {
    i = 1;
  } else {
    i = 0;
  }

  for (; i < length-1; i++) { 
    _cc_out << (*this)[i];
  }

  if((*this)[length-1] != '\'') {
    _cc_out << (*this)[length-1];
  }
}


void 
IIRScram_StringLiteral::_publish_cc_function_name() {
  IIR_Int32 length = get_text_length();
  IIR_Char c;

  _cc_out << "savant";
  for (register int i = 1; i < length-1; i++) { 
    c = (*this)[i];
    if(isalnum(c)) {
      _cc_out << c;
    } else {
      switch(c) {
      case '=':	
	_cc_out << "Equal"; break;
      case '/':	
	if(i+1 < length-1 && (*this)[i+1] == '=') {
	  _cc_out << "NotEqual"; i++; 
	} else {
	  _cc_out << "Divide";
	}	  
	break;
      case '<':	
	if(i+1 < length-1 && (*this)[i+1] == '=') {
	  _cc_out << "LessThanOrEqual"; i++; 
	} else {
	  _cc_out << "LessThan";
	}	  
	break;
      case '>':	
	if(i+1 < length-1 && (*this)[i+1] == '=') {
	  _cc_out << "GreaterThanOrEqual"; i++; 
	} else {
	  _cc_out << "GreaterThan";
	}	  
	break;
      case '+':	_cc_out << "Plus"; break;
      case '-':	_cc_out << "Minus"; break;
      case '&':	_cc_out << "Concatenate"; break;
      case '*':	
	if(i+1 < length-1 && (*this)[i+1] == '*') {
	  _cc_out << "Pow"; i++; 
	} else {
	  _cc_out << "Multiply";
	}	  
	break;
      default:
	cerr << "IIRScram_StringLiteral::_publish_cc_function_name()::"
	     << "Unknown operator `" << c << "\'" << endl;
      }	// switch
    } // else 
  } // for
}


void
IIRScram_StringLiteral::_convert_function_name(ostrstream &os, IIR_Boolean _is_unary_operator)
{
  IIR_Int32 length = get_text_length();
  IIR_Char c;
  
  os << "savant";
  for (register int i = 1; i < length-1; i++) { 
    c = (*this)[i];
    if (i == 1) {
      c = toupper(c);
    }
    
    if(isalnum(c)) {
      os << c;
    } else {
      switch(c) {
      case '=':	
	os << "Equal"; break;
      case '/':	
	if(i+1 < length-1 && (*this)[i+1] == '=') {
	  os << "NotEqual"; i++; 
	} else {
	  os << "Divide";
	}	  
	break;
      case '<':	
	if(i+1 < length-1 && (*this)[i+1] == '=') {
	  os << "LessThanOrEqual"; i++; 
	} else {
	  os << "LessThan";
	}	  
	break;
      case '>':	
	if(i+1 < length-1 && (*this)[i+1] == '=') {
	  os << "GreaterThanOrEqual"; i++; 
	} else {
	  os << "GreaterThan";
	}	  
	break;
      case '+':
	if (_is_unary_operator == TRUE)  {
	  os << "Unary";
	}
	os << "Plus";
	break;
      case '-':
	if (_is_unary_operator == TRUE)  {
	  os << "Unary";
	}
	os << "Minus";
	break;
      case '&':	os << "Concatenate"; break;
      case '*':	
	if(i+1 < length-1 && (*this)[i+1] == '*') {
	  os << "Pow"; i++; 
	} else {
	  os << "Multiply";
	}	  
	break;
      default:
	cerr << "IIRScram_StringLiteral::_publish_cc_function_name()::"
	     << "Unknown operator `" << c << "\'" << endl;
      }	// switch
    } // else 
  } // for
}


void 
IIRScram_StringLiteral::_publish_cc_universal_value() {
  _publish_cc_string();
}


void
IIRScram_StringLiteral::_publish_cc_bounds() {
  _cc_out << "nullInfo";
}


void 
IIRScram_StringLiteral::_publish_cc_headers() {
  if(_get_subtype() != NULL) {
    _get_subtype()->_publish_cc_headers();
  } else {
    _cc_out << "#include \"SavantstringType.hh\"" << endl;
  }
}


void 
IIRScram_StringLiteral::_publish_cc_variable_name() {
  IIR_Int32 length = get_text_length();
  register int i;

  if((*this)[0] == '\'') {
    _cc_out << "_";
    i = 1;
  } else {
    i = 0;
  }

  for (; i < length-1; i++) { 
    if(isalnum((*this)[i])) {
      _cc_out << (*this)[i];
    } else {
      _cc_out << (unsigned int)(*this)[i];
    }
  }

  if((*this)[length-1] != '\'') {
    if(isalnum((*this)[i])) {
      _cc_out << (*this)[length-1];
    } else {
      _cc_out << (unsigned int)(*this)[length-1];
    }
  }
  else {
    _cc_out << "_";
  }
}


void 
IIRScram_StringLiteral::_type_check( set<IIR_TypeDefinition> * ){
}


set<IIR_TypeDefinition> *
IIRScram_StringLiteral::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ){
  if( _cmp( this, "null" ) == 0 ){
    return new set<IIR_TypeDefinition>( (IIR_TypeDefinition *)StandardPackage::savant_null_type_definition);
  }
  else{
    return _get_rval_set_for_string();
  }
}

IIR*
IIRScram_StringLiteral::_clone() {
  return this;
}
