#ifndef STANDARD_PACKAGE_HH
#define STANDARD_PACKAGE_HH

#include "IIR_PackageDeclaration.hh"

class IIR_EnumerationTypeDefinition;
class IIR_IntegerSubtypeDefinition;
class IIR_FloatingSubtypeDefinition;
class IIR_PhysicalSubtypeDefinition;
class IIR_ArrayTypeDefinition;
class IIR_AttributeDeclaration;
class IIR_TypeDeclaration;
class IIR_SubtypeDeclaration;
class IIR_FunctionDeclaration;
class IIR_TypeDefinition;
class IIR_ScalarTypeDefinition;
class IIR_PhysicalUnit;
class IIR_LibraryDeclaration;
class IIR_AccessTypeDefinition;

class StandardPackage : public IIR_PackageDeclaration {
public:

  // Boolean has to be defined before anything else
  static IIR_EnumerationTypeDefinition *boolean_type;
  static IIR_TypeDeclaration *boolean_decl;

  // Here are the builtin universal types.
  static IIR_IntegerSubtypeDefinition *savant_universal_integer;
  static IIR_FloatingSubtypeDefinition *savant_universal_real;

  // These types represent those declared in std.standard.
  static IIR_EnumerationTypeDefinition *bit_type;
  static IIR_TypeDeclaration *bit_decl;

  static IIR_IntegerSubtypeDefinition *integer_type;
  static IIR_TypeDeclaration *integer_decl;

  static IIR_EnumerationTypeDefinition *character_type;
  static IIR_TypeDeclaration *character_decl;

  static IIR_IntegerSubtypeDefinition *positive_type;
  static IIR_SubtypeDeclaration *positive_decl;

  static IIR_ArrayTypeDefinition *string_type;
  static IIR_TypeDeclaration *string_decl;

  static IIR_EnumerationTypeDefinition *severity_level_type;
  static IIR_TypeDeclaration *severity_level_decl;

  static IIR_FloatingSubtypeDefinition *real_type;
  static IIR_TypeDeclaration *real_decl;

  static IIR_PhysicalSubtypeDefinition *time_type;
  static IIR_TypeDeclaration *time_decl;

  static IIR_PhysicalSubtypeDefinition *delay_length_type;
  static IIR_SubtypeDeclaration *delay_length_decl;

  static IIR_IntegerSubtypeDefinition *natural_type;
  static IIR_SubtypeDeclaration *natural_decl;

  static IIR_ArrayTypeDefinition *bit_vector_type;
  static IIR_TypeDeclaration *bit_vector_decl;

  static IIR_EnumerationTypeDefinition *file_open_kind_type;
  static IIR_TypeDeclaration *file_open_kind_decl;

  static IIR_EnumerationTypeDefinition *file_open_status_type;
  static IIR_TypeDeclaration *file_open_status_decl;

  static IIR_AttributeDeclaration *foreign_decl;
  static IIR_FunctionDeclaration *now_decl;

  static void fill_list( IIR_DeclarationList * );

  static IIR_LibraryDeclaration *std_decl;
  static StandardPackage *std_standard_decl;

  // This is a Savant specific extension
  static IIR_AccessTypeDefinition *savant_null_type_definition;


  ~StandardPackage(){}
  
private:
  StandardPackage();

  static IIR_IntegerSubtypeDefinition *init_integer_type();
  static IIR_IntegerSubtypeDefinition *init_positive_type();
  static IIR_IntegerSubtypeDefinition *init_natural_type();
  static IIR_FloatingSubtypeDefinition *init_real_type();
  static IIR_EnumerationTypeDefinition *init_boolean_type();
  static IIR_EnumerationTypeDefinition *init_bit_type();
  static IIR_EnumerationTypeDefinition *init_character_type();
  static IIR_EnumerationTypeDefinition *init_severity_level_type();
  static IIR_EnumerationTypeDefinition *init_file_open_kind_type();
  static IIR_EnumerationTypeDefinition *init_file_open_status_type();
  static IIR_ArrayTypeDefinition *init_string_type();
  static IIR_ArrayTypeDefinition *init_bit_vector_type();
  static IIR_PhysicalSubtypeDefinition *init_time_type();
  static IIR_PhysicalSubtypeDefinition *init_delay_length_type();
  static IIR_AttributeDeclaration *init_foreign_decl();
  static IIR_FunctionDeclaration *init_now_decl();
  static IIR_LibraryDeclaration *init_std_decl();
  static IIR_AccessTypeDefinition *init_null_type();

  static IIR_TypeDeclaration *init_type_decl( char *, IIR_TypeDefinition * );  
  static IIR_SubtypeDeclaration *init_subtype_decl( char *, IIR_TypeDefinition * );  

  static IIR_EnumerationTypeDefinition *init_enumeration_type( char *[],
								     IIR_EnumerationTypeDefinition * = 0 );  
  static IIR_ArrayTypeDefinition *
  init_unconstrained_array_type(  IIR_ScalarTypeDefinition *index_type,
				  IIR_TypeDefinition *element_type );

  static IIR_IntegerSubtypeDefinition *
  init_integer_type( int left_bound, int right_bound );

  static IIR_IntegerSubtypeDefinition *
  init_integer_type( int left_bound, IIR *right_bound );

  static IIR_FloatingSubtypeDefinition *
  init_real_type( double left_bound, double right_bound );
  
  static void set_locator_info( IIR * );
  static IIR_PhysicalUnit *find_unit( char *name, IIR_PhysicalSubtypeDefinition *physical_type );

  struct unit {
    char *unit_name;
    int multiplier;
    char *base_unit;
  };

  static IIR_PhysicalSubtypeDefinition *
  init_physical_type( int,
		      int,
		      char *,
		      struct unit[] );

  static StandardPackage *init_std_standard();

  static int STD_INT_MAX;
  static int STD_INT_MIN;
  static double REAL_MAX;
  static double REAL_MIN;  
  static IIR_Identifier *file_info;
  static char *file_string;
};

#endif
