//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef ARRAY_INFO_HH
#define ARRAY_INFO_HH
#include <iostream.h>
#include "bool.hh"

enum ArrayDirn_t { to = 1, downto = -1 };

class ArrayInfo {
  friend ostream& operator<<(ostream&, const ArrayInfo&);

private:
  int lbound;
  int rbound;
  ArrayDirn_t direction;

public:
  ArrayInfo();
  ArrayInfo(int, ArrayDirn_t, int);
  ArrayInfo(const ArrayInfo&);
  int length() const;
  bool operator==(const ArrayInfo&) const;
  bool operator!=(const ArrayInfo&) const;
  bool is_null_range();

  ArrayInfo& operator=(const ArrayInfo&);
  bool contains(int) const;
  int storageIndex(int) const;
  //The following function returns the actual index
  //specified from the vhdl code from the positional index
  //The positional index starts from 0 onwards.
  //so 0 is converted to left() and so on.
  int actualIndex(int) const;

  int left() const { return lbound;}
  int right() const { return rbound;}
  ArrayDirn_t dirn() const { return direction;}
  int rightof(int i) const {
    if (i == rbound) {
      cerr << "ArrayInfo::rightof: can't take rightof right bound!\n("
	   << lbound << " " << (int) direction << " " << rbound << ")" << endl;
      abort();
    }
    return i + (int)direction;
  }
};

inline ostream& operator<<(ostream& os, ArrayDirn_t ad) {
  switch (ad) {
  case to:
    os << "to";
    break;
  case downto:
    os << "downto";
    break;
  default:
    os << "(invalid ArrayDirn)";
    break;
  }
  return os;
}


inline ostream& operator<<(ostream&os, const ArrayInfo& ai) {
  os << "(" << ai.lbound << " " << ai.direction << " " << ai.rbound << ")";
  return os;
}

extern const ArrayInfo defaultInfo;
extern const ArrayInfo Others;
extern const ArrayInfo nullInfo;

#endif
