#include "TypeInfo.hh"
#include "IntegerType.hh"
#include "EnumerationType.hh"
#include "RealType.hh"

TypeInfo
TypeInfo::NULL_TYPE_INFO;

//The constructor for rangeInfo
rangeInfo::rangeInfo() {
  left  = 0;
  right = -1;
  dirn  = to;
}

rangeInfo::rangeInfo(const rangeInfo &ri) {
  left  = ri.left;
  dirn  = ri.dirn;
  right = ri.right;
}

rangeInfo::rangeInfo(int l, ArrayDirn_t d, int r){
  left  = l;
  dirn  = d;
  right = r;
}

rangeInfo::rangeInfo(IntegerType& lbound, ArrayDirn_t d, IntegerType& rbound){
  left = (UniversalInteger&) lbound.getVHDLData();
  dirn = d;
  right = (UniversalInteger&) rbound.getVHDLData();
}

//Member functions of rangeInfo
int
rangeInfo::get_left() const{
  return left;
}

ArrayDirn_t 
rangeInfo::get_direction() const{
  return dirn;
}

int
rangeInfo::get_right() const{
  return right;
}

rangeInfo&
rangeInfo::operator=(const rangeInfo &ri) {
  left  = ri.left;
  dirn  = ri.dirn;
  right = ri.right;
  
  return *this;
}

//The constructors for enumInfo
enumInfo::enumInfo() {
  imageMap       = NULL;
  no_of_elements = 0;
  dirn           = to;
  left           = 0;
}

enumInfo::enumInfo(int n, char** image, int l, ArrayDirn_t d)  {
  imageMap       = image;
  no_of_elements = n;
  dirn           = d;
  left           = l;
}

enumInfo::~enumInfo() {
}

enumInfo::enumInfo(const enumInfo& ei) {
  imageMap       = ei.imageMap;
  no_of_elements = ei.no_of_elements;
  dirn           = ei.dirn;
  left           = ei.left;
}

char **
enumInfo::get_imageMap() const{
  return imageMap;
}

int
enumInfo::get_no_of_elements() const{
  return no_of_elements;
}

int 
enumInfo::get_left() const{
  return left;
}

int 
enumInfo::get_right() const{
  if (dirn == to) {
    return get_no_of_elements() - 1 + left;
  }
  else {
    return left - get_no_of_elements() + 1;
  }
}

enumInfo&
enumInfo::operator=(const enumInfo &ei) {
  imageMap       = ei.imageMap;
  no_of_elements = ei.no_of_elements;
  dirn           = ei.dirn;
  left           = ei.left;
  
  return *this;
}
  
ArrayDirn_t 
enumInfo::get_direction() const{
  return dirn;
}

//The constructor for realInfo
realInfo::realInfo() {
  left  = 0;
  right = -1;
  dirn  = to;
}

realInfo::realInfo(const realInfo &ri) {
  left  = ri.left;
  right = ri.right;
  dirn  = ri.dirn;
}

realInfo&
realInfo::operator=(const realInfo &ri) {
  left  = ri.left;
  right = ri.right;
  dirn  = ri.dirn;

  return *this;
}

realInfo::realInfo(double l, ArrayDirn_t d, double r){
  left  = l;
  dirn  = d;
  right = r;
}

realInfo::realInfo(RealType& lbound, ArrayDirn_t d, RealType& rbound){
  left = (UniversalReal&) lbound.getVHDLData();
  dirn = d;
  right = (UniversalReal&)rbound.getVHDLData();
}

//Member functions of realInfo
double
realInfo::get_left() const{
  return left;
}

ArrayDirn_t 
realInfo::get_direction() const{
  return dirn;
}

double
realInfo::get_right() const{
  return right;
}

//The constructors for phyInfo

phyInfo::phyInfo() {
  dirn  = to;
  left  = 0;
  right = -1;
  no_of_elements = 0;

  unitInfo  = NULL;
  scaleInfo = NULL;
}

phyInfo::phyInfo(const phyInfo &pi) {
  no_of_elements = pi.no_of_elements;
  unitInfo       = pi.unitInfo;
  scaleInfo      = pi.scaleInfo;
  dirn           = pi.dirn;
  left           = pi.left;
  right          = pi.right;
}

phyInfo&
phyInfo::operator=(const phyInfo &pi) {
  no_of_elements = pi.no_of_elements;
  unitInfo       = pi.unitInfo;
  scaleInfo      = pi.scaleInfo;
  dirn           = pi.dirn;
  left           = pi.left;
  right          = pi.right;

  return *this;
}

phyInfo::phyInfo(int n, LONG l, ArrayDirn_t d, LONG r,
		 LONG* sInfo, char** uInfo){
  int i; 
  dirn = d;
  left = l;
  right = r;
  no_of_elements = n;
  
  unitInfo = (char **) new char[n * sizeof(char*)];
  for(i=0;i < n;i++){
    unitInfo[i] = new char[strlen(uInfo[i]) * sizeof(char)];
    unitInfo[i] = uInfo[i];
  }
  scaleInfo = (LONG*) new char[n * sizeof(LONG)];
  for(i=0;i < n;i++){
    scaleInfo[i] = sInfo[i];
  }
}

int
phyInfo::get_no_of_elements() const {
  return no_of_elements;
}

LONG
phyInfo::get_left() const {
  return left;
}

LONG
phyInfo::get_right() const {
  return right;
}

ArrayDirn_t
phyInfo::get_direction() const {
  return dirn;
}

LONG*
phyInfo::get_scale_info() const {
  return scaleInfo;
}

char **
phyInfo::get_unit_info() const {
  return unitInfo;
}

char *
phyInfo::get_unit(int i) const{
  return unitInfo[i];
}

LONG
phyInfo::get_scale(int i) const {
  return scaleInfo[i];
}

// Member functions of arrayTypeInfo

//arrayTypeInfo constructors
arrayTypeInfo::arrayTypeInfo(){
  ranges         = NULL;
  noofDimensions = 0;
}

arrayTypeInfo::arrayTypeInfo(int dim, rangeInfo* rInfo){
  noofDimensions = dim;
  ranges         = rInfo; 
}

arrayTypeInfo::arrayTypeInfo(const arrayTypeInfo& aInfo){
  noofDimensions = aInfo.noofDimensions;
  ranges         = aInfo.ranges;
}

rangeInfo*
arrayTypeInfo::get_rangeInfo() const {
  return ranges;
}

int
arrayTypeInfo::get_dimensions() const {
  return noofDimensions;
}
