//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VHDL_KERNEL_STATE_HH
#define VHDL_KERNEL_STATE_HH

// This class has been created for savant interface alone. This
// has some basic members needed for any state in Savant. 

#include "BasicState.hh"
#include "CallStack.hh"
#include "Block.hh"
#include "SimulationObj.hh"

class Wait;
class SignalBase;
class _savant_entity_elab;
class VHDLKernelBase;

class VHDLKernel_state : public BasicState {
public:
  VHDLKernel_state();
  ~VHDLKernel_state();
  virtual void initState(_savant_entity_elab *, VHDLKernelBase*);
  VHDLKernel_state& operator=(VHDLKernel_state&);

  CallStack stack;
  Wait *procWait;
  Wait *wait;
  int waitLabel;
  VTime waitTime;
  bool waitExpired;

  // The new set of functions for the new style of state saving
  // mechanism that is going to be in-place.

  // This is the copyState function that merely does what operator= used to
  // do. This will be the new interface. Obviously savant should erloads this
  // guy with the published code.
  
  virtual void copyState( BasicState * );

  // This function too will be needed in the new interface. This function
  // should be published by savant. The kernel version will bitch when called.
  
  virtual int getSize() const;

  virtual SignalBase* locateSig(int) = 0;
  virtual void cleanState() = 0;

  virtual void serialize(ofstream *, int);
  virtual void deserialize(ifstream *);
  virtual void deserialize(ifstream *, SimulationObj *);
};

#endif

