#include "VTime.hh"
#include "TypeKind.hh"
#include "Variable.hh"
#include "AccessVariable.hh"
#include "VHDLType.hh"
#include "AccessType.hh"
#include "SavantlineType.hh"
#include "SignalBase.hh"
#include "ObjectBase.hh"
#include "RecordType.hh"
#include "SignalNetinfo.hh"
#include "SourceBase.hh"
#include "VHDLKernelBase.hh"

char* VHDLType::getString() const {
  cerr << " ERROR !!!! VHDLType::getString() called "<< endl;
  return NULL;
}

VHDLType&
VHDLType::operator=(const VHDLType&) {
  cerr << "VHDLType::operator = called" << endl;
  abort();
  return *this;		// Just to keep CC quiet.
}

VHDLType&
VHDLType::assignVal(const VHDLType& val) {
  return (*this = val);
}

VHDLType& 
VHDLType::operator[](const int) const { 
  cerr << "VHDLType::operator[] called" << endl;
  abort();
  return (VHDLType&)(*this);		// Just to keep CC quiet.
}

// VHDLType&
// VHDLType::operator[](const ScalarType&) const { 
//   cerr << "VHDLType::operator[](const ScalarType&) called" << endl;
//   abort();
//   return (VHDLType&)(*this);		// Just to keep CC quiet.
// }

void 
VHDLType::setRange(ObjectBase::ObjectType, ArrayInfo*, int, const TypeInfo &) {
  cerr << "ERROR: VHDLType::setRange(ObjectBase::ObjectType, ArrayInfo*, int) called " << endl;
}

void
VHDLType::setRange(ObjectBase::ObjectType, VectorBase*) {
  cerr << "ERROR: VHDLType::setRange(ObjectBase::ObjectType, VectorBase*) called " << endl;
}

Type
VHDLType::get_kind() const {
  return NO_TYPE;
}

int
VHDLType::get_number_of_elements() const {
  cerr << " ERROR !!!! VHDLType::get_number_of_elements() called "<< endl;
  return -1;
}

VHDLType& 
VHDLType::get_element(const int ) const {
  cerr << " ERROR !!!! VHDLType::get_element() called "<< endl;
  return *(VHDLType *) this;
}

ArrayInfo*
VHDLType::get_bounds() const {
  return NULL;
}

int 
VHDLType::left() const {
  cerr << "ERROR: VHDLType::left() called." << endl;
  return -1;
}

int 
VHDLType::right() const {
  cerr << "ERROR: VHDLType::left() called." << endl;
  return -1;
}

ArrayDirn_t 
VHDLType::dirn() const {
  cerr << "ERROR: VHDLType::left() called." << endl;
  return to;
}

int 
VHDLType::length() const {
  cerr << "ERROR: VHDLType::left() called." << endl;
  return -1;;
}

void
VHDLType::setResolutionFunctionId(int) {
  cerr << "ERROR: VHDLType::setResolutionFunctionId(int) called." << endl;
  abort();
}

void
VHDLType::setTypeConversionFunctionId(int) {
  cerr << "ERROR: VHDLType::setTypeConversionFunctionId(int) called." << endl;
  abort();
}

void
VHDLType::setElaborationInfo(const VHDLType &) {
  cerr << "ERROR VHDLType::setElaborationTnfo(VHDLType&) called" << endl;
  abort();
}

void
VHDLType::setNumAttributes(int) {
  cerr << "ERROR VHDLType::setNumAttribues(int) called" << endl;
  abort();
}

void
VHDLType::setAttrib(AttribType, VHDLType&) {
  cerr << "ERROR VHDLType::setAttrib(AttribType, VHDLType&) called" << endl;
  abort();
}

void
VHDLType::updateEffVal(const VHDLType*) {
  cerr << "updateEffVal for VHDLType not implemented" << endl;
}

void
VHDLType::dump_connectivity_info(ofstream&) {
  cerr << "dump_connectivity_info for VHDLType not implemented" << endl;
}
//The TYPE's resolve is called only for composite resolved signals
//This resolve goes down to first sub-element of the VHDLType and
//calls the sub-elements resolve, but which actually does the resolution
//for the whole composite type
VHDLType*
VHDLType::resolve(VHDLKernelBase*) {
  cerr << "resolve(VHDLKernelBase*) for VHDLType not implemented" << endl;
  return NULL;
}

bool eatwhite(AccessVariable<char*>& line) {
  if (line.curPos >= line.dataLength) {
    cout << "VHDLType::eatwhite: line variable " << line.name
	 << " is empty!\n\n";
    line.print(cout);
    cout << endl;
    return false;
  }

  // skip any whitespace
  while ((line.val[line.curPos] == ' ') || 
	 (line.val[line.curPos] == '\t')) {
    line.curPos++;
    if (line.curPos == line.dataLength) {
      // line exhausted, no bit found
      cerr << " VHDLType::eatwhite Warning: EOL reached" << endl;
      return false;
    }
  }
  return true;
}

void assignVariable(VHDLType& dest, const VHDLType& src, 
		    const ArrayInfo& dinfo, const ArrayInfo& sinfo){
  
  int i = 0;
  // These manage the bounds even if "sinfo" or "dinfo" are NULL.
  // Required for concatenation operator, where it is difficult to find
  // the size of the bounds at compile time.
  ArrayInfo* src_ainfo  = (ArrayInfo *) &sinfo;
  ArrayInfo* dest_ainfo = (ArrayInfo *) &dinfo;
  
  switch (dest.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    dest.getObject()->updateVal(src.getObject()->readVal());
    break;
  case ARRAY_TYPE: {
        
    if ((sinfo == defaultInfo) || (sinfo == nullInfo)) {
      src_ainfo = src.get_bounds();
    }
    if ((dinfo == defaultInfo) || (dinfo == nullInfo)) {
      dest_ainfo = dest.get_bounds();
    }
    
    int dest_counter   = dest_ainfo->left();
    int dest_increment = dest_ainfo->dirn();
    int src_counter    = src_ainfo->left();
    int src_increment  = src_ainfo->dirn();
    
    for(i = 0; (i < dest_ainfo->length()); i++) {
      assignVariable(dest[dest_counter], src[src_counter], nullInfo, nullInfo);
      dest_counter += dest_increment;
      src_counter  += src_increment;
    }
    break;
  }
  
  case RECORD_TYPE:
    assignVariable((RecordType &) dest, (RecordType &) src, nullInfo,
		   nullInfo);
    break;
    
  case VECTOR_BASE: {
    if ((sinfo == defaultInfo) || (sinfo == nullInfo)) {
      src_ainfo = src.get_bounds();
    }
    if ((dinfo == defaultInfo) || (dinfo == nullInfo)) {
      dest_ainfo = dest.get_bounds();
    }
    
    int dest_counter   = dest_ainfo->left();
    int dest_increment = dest_ainfo->dirn();
    int src_counter    = src_ainfo->left();
    int src_increment  = src_ainfo->dirn();
    
    for(i = 0; (i < dest_ainfo->length()); i++) {
      assignVariable(dest[dest_counter], src[src_counter], nullInfo, nullInfo);
      dest_counter += dest_increment;
      src_counter  += src_increment;
    }
    break;
  }
  
  case ACCESS_TYPE:
    ((AccessType&)dest).setPointer((VHDLType*)&src);
    break;
    
  default:
    cerr << "Unknown type found in assignVariable" << endl;
    break;
  }
}

int
VHDLType::savantwrite(AccessVariable<char*> &line) const{
  switch (this->get_kind()) {
  case ARRAY_TYPE:
    return ((ArrayType *) this)->savantwrite(line);
  case RECORD_TYPE:
    return ((RecordType *) this)->savantwrite(line);
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    return ((ScalarType *) this)->savantwrite(line);
  default:
    cerr << "ERROR: VHDLType's savantwrite called with unkown kind" << endl;
    return NORMAL_RETURN;
  }
}

int
VHDLType::savantread(AccessVariable<char*> &line) {
  switch (this->get_kind()) {
  case ARRAY_TYPE:
    return ((ArrayType *) this)->savantread(line);
  case RECORD_TYPE:
    return ((RecordType *) this)->savantread(line);
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    return ((ScalarType *) this)->savantread(line);
  default:
    cerr << "ERROR: VHDLType's savantwrite called with unkown kind" << endl;
    return NORMAL_RETURN;
  }  
}

int
VHDLType::savantwrite(SavantlineType &line) const{
  switch (this->get_kind()) {
  case ARRAY_TYPE:
    return ((ArrayType *) this)->savantwrite(line);
  case RECORD_TYPE:
    return ((RecordType *) this)->savantwrite(line);
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    return ((ScalarType *) this)->savantwrite(line);
  case VECTOR_BASE:
    return ((VectorBase *) this)->savantwrite(line);
  default:
    cerr << "ERROR: VHDLType's savantwrite called with unkown kind" << endl;
  }
  
    return 0;
}

int
VHDLType::savantread(SavantlineType &line) {
  switch (this->get_kind()) {
  case ARRAY_TYPE:
    return ((ArrayType *) this)->savantread(line);
  case RECORD_TYPE:
    return ((RecordType *) this)->savantread(line);
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    return ((ScalarType *) this)->savantread(line);
  default:
    cerr << "ERROR: VHDLType's savantwrite called with unkown kind" << endl;
  }
  
  return 0;
}

void
VHDLType::setParentCompositeType(VHDLType*) {
  cerr << "ERROR: VHDLType's setParentCompositeType(VHDLType* ptr)"
       << " called with unkown kind" << endl;
}

void
VHDLType::setCompositeResolvedSignal(bool) {
  cerr << "ERROR: VHDLType's setCompositeResolvedSignal(VHDLType* ptr)"
       << " called with unkown kind" << endl;
}

bool
VHDLType::is_driver_already_set() const
{
  switch(get_kind()) {
  case ARRAY_TYPE:
    return (((ArrayType *) this)->get_element(0)).is_driver_already_set();
  case RECORD_TYPE:
    return (((RecordType *) this)->get_field(1)).is_driver_already_set();
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    return ((SignalNetinfo *) (this->getObject()))->get_driver_added_flag();
  default:
    return false;
  }
}

bool
VHDLType::is_resolved_signal() const
{
  switch (get_kind()) {
  case RECORD_TYPE:
    return (((RecordType *) this)->get_field(1)).is_resolved_signal();
    break;

  case ARRAY_TYPE:
    return (((ArrayType *) this)->get_element(0)).is_resolved_signal();
    break;

  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    if ( (((SignalNetinfo *) (this->getObject()))->source != NULL) &&
	 (((SignalNetinfo *) (this->getObject()))->source->getResolutionFnId() != DEFAULT_ID) ) {
      return true;
    }
    break;
    
  default:
    cerr << "Error! : is_resolved_signal() called on invalid kernel type\n";
    abort();
  }
  return false;
}

void
VHDLType::initializeImplicitSignal(AttribType) {
  cerr << " ERROR !!!! VHDLType::initializeImplicitSignal(AttribType) called "<< endl;
}

EnumerationType
savantEqual(const VHDLType& lhs, const VHDLType& rhs) {
  switch(lhs.get_kind()) {
  case INTEGER_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
  case REAL_TYPE:
    return savantEqual((const ScalarType&) lhs, (const ScalarType&) rhs);
    break;
  case ARRAY_TYPE:
    return savantEqual((const ArrayType&) lhs, (const ArrayType&) rhs);
    break;
  case VECTOR_BASE:
    return savantEqual((const VectorBase&) lhs, (const VectorBase&) rhs);
    break;
  case RECORD_TYPE:
    return savantEqual((const RecordType&) lhs, (const RecordType&) rhs);
    break;
  case ACCESS_TYPE:
    return savantEqual((const AccessType&) lhs, (const AccessType&) rhs);
    break;
  default:
    cerr << __FILE__ << ":" << __LINE__
	 << "savantEqual of an unknown type called!! Aborting.";
    abort();
  }
  return ENUMERATION_FALSE;
}

EnumerationType
savantNotEqual(const VHDLType& lhs, const VHDLType& rhs) {
  EnumerationType val = savantEqual(lhs, rhs);

  if(val == ENUMERATION_TRUE) {
    return ENUMERATION_FALSE;
  } else {
    return ENUMERATION_TRUE;
  }
}

EnumerationType
savantLessThan(const VHDLType& lhs, const VHDLType& rhs) {
  switch(lhs.get_kind()) {
  case INTEGER_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
  case REAL_TYPE:
    return savantLessThan((const ScalarType&) lhs, (const ScalarType&) rhs);
    break;
  case ARRAY_TYPE:
    return savantLessThan((const ArrayType&) lhs, (const ArrayType&) rhs);
    break;
  case VECTOR_BASE:
    return savantLessThan((const VectorBase&) lhs, (const VectorBase&) rhs);
    break;
  case RECORD_TYPE:
    return savantLessThan((const RecordType&) lhs, (const RecordType&) rhs);
    break;
  case ACCESS_TYPE:
    return savantLessThan((const AccessType&) lhs, (const AccessType&) rhs);
    break;
  default:
    cerr << __FILE__ << ":" << __LINE__
	 << "savantLessThan of an unknown type called!! Aborting.";
    abort();
  }
  return ENUMERATION_FALSE;
}

EnumerationType 
savantLessThanOrEqual(const VHDLType& lhs, const VHDLType& rhs)
{
  return savantOr(savantLessThan(lhs, rhs), savantEqual(lhs, rhs));
}

EnumerationType
savantGreaterThan(const VHDLType& lhs, const VHDLType& rhs)
{
  return savantNot(savantLessThanOrEqual(lhs, rhs));
}

SignalBase*
VHDLType::locateSig(int ) {
  cerr << "ERROR!!!! VHDLType::locateSig(int sigId) called " << endl;
  abort();
  return NULL;
}

const VHDLData&
VHDLType::leftValue() {
  cerr << "ERROR!!! VHDLType::leftValue() called " << endl;
  abort();
  return *(new UniversalInteger(-1));
}

SignalBase *
VHDLType::findSigInBlock(int , int ){
  cerr << "ERROR!!!! VHDLType::findSigInBlock(int sigId) called" << endl;
  abort();
  return ((SignalBase *)NULL);
}

bool
VHDLType::_is_composite_resolved_type() const{
  return false;
}

void
VHDLType::set_sourcebase_delete_flag(bool flag) const{
  int index;
  ASSERT((this->getKind() == ObjectBase::SIGNAL_NETINFO) || (this->getKind() == ObjectBase::SIGNAL));

  switch (this->get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    if ( this->getObject()->getKind() == ObjectBase::SIGNAL_NETINFO){
      ((SignalNetinfo *)this->getObject())->set_sourcebase_delete_flag(flag);
    } else if ( this->getObject()->getKind() == ObjectBase::SIGNAL){
      ((SignalBase *)this->getObject())->set_sourcebase_delete_flag(flag);
    } else {
      cerr << "ERROR  VHDLType::set_sourcebase_delete_flag(bool) called with getKind() != SIGNAL_NETINFO or SIGNAL" << endl;
      abort;
    }
    break;
  case ARRAY_TYPE:
    ((ArrayType *)this)->get_array().set_sourcebase_delete_flag(flag);
    break;
  case VECTOR_BASE:
    for ( index = 0; index < ((VectorBase *)this)->numElems; index++){
      ((VectorBase *)this)->get_element(index).set_sourcebase_delete_flag(flag);
    }
    break;
  case RECORD_TYPE:
    for ( index = 1; index <= ((RecordType *)this)->get_number_of_elements(); index++){
      ((RecordType *)this)->get_field(index).set_sourcebase_delete_flag(flag);
    }
    break;
  default:
    cerr << "VHDLType::set_sourcebase_delete_flag(bool) wrong type passed " << endl;
    abort();
    break;
  }
}

VHDLType *
VHDLType::getParentCompositeType(){
  if ( getObject() != NULL ){
    return getObject()->getParentCompositeType();
  } else {
    return NULL;
  }
}

void
VHDLType::resolveAndUpdate(VHDLKernelBase* processPointer) {
  ASSERT ( getKind() == ObjectBase::SIGNAL );
  // ASSERT ( processPointer->getTimeNow() == ZERO );
  
  switch(get_kind()) {
  case INTEGER_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
  case REAL_TYPE:
    if (((SignalBase *) getObject())->getSource() != NULL) {
      processPointer->updateSignal((SignalBase *) getObject(), true);
    }
    break;

  case ARRAY_TYPE:
    if (((ArrayType *) this)->isCompositeResolvedType == false) {
      for(int i = 0; (i < ((ArrayType *) this)->get_number_of_elements()); i++) {
	((ArrayType *) this)->get_element(i).resolveAndUpdate(processPointer);
      }
    }
    else {
      processPointer->updateSignal(this);
    }
    break;

  case VECTOR_BASE:{
    for(int i = 0; (i < ((VectorBase *) this)->get_number_of_elements()); i++) {
      ((VectorBase *) this)->get_element(i).resolveAndUpdate(processPointer);
    }
  }
    break;
    
  case RECORD_TYPE:
    if (((RecordType *) this)->isCompositeResolvedType == false) {
      for(int i = 1; (i <= ((RecordType *) this)->get_number_of_elements()); i++) {
	((RecordType *) this)->get_field(i).resolveAndUpdate(processPointer);
      }
    }
    else {
      processPointer->updateSignal(this);
    }
    
    break;
    
  default:
    cerr << "Error!! : VHDLType::resolveAndUpdate(VHDLKernelBase *) - "
	 << "Unknown Kernel Type" << endl;
  }
}

void
VHDLType::setBusKind() {
  cerr << "Error!! : setBusKind() called on unknown Kernel Type" << endl;
}

TypeInfo&
VHDLType::getTypeInfo() const {
  cerr << "Error!! : VHDLTYpe::getTypeInfo() called.\n";
  return (TypeInfo &) TypeInfo::NULL_TYPE_INFO;
}
