#include <string.h>
#include <stdlib.h>

#include "aiinterface.h"

#include "../game.h"
#include "../coordinate.h"
#include "../rules.h"

#define _AI_ENERGY_UNIT		(THINK_MAP_MAX*THINK_MAP_MAX)
#define RELEVANCE_MINIMUM	4
#define _DEFAULT_BLOCK_VALUE	(-10)

/* Hard to get 10 moves who all make multiple immediate threats */
#define _POTENTIAL_THREAT_MAX	10

/* Declaration of local functions */
static int _move_find_best(ThinkAccelData *think_accel_data, Coordinate *best_move, Coordinate *last_move, Coordinate *my_last_move, int e_turn, int turn, int energy, int level);
static int _move_calc_value(ThinkAccelData *think_accel_data, Coordinate *cur_move, Coordinate *last_move, int e_turn, int turn, int energy, int level);

extern Square board[BOARD_XSIZE][BOARD_YSIZE];
extern PlayerOptions player_options[2];
extern char _player_char[3];

static const int _initial_energy[5] = {0, _AI_ENERGY_UNIT, _AI_ENERGY_UNIT*2, _AI_ENERGY_UNIT*2.5, _AI_ENERGY_UNIT*3.5};
static int _energy_reduce[THINK_MAP_MAX];

#include <stdio.h>

void _board_show(ThinkAccelData *data)
{
	int x, y, i;

	printf("state[0,1] = %d,%d  threat_count[0,1][0,1,2] = %d,%d,%d , %d,%d,%d\n", data->state[0], data->state[1], data->threats[0].threat_count[0], data->threats[0].threat_count[1], data->threats[0].threat_count[2], data->threats[1].threat_count[0], data->threats[1].threat_count[1], data->threats[1].threat_count[2]);
	for(y=0; y<BOARD_YSIZE; y++) {
		for(x=0; x<BOARD_XSIZE; x++) /*{
			for(i=0; i<ranges; i++)
				if(x >= range[i][0].xy[0] &&
				   x <= range[i][1].xy[0] &&
				   y >= range[i][0].xy[1] &&
				   y <= range[i][1].xy[1]) {*/
					printf("%c", _player_char[(int)board[x][y]]);
/*					break;
				}
			if(i == ranges)
				printf(" ");
		}*/
/*		for(i=0; i<2; i++) {*/
			printf("|");
			for(x=0; x<BOARD_XSIZE; x++)
				printf("%02d ", data->think_map.val[x][y]);
/*		}*/
		printf("\n");
	}
	fflush(stdout);
}

void _energy_reduce_generate(void)
{
	int i;

	for(i=0; i<THINK_MAP_MAX; i++)
		_energy_reduce[i] = THINK_MAP_MAX*THINK_MAP_MAX-i*i;
}

void ai_think_init(void)
{
	_energy_reduce_generate();
	ai_think_accel_init();
}

void _virtual_move(Coordinate *move, ThinkAccelData *data, int e_turn)
{
        ai_think_accel_update(data, move, e_turn, 1, NONE, e_turn+1);
}

void _virtual_unmove(Coordinate *move, ThinkAccelData *data, int e_turn)
{
	ai_think_accel_update(data, move, e_turn, -1, e_turn+1, NONE);
}

void _move_find_free(Coordinate *move)
{
	for(move->xy[0] = 0; move->xy[0] < BOARD_XSIZE; move->xy[0]++)
		for(move->xy[1] = 0; move->xy[1] < BOARD_YSIZE; move->xy[1]++)
			if(ARRAY_COOR(board, *move) == NONE)
				return;
}

void _range_clip(Coordinate range[3][2], int *ranges, Coordinate *zone0, Coordinate *zone1)
{
	*ranges = 1;
	range[0][0].xy[0] = zone0->xy[0] - 4;
	range[0][0].xy[1] = zone0->xy[1] - 4;
	coordinate_clip(&range[0][0]);
	range[0][1].xy[0] = zone0->xy[0] + 4;
	range[0][1].xy[1] = zone0->xy[1] + 4;
	coordinate_clip(&range[0][1]);
	/* If there are two zones to cover */
	if(zone1) {
		++(*ranges);
		/* Second range Y values to top and bottom */
		range[1][0].xy[1] = zone1->xy[1] - 4;
		coordinate_clip_y(&range[1][0]);
		range[1][1].xy[1] = zone1->xy[1] + 4;
		coordinate_clip_y(&range[1][1]);
		if((zone0->xy[0]-4 > zone1->xy[0]+4) || (zone1->xy[0]-4 > zone0->xy[0]+4) ||
		   (zone0->xy[1]-4 > zone1->xy[1]+4) || (zone1->xy[1]-4 > zone0->xy[1]+4)) {
		/* If zones do not overlap: Finish new range's setting up. */
			range[1][0].xy[0] = zone1->xy[0]-4;
			range[1][1].xy[0] = zone1->xy[0]+4;
		/* Clip occurs once for this and else section */
		} else { /* Zones overlap in X AND Y*/
			/* If new zone is right-one */
			if(zone0->xy[0] < zone1->xy[0]) {
			/* New range's left is set to after old's right */
				range[1][0].xy[0] = zone0->xy[0]+5;
				range[1][1].xy[0] = zone1->xy[0]+4;
			/* An extra range#2 is set */
				range[2][0].xy[0] = zone1->xy[0]-4;
				range[2][1].xy[0] = zone0->xy[0]+4;
			} else {
				range[1][0].xy[0] = zone1->xy[0]-4;
				range[1][1].xy[0] = zone0->xy[0]-5;
				range[2][0].xy[0] = zone0->xy[0]-4;
				range[2][1].xy[0] = zone1->xy[0]+4;
			}
			if(zone0->xy[1] != zone1->xy[1]) {
			/* If Y-coordinates are different: range#2 is used. */
				++(*ranges);
				if(zone0->xy[1] < zone1->xy[1]) {
					range[2][0].xy[1] = zone0->xy[1]+5;
					range[2][1].xy[1] = zone1->xy[1]+4;
				} else {
					range[2][0].xy[1] = zone1->xy[1]-4;
					range[2][1].xy[1] = zone0->xy[1]-5;
				}
				coordinate_clip(&range[2][0]);
				coordinate_clip(&range[2][1]);
			}
		}
		coordinate_clip_x(&range[1][0]);
		coordinate_clip_x(&range[1][1]);
	}
}

static int _move_calc_value(ThinkAccelData *think_accel_data, Coordinate *cur_move, Coordinate *last_move, int e_turn, int turn, int energy, int level)
{
	int value = ai_think_accel_relevance(think_accel_data, cur_move);
	Coordinate tmp;

	_virtual_move(cur_move, think_accel_data, e_turn);
	if(ai_think_accel_win_test(think_accel_data))
		value = WIN_VALUE - 1000;
	else if(energy <= 0) /* Leaf */
		value += ai_think_accel_board_value(think_accel_data, e_turn);
	else
		value += -_move_find_best(think_accel_data, &tmp, cur_move, last_move, e_turn^1, turn+1, energy, level+1);
//	printf("Value: %d\n", value);
//	_board_show(think_accel_data);
	_virtual_unmove(cur_move, think_accel_data, e_turn);

	return value;
}

int ai_think_move_test(Coordinate *cur_move, ThinkAccelData *think_accel_data, Coordinate *best_move, int *best, Coordinate *last_move, int e_turn, int turn, int energy, int level)
{
	int tmp;

	if((tmp = _move_calc_value(think_accel_data, cur_move, last_move, e_turn, turn, energy - _energy_reduce[ai_think_accel_relevance(think_accel_data, cur_move)], level)) > *best) {
		coordinate_copy(best_move, cur_move);
		return (*best = tmp) >= (signed)(WIN_VALUE-RANGE_CONSTANT);
	}

	return 0;
}

/* energy is the amount of 'energy' still left to check moves in this sub-tree.
 * It is reduced upon every recurson.  It reduces as less as the state is
 * 'interesting'. It does not reduce at all, if an obvious move was made.
 */
static int _move_find_best(ThinkAccelData *think_accel_data, Coordinate *best_move, Coordinate *last_move, Coordinate *my_last_move, int e_turn, int turn, int energy, int level)
{
	int best = -WIN_VALUE-1, i;
	Coordinate cur_move;
	Coordinate range[3][2];
	int ranges;

/* Deal with wins one turn away */
	if((my_last_move != NULL) && ai_think_accel_immediate_test(think_accel_data, best_move, my_last_move, e_turn))
		return WIN_VALUE;
	if((last_move != NULL) && ai_think_accel_immediate_test(think_accel_data, best_move, last_move, e_turn^1))
		return level ? _move_calc_value(think_accel_data, best_move, last_move, e_turn, turn, energy, level) : _DEFAULT_BLOCK_VALUE;
/* Deal with wins two turns away */
	if(ai_think_accel_threats_win_find(think_accel_data, e_turn, &best, best_move, level))
		return best;
//	if(ai_think_accel_threats_lose_find(think_accel_data, &best, best_move, last_move, e_turn, turn, energy, level))
//		return best;
	if(!level) {
		range[0][0].xy[0] = range[0][0].xy[1] = 0;
		range[0][1].xy[0] = BOARD_XSIZE-1; range[0][1].xy[1] = BOARD_YSIZE-1;
		ranges = 1;
	} else
		_range_clip(range, &ranges, last_move, my_last_move);
	for(i = 0; i < ranges; i++)
		for(cur_move.xy[0] = range[i][0].xy[0]; cur_move.xy[0] <= range[i][1].xy[0]; cur_move.xy[0]++)
			for(cur_move.xy[1] = range[i][0].xy[1]; cur_move.xy[1] <= range[i][1].xy[1]; cur_move.xy[1]++)
				if(ARRAY_COOR(board, cur_move) == NONE && ai_think_accel_relevance(think_accel_data, &cur_move) >= RELEVANCE_MINIMUM && ai_think_move_test(&cur_move, think_accel_data, best_move, &best, last_move, e_turn, turn, energy, level))
					return best;

/* If all squares are equal losses (= -WIN_VALUE), don't mess up.
 */
	if(best == -WIN_VALUE-1)
		_move_find_free(best_move);

	return best;
}

void ai_think(Coordinate *last_move, Coordinate *my_last_move, int turn, int e_turn, int fd)
{
	int value = 0;
	Coordinate best_move;
	ThinkAccelData think_accel_data;

	if(!turn) {
		best_move.xy[0] = BOARD_XSIZE>>1;
		best_move.xy[1] = BOARD_YSIZE>>1;
	} else {
		ai_think_accel_create(&think_accel_data);
		value = _move_find_best(&think_accel_data, &best_move, last_move, my_last_move, e_turn, turn, _initial_energy[player_options[e_turn].ai_player.level-1], 0);
	}
	ai_move_determined(&best_move, value, e_turn, fd);
}
