/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef control_MenuCtrl_h
#define control_MenuCtrl_h

#include "Control.h"
//#include "../util/Collection.h"

//--------------------------------------------------------------------------------------------------------------------------------

class MenuCtrl : public Control
{
private:
 Control* notify;
 Collection<class MenuItem>* menuItems;
 int pSel, pTop;
 int sel(int _sel) { return pSel = _sel; }
 int top(int _top) { return pTop = _top; }
 class Font* font;

public:
 MenuCtrl(Rect _rect, class Events* _events, Control* _notify, class Font* _font);
 virtual ~MenuCtrl();

private:
 class Rect itemRect(int);
 bool bringIntoView(); // returns true if any adjustment was made

public:
 virtual void evLBDown(class Point p);
 virtual void evDbClick(class Point p);

 virtual void evKeyDown(int key);
 virtual void evKeyRep(int key);

 virtual void draw(class Rect);

 virtual void add(int id, const char* text);

 int sel() { return pSel; }
 int top() { return pTop; }
 int itemId();
};

//--------------------------------------------------------------------------------------------------------------------------------

#endif
