/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_Color_h
#define vgaxx_Color_h

#include "../util/Object.h"

class Color: public Object
{
public:
 Color() { b = g = r = 0; a = 0xFF; }
 Color(int _r, int _g, int _b, int _a = 0xFF) { r = _r; g = _g; b = _b; a = _a; }
 Color(int _gray, int _a = 0xFF) { r = _gray; g = _gray; b = _gray; a = _a; }
 Color(const Color& color, int _a) { r = color.r; g = color.g; b = color.b; a = _a; }
 unsigned char r, g, b, a;
};

const Color colorBlack(0x00);
const Color colorDGray(0x3F);
const Color colorGray(0x7F);
const Color colorLGray(0xBF);
const Color colorWhite(0xFF);

const Color colorRed(0xFF, 0x00, 0x00);
const Color colorGreen(0x00, 0xFF, 0x00);
const Color colorBlue(0x00, 0x00, 0xFF);
const Color colorYellow(0xFF, 0xFF, 0x00);
const Color colorMagenta(0xFF, 0x00, 0xFF);
const Color colorCyan(0x00, 0xFF, 0xFF);

#endif
