/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_Point_h
#define vgaxx_Point_h

#include "../util/Object.h"
#include <stdlib.h>

class Point : public Object
{
public:
 inline Point() { x = y = 0; }
 inline Point(int _x, int _y) { x = _x; y = _y; }
 inline Point& operator += (Point p) { x += p.x; y += p.y; return *this; }
 inline Point operator + (Point p) const { return Point(x + p.x, y + p.y); }
 inline Point operator - (Point p) const { return Point(x - p.x, y - p.y); }
 inline Point operator * (Point p) const { return Point(x * p.x, y * p.y); }
 inline Point operator * (int i) const { return Point(x * i, y * i); }
 inline Point operator / (Point p) const { return Point(x / p.x, y / p.y); }
 inline Point operator / (int i) const { return Point(x / i, y / i); }
 inline bool operator != (Point p) const { return (x != p.x || y != p.y)? true : false; }
 inline bool operator == (Point p) const { return (x == p.x && y == p.y)? true : false; }
 inline bool contains(Point p) const { return (abs(p.x) <= abs(x) && abs(p.y) <= abs(y))? true : false; }
 inline bool near(Point p, int i) const { return (abs(x-p.x) <= i && abs(y-p.y) <= i)? true : false; }
 Point& clipTo(const class Rect& r);
 bool read(class File& f);
 bool write(class File& f) const;
 int x, y;
};

const Point origin(0, 0);

#endif
