/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef gl_palette_h
#define gl_palette_h

#include "Color.h"
#include "../util/types.h"

extern bool setPalette();

inline uint8 rgb2pal(Color c)
{
 return 1 + 6*( 7*( (c.r*5 + 127)/255 ) + (c.g*6 + 127)/255 ) + (c.b*5 + 127)/255;
}

inline Color pal2rgb(uint8 i)
{
 if(i > 6*6*7 || i == 0) return Color(0, 0, 0);
 i--;
 return Color(((i/7/6) % 6) * 255 / 5, ((i/6) % 7) * 255 / 6, (i % 6) * 255 / 5);
}

#endif
