/*C* $Id: hatlvl.cc,v 1.10 1997/09/26 17:52:11 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include <stdio.h>
#include <stdlib.h>
#include "Background.h"
#include "Data.h"
#include "Game.h"
#include "globals.h"
#include "level.h"
#include "options.h"
#include "spriteslide.h"
#include "../gl/Console.h"
#include "../gl/Keyboard.h"
#include "../gl/keycodes.h"
#include "../gl/Rect.h"
#include "../gl/VgaBlur.h"
#include "../util/debug.h"
#include "../util/util.h"
#include <assert.h>

static Level* level;

static SpriteSlide* spriteSlide;

static int x = 0, y = 0;

//-----------------------------------------------------------------------------
static void killCursor()
{
 screen->restore(Rect(x*sprW, y*sprH, sprW, sprH) + stagePos);
 screen->update(Rect(x*sprW, y*sprH, sprW, sprH) + stagePos);
}

//-----------------------------------------------------------------------------
static void drawCursor()
{
 screen->drawRect(Rect(x*sprW, y*sprH, sprW, sprH) + stagePos, Color(0xFF, 0xFF, 0xFF));
 screen->update(Rect(x*sprW, y*sprH, sprW, sprH) + stagePos);
}

//-----------------------------------------------------------------------------
static bool isWall(Pos p)
{
 if(p.x<0 || p.y<0 || p.x >= lvlW || p.y >= lvlH) return false;
 int sq = level->getSquare(p);
 return(sq >= 3 && sq <= 22)? true : false;
}

#define BLOCK_IS_WALL(x) (x >= 3 && x <= 18)

//-----------------------------------------------------------------------------
static void autoWall(bool very)
{
 char newLevel[lvlW][lvlH];
 char wallPattern[lvlW][lvlH];

#define wRight 1
#define wLeft 2
#define wUp 4
#define wDown 8

 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++)
  {
   int sq = level->getSquare(Pos(x, y));
   if(sq < 3 || sq > 18)
    {
     newLevel[x][y] = sq;
     continue;
    }
   int i = 0;
   if((x+1) < lvlW && isWall(Pos(x+1, y))) i += 1; // right
   if(x > 0 && isWall(Pos(x-1, y))) i += 2; // left
   if(y > 0 && isWall(Pos(x, y-1))) i += 4; // up
   if((y+1) < lvlH && isWall(Pos(x, y+1))) i += 8; // down
   newLevel[x][y] = (wallPattern[x][y] = i) + 3;
  }

 for(int x=0; (x+1)<lvlW; x++) for(int y=1; (y+1)<lvlH; y++)
  if(BLOCK_IS_WALL(level->getSquare(Pos(x, y))) && BLOCK_IS_WALL(level->getSquare(Pos(x+1, y)))
     && isWall(Pos(x, y-1)) && isWall(Pos(x, y+1)) && isWall(Pos(x+1, y-1)) && isWall(Pos(x+1, y+1)))
   {
    newLevel[x][y] = (wallPattern[x][y] &= ~wRight) + 3;
    newLevel[x+1][y] = (wallPattern[x+1][y] &= ~wLeft) + 3;
   }

 for(int x=1; (x+1)<lvlW; x++) for(int y=0; (y+1)<lvlH; y++)
  if(BLOCK_IS_WALL(level->getSquare(Pos(x, y))) && BLOCK_IS_WALL(level->getSquare(Pos(x, y+1)))
     && isWall(Pos(x-1, y)) && isWall(Pos(x+1, y)) && isWall(Pos(x-1, y+1)) && isWall(Pos(x+1, y+1)))
   {
    newLevel[x][y] = (wallPattern[x][y] &= ~wDown) + 3;
    newLevel[x][y+1] = (wallPattern[x][y+1] &= ~wUp) + 3;
   }

 if(very)
  {
   for(int x=0; (x+1)<lvlW; x++) for(int y=0; (y+1)<lvlH; y++)
    {
     if(!BLOCK_IS_WALL(level->getSquare(Pos(x, y)))) continue;
     int pat = wallPattern[x][y], patRight = wallPattern[x+1][y], patDown = wallPattern[x][y+1];
     if( (wallPattern[x][y] & wRight)
	 && ( ((pat & wUp)?1:0) + ((pat & wLeft)?1:0) + ((pat & wDown)?1:0) ) >= 2
	 && ( ((patRight & wUp)?1:0) + ((patRight & wRight)?1:0) + ((patRight & wDown)?1:0) ) >= 2 )
      {
       newLevel[x][y] = wallPattern[x][y] &= ~wRight + 3;
       newLevel[x+1][y] = wallPattern[x+1][y] &= ~wLeft + 3;
      }
     if( (wallPattern[x][y] & wDown)
	 && ( ((pat     & wLeft)?1:0) + ((pat     & wUp  )?1:0) + ((pat     & wRight)?1:0) ) >= 2
	 && ( ((patDown & wLeft)?1:0) + ((patDown & wDown)?1:0) + ((patDown & wRight)?1:0) ) >= 2)
      {
       newLevel[x][y] = wallPattern[x][y] &= ~wDown + 3;
       newLevel[x][y+1] = wallPattern[x][y+1] &= ~wUp + 3;
      }
    }
  }

 for(int x=0; x<lvlW; x++) for(int y=0; y<lvlH; y++)
  level->setSquareAndDrawKU(Pos(x, y), newLevel[x][y]);

#undef wRight
#undef wLeft
#undef wUp
#undef wDown

 drawCursor();
}

//-----------------------------------------------------------------------------
static void save()
{
 FILE* fp;
 if((fp = fopen(options->level, "w")) == NULL) fatal("cannot save file");
 level->save(fp);
 fclose(fp);
}

//-----------------------------------------------------------------------------
static void setup()
     /*
      * Called before the main loop, and after returning from test mode.
      */
{
 stagePos = Point(0, sprH / 2);

 bk->copyTo(screen);
 level->draw();
 screen->keepAndUpdate();
 drawCursor();
 spriteSlide->draw();
}

//-----------------------------------------------------------------------------
void levelEditor()
{
 screen->clipping = true;
 screen->clippingRect = screenRect;

 spriteSlide = new SpriteSlide((Collection<Sprite>*) ssetBlocks);

 if(!options->level) return;
 level = new Level;
 level->clear();
 level->load(options->level); // yes, ignore the return value (otherwise you can't create new levels)

 setup();

 bool quit = false;
 while(!quit)
  {
   KeyboardEvent* ke = keyboard->getEvent();
   if(ke)
    {
     KeyDownEvent* kde = dynamic_cast<KeyDownEvent*>(ke);
     KeyRepEvent* kre = dynamic_cast<KeyRepEvent*>(ke);
     if(kde || kre)
      {
       int key = ke->key;

       if(IS_KEY_UP(key)) { killCursor(); wrap(y, -1, lvlH); drawCursor(); }
       if(IS_KEY_DOWN(key)) { killCursor(); wrap(y, +1, lvlH); drawCursor(); }
       if(IS_KEY_LEFT(key)) { killCursor(); wrap(x, -1, lvlW); drawCursor(); }
       if(IS_KEY_RIGHT(key)) { killCursor(); wrap(x, +1, lvlW); drawCursor(); }

       if(IS_KEY_PAGEUP(key)) { (*spriteSlide)--; spriteSlide->draw(); }
       if(IS_KEY_PAGEDOWN(key)) { (*spriteSlide)++; spriteSlide->draw(); }

       if(IS_KEY_SPACE(key))
	{
	 level->setSquareAndDrawK(Pos(x, y), spriteSlide->sel);
	 drawCursor();
	}

       if(IS_KEY_A(key)) autoWall(false);
       if(IS_KEY_B(key)) autoWall(true);
       if(IS_KEY_S(key)) save();

       if(IS_KEY_Q(key) || IS_KEY_ESCAPE(key)) quit = true;
      }

    }
   delete ke;
  }

 delete spriteSlide;
 delete level;
}

