/*C* $Id$
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Parser.h"
#include "../gl/mode.h"
#include "../gl/Font.h"
#include "../hatman/Data.h"
#include "../util/debug.h"
#include "../util/util.h"
#include <assert.h>
#include <string.h>

Parser* docParser;

Parser::Parser(Collection<ViewObject>* _objects, char** _bk, int _width)
{
 assert(_width <= vgaW);
 assert(_bk != NULL);
 background = _bk; 
 objects = _objects;
 width = _width;
 offset = 0; 
}

void Parser::createLines(int fontsize, char align, int lmargin, int rmargin, int red, int green, int blue, char* text)
{
#if 0
 assert(text != NULL);

 char buffer[1024] = {'\0'};
 Font* f = fontBig;
 Font::HAlign a; 

 red = green = blue = 1;
 
 switch(fontsize)
  {
  case 1: case 2: case 3: case 4: case 5: case 6: default:
   f = fontBig;
   break;
  }

 switch(align)
  {
  case 'c':
   a = Font::Centre;
   break;

  case 'r':
   a = Font::Right;
   break;

  case 'l': default:
   a = Font::Left;
   break;
  }
 
 int pwidth = width - (lmargin + rmargin); 
 char* d = buffer;
 char* s = text = strdup(text);
 bool firstWord = true;

 do
  {
   // remember where the string ends now so we can go back if the line ends
   char* lastSpace = d;

   // append the next word
   char* token = strsep(&s, " \n\t");
   if(token == NULL) break;
   if(!firstWord) *d++ = ' '; else firstWord = false;
   strcpy(d, token); d += strlen(token);

   if(f->width(buffer) >= pwidth)
    {
     // add this line without the most recent word
     *lastSpace = '\0';
     addObject(new Line(pwidth, f->height(), offset, f, a, lmargin, makeColor(5, 5, 5), buffer));

     // put the word on the next line
     strcpy(d = buffer, token); d += strlen(token);
    }
  } while(s != NULL);

 addObject(new Line(pwidth, f->height(), offset, f, a, lmargin, makeColor(5, 5, 5), buffer));
 offset += f->height();
 delete text;
#endif
}

void Parser::createVSpace(int height)
{
 addObject(new VSpace(0, height, offset));
 offset += height;
}

void Parser::addObject(ViewObject* obj)
{
 assert(obj != NULL);
 objects->add(obj);
 offset += obj->getHeight();
}





