///////////////////////////////////////////////////////////////////////////////
// $Id: HelpOkOrCloseCommand.hxx,v 1.1 1995/01/08 06:41:52 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// HelpOkOrCloseCommand.hxx - Command executed when the user presses ok
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 14,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: HelpOkOrCloseCommand.hxx,v $
// Revision 1.1  1995/01/08  06:41:52  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef HELPOKORCLOSECOMMAND_HXX
#define HELPOKORCLOSECOMMAND_HXX

#include "Command.hxx"
#include "CommandFlags.hxx"
#include "Help.hxx"

class HelpOkOrCloseCommand : public Command {
  private:
    Help* myHelp;

  public:
    // Protected constructor to prevent instantiation
    HelpOkOrCloseCommand(Help* about)
        : myHelp(about)
    {};

    // Destructor
    virtual ~HelpOkOrCloseCommand() {};

    // Delete my about dialog
    virtual void execute(void* argument)
    {
      delete myHelp;
      helpCurrentlyDisplayedFlag = 0;
    }
};
#endif

