///////////////////////////////////////////////////////////////////////////////
// $Id: NewGameCommand.hxx,v 1.1 1995/01/08 06:41:58 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// NewGameCommand.hxx - Command to start a new game
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: NewGameCommand.hxx,v $
// Revision 1.1  1995/01/08  06:41:58  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef NEWGAMECOMMAND_HXX
#define NEWGAMECOMMAND_HXX

#include "Command.hxx"
#include "Engine.hxx"

class NewGameCommand : public Command {
  private:
    Engine* myEngine;

  public:
    // Protected constructor to prevent instantiation
    NewGameCommand(Engine* engine) { myEngine = engine; }

    // Destructor
    virtual ~NewGameCommand() { }

    virtual void execute(void* argument)
    {
      myEngine->newGame();
    }
};

#endif

