///////////////////////////////////////////////////////////////////////////////
// $Id: Sound.cxx,v 1.3 2000/01/10 23:33:06 bwmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Sound.cxx - Sound class
//
//
// Bradford W. Mott
// Copyright (C) 1995
// January 4,1995
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Sound.cxx,v $
// Revision 1.3  2000/01/10 23:33:06  bwmott
// Sound system uses the /dev/dsp device now instead of the /dev/audio device
//
// Revision 1.2  1996/01/06 05:12:39  bwmott
// Changed all NULLs to 0 and added (char*) cast in the write system call
//
// Revision 1.1  1995/01/08 06:48:24  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "Sound.hxx"


///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
Sound::Sound(SampleCollection* sampleCollection)
    : mySampleCollection(sampleCollection)
{
  // Determine if there is a usable sound device
  int soundDevice = open("/dev/dsp", O_WRONLY, 0);

  if(soundDevice == -1)
  {
    myState = Disabled;
  }
  else
  {
    myState = Enabled;
    close(soundDevice);
  } 
}

///////////////////////////////////////////////////////////////////////////////
// Destructor 
///////////////////////////////////////////////////////////////////////////////
Sound::~Sound()
{
}

///////////////////////////////////////////////////////////////////////////////
// Play the named sample
///////////////////////////////////////////////////////////////////////////////
void Sound::playSample(char* sampleName)
{
  // Play the sample if I'm enabled
  if(myState == Enabled)
  {
    // Open the sound device
    int audio = open("/dev/dsp", O_WRONLY, 0);

    if(audio != -1)
    {
      // Get the sample from my sample collection
      Sample* sample = mySampleCollection->getByName(sampleName);

      if(sample != 0)
        write(audio, (char*)sample->data(), sample->length());

      close(audio);
    }
  }
}

