#include "phalanx.h"

#define WIN 7
#define DRA 2
#define LOO 0

int Asize=800000;
int Maxbookply=32;
/* int Width=1000; */
int Maxdel=0;

typedef struct
{
	unsigned hashboard;
	unsigned n;
	unsigned short move;
} tb;          /* 8 bytes */

tb *A;
int I=0;
int Sortedto=0;

int bsortkey( const void *a, const void *b )
{
	if( ((tb*)a)->hashboard > ((tb*)b)->hashboard )
		return 1;
	else
	if( ((tb*)a)->hashboard < ((tb*)b)->hashboard )
		return -1;
	else
	if( ((tb*)a)->move > ((tb*)b)->move )
		return 1;
	else
	if( ((tb*)a)->move < ((tb*)b)->move )
		return -1;
	else
	if( ((tb*)a)->n > ((tb*)b)->n )
		return 1;
	else
	if( ((tb*)a)->n < ((tb*)b)->n )
		return -1;
	else
		return 0;
}

void delmoves(int use)
{
	int i1, i2;
	if( use > Maxdel ) Maxdel = use;
	printf("deleting moves (val<=%i) ... ",use);
	i1=0; i2=0;
	while( i2 < I )
	{
		while( i1 != I && A[i1].n > use ) i1++;
		if( i2 <= i1 ) i2 = i1+1;
		while( i2 != I && A[i2].n <= use ) i2++;
		if( i2 < I )
		{ A[i1]=A[i2]; A[i2].n=0; }
	}
	Sortedto=I=i1;
	printf("done, buffer usage=%i (%i%%)\n",I,100*I/Asize);
}

void delmore(void)
{
	int i1,i2,i;
	printf("selecting moves ........... ");
	i1=0; i2=1;
	while( i2 < I )
	{
/*
#define WDTH 60
*/
#define WDTH 50
		int nbest = A[i1].n;
		if(nbest==0) nbest=1;
		i2=i1+1;
		while( i2<I && A[i2].hashboard==A[i1].hashboard )
		{ if(A[i2].n>nbest) nbest=A[i2].n; i2++; }
		for( i=i1; i!=i2; i++ )
		if( /* A[i].n!=nbest || */ ( /* A[i].n < Width && */
		  (   100*A[i].n / nbest < WDTH
		 || ( 100*A[i].n / nbest < WDTH+10 && A[i].n < 40 )
		 || ( 100*A[i].n / nbest < WDTH+20 && A[i].n < 20 ) ) ) )
		 A[i].n=0;
		i1=i2;
	}
	puts("done");
}

int games=0; int positions=0;

void printit(int x)
{
  printf("%8i%10i%7i%%",
          games,positions,I*100/Asize);
  fflush(stdout);
  signal(SIGALRM,printit); alarm(5);
}

void compress(void)
{
	int i1, i2, use;
	printit(0);
	alarm(0);
	printf("\nsorting buffer ............ ");
/*	qsort( A+Sortedto, Asize-Sortedto, sizeof(tb), bsortkey ); */
	qsort( A, I, sizeof(tb), bsortkey );
	puts("done");
	printf("compressing buffer ........ ");
	i1=0; i2=1;
	while( i2 != I )
	{
		while( i2 != I
		    && A[i1].hashboard == A[i2].hashboard
		    && A[i1].move == A[i2].move )
		{
			A[i1].n += A[i2].n;
			i2++;
		}
		if( i2 != I )
		{ i1++; A[i1]=A[i2]; i2++; }
	}
	I=Sortedto=i1+1;
	A[I].n = 0;
	printf("done, buffer usage=%i (%i%%)\n",I,100*I/Asize);

	use=1;
	while( 100*I/Asize > 90 ) { delmoves(use); use++; }

	alarm(5);
}

int bpoints, wpoints;

int findgame(void)
{ register char c;
  register int found=0;
  char s[64];
  bpoints=0; wpoints=0;
  while( ! found )
  { while( (c=getchar()) != EOF && c!='R' ) {}
    if( c==EOF ) return 0;
    if( fgets(s,6,stdin)==NULL ) return 0;
    if( strncmp(s,"esult",5) == 0 )
    {
      while( (c=getchar()) == ' ' ) {}
      if( fgets(s,4,stdin)==NULL ) return 0;
      if( strncmp(s,"1-0",3) == 0 ) { bpoints=LOO; wpoints=WIN; }
      else if( strncmp(s,"0-1",3) == 0 ) { bpoints=WIN; wpoints=LOO; }
      else if( strncmp(s,"1/2",3) == 0 ) { bpoints=DRA; wpoints=DRA; }
      else { bpoints=1; wpoints=1; }
      return 1;
    }
  }
  return 0;
}

extern char piece[7];
extern char file[10];
extern char row[12];

int addmove(char *move)
{ static tmove m[256];
  tmove * mf;
  static int n;
  int i;
  int p=PAWN+Color;
  for(i=2;i!=7;i++) if(piece[i]==move[0]) p=16*i+Color;
  if( move[0]=='O' )
  { p=KING+Color;
    if(move[3]=='-') { if(Color==WHITE){} }
  }

  generate_legal_moves( m, &n, checktest(Color) );
  if( (mf=sandex(move,m,n)) != NULL )
  {
    if( Color==WHITE )
    { if(wpoints)
      { A[I].hashboard=G[Counter].hashboard;
        A[I].move = smove(mf);
        A[I].n = wpoints; positions++;
        I++; if( I>=Asize ) compress();
      }
    }
    else
    { if(bpoints)
      { A[I].hashboard=G[Counter].hashboard;
        A[I].move = smove(mf);
        A[I].n = bpoints; positions++;
        I++; if( I>=Asize ) compress();
      }
    }
    do_move(mf);
    return 1;
  } else { return 0; }
}

void parsegame(void)
{ register char c='*';
  char m[128];
  int i;
  setfen("rnbqkbnr/pppppppp/////PPPPPPPP/RNBQKBNR/w");
  while( c!='[' && c!=EOF && Counter < Maxbookply )
  { while( (c=getchar()) != '.' && c!=EOF ) {}
    while( (c=getchar())==' ' || c=='\n' ) {}
    m[0]=c; i=1;
    while( (c=getchar())!=' ' && c!='\n' && c!=EOF ) { m[i]=c; i++; }
    m[i]='\0';
    if( ! addmove(m) ) break;

    /* find black's move */
    while( (c=getchar())==' ' || c=='\n' ) {}
    if( c=='[' || c==EOF ) return;
    m[0]=c; i=1;
    while( (c=getchar())!=' ' && c!='\n' && c!=EOF ) { m[i]=c; i++; }
    m[i]='\0';
    if( ! addmove(m) ) break;
  }
}

void wusage(void)
{
  printf("Usage: bcreate <buffer size in cells>
One cell is %lu bytes
", (unsigned long) sizeof(tb) );
  exit(0);
}

int bcreate( int argc, char ** argv )
{
  FILE * f;
  int i;
  switch(argc)
  { case 2: Asize=atoi(argv[1]); break;
    default: break;
  }
  if( Asize < 1000 ) wusage();
  A=malloc(Asize*sizeof(tb));
  if( A == NULL )
  { printf("cannot alloc %lu bytes of memory\n",
    (unsigned long)(Asize*sizeof(tb))); exit(0);
  }
  setvbuf(stdout, (char*)NULL, _IONBF, 0);
  printf("    Phalanx "); puts(VERSION);
  puts(  "    creating opening book");
  puts(  "-----------------------------");
  puts(  "   games positions buffer%");
  puts(  "-----------------------------");
  signal(SIGALRM,printit); alarm(5);
  while( findgame() )
  { parsegame(); games++; }
  printf("end of file, parsed %i positions in %i games\n",positions,games);
  if( games == 0 )
  { puts("opening book not created"); return 0; }
  compress(); alarm(0);
  delmore();
  delmoves(Maxdel+12);
  printf("there is %i moves in the opening book\n",I);

  if( ( f = fopen( SBOOK_FILE, "wb" ) ) == NULL )
  { printf("cannot create book file %s\n", SBOOK_FILE); return 1; }
  for( i=0; i!=I; i++ )
  {
	unsigned short m = A[i].move;
	fwrite( A+i, sizeof(unsigned), 1, f );
	fwrite( &m, sizeof(unsigned short), 1, f );
  }
  return 0;
}

