## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import os, sys, time, types
from gtk import *
import GdkImlib

# PySol imports
from mfxutil import destruct                                        #bundle#
from util import Struct, Images                                     #bundle#

# Toolkit imports
from tkutil import loadImage                                        #bundle#


# /***********************************************************************
# //
# ************************************************************************/

class TclError:
    pass


class MfxCheckMenuItem:
    def __init__(self, menubar, path=None):
        self.menubar = menubar
        self.path = path
        self.value = None
    def get(self):
        if self.path is None: return 0
        w = self.menubar.menus.get_widget(self.path)
        return w.active
    def set(self, value):
        if self.path is None: return
        if not value or value == 'false': value = 0
        assert type(value) == types.IntType and 0 <= value <= 1
        self.value = value
        w = self.menubar.menus.get_widget(self.path)
        w.set_active(value)
        #print self.path, value, w, w.active


class MfxRadioMenuItem(MfxCheckMenuItem):
    def get(self):
        if self.path is None: return 0
        w = self.menubar.menus.get_widget(self.path)
        print w
        print w.active
        print w.__dict__
        return self.value
    def set(self, value):
        if self.path is None: return
        if not value or value == 'false': value = 0
        assert type(value) == types.IntType and 0 <= value
        self.value = value
        #w = self.menubar.menus.get_widget(self.path)
        #w.set_active(value)
        print self.path, value #, w, w.active


# /***********************************************************************
# // A toplevel window.
# ************************************************************************/

class _MfxToplevel(GtkWindow):
    def __init__(self, *args, **kw):
        GtkWindow.__init__(self, type=WINDOW_TOPLEVEL)
        self.style = self.get_style().copy()
        self.set_style(self.style)
        self.vbox = GtkVBox()
        self.vbox.show()
        self.add(self.vbox)
        self.realize()

    def cget(self, attr):
        if attr == 'cursor':
            # FIXME
            return GDK.LEFT_PTR
            return self.get_window().get_cursor(v)
        print "Toplevel cget:", attr
        raise AttributeError, attr

    def configure(self, **kw):
        height, width = -1, -1
        for k, v in kw.items():
            if k == "background" or k == "bg":
                c = self.get_colormap().alloc(v)
                self.style.bg[STATE_NORMAL] = c
                self.set_style(self.style)
                self.queue_draw()
            elif k == "cursor":
                self.setCursor(v)
            elif k == "height":
                height = v
            elif k == "width":
                width = v
            else:
                print "Toplevel configure:", k, v
                raise AttributeError, k
        if height > 0 and width > 0:
            ## FIXME
            #self.set_default_size(width, height)
            self.set_usize(width, height)
            #self.set_geometry_hints(base_width=width, base_height=height)

    config = configure

    def mainloop(self):
        mainloop()      # the global function

    def mainquit(self):
        mainquit()      # the global function

    def setCursor(self, cursor):
        self.get_window().set_cursor(cursor_new(v))

    def tk_setPalette(self, *args):
        # FIXME ?
        pass

    def update(self):
        self.update_idletasks()

    def update_idletasks(self):
        while events_pending():
            mainiteration(TRUE)

    def winfo_ismapped(self):
        # FIXME
        return 1

    def winfo_screenwidth(self):
        return screen_width()

    def winfo_screenheight(self):
        return screen_height()

    def winfo_screendepth(self):
        return self.get_window().depth

    def wm_command(self, *args):
        # FIXME
        pass

    def wm_deiconify(self):
        self.show_all()

    def wm_geometry(self, newGeometry=None):
        # FIXME
        pass

    def wm_group(self, pathName=None):
        # FIXME
        pass

    def wm_iconbitmap(self, name):
        if name and name[0] == '@' and name[-4:] == '.xbm':
            name = name[1:-4] + '.xpm'
            bg = self.get_style().bg[STATE_NORMAL]
            pixmap, mask = create_pixmap_from_xpm(self, bg, name)
            self.set_icon(pixmap, mask)

    def wm_iconname(self, name):
        self.set_icon_name(name)

    def wm_minsize(self, width, height):
        self.set_geometry_hints(min_width=width, min_height=height)

    def wm_protocol(self, name=None, func=None):
        if name == 'WM_DELETE_WINDOW':
            self.connect("delete_event", func)
        else:
            raise AttributeError, name

    def wm_title(self, title):
        self.set_title(title)


# /***********************************************************************
# // The root toplevel window of an application.
# ************************************************************************/

class MfxRoot(_MfxToplevel):
    def __init__(self, **kw):
        apply(_MfxToplevel.__init__, (self,), kw)
        self.app = None

    def connectApp(self, app):
        self.app = app

    # sometimes an update() is needed under Windows, whereas
    # under Unix an update_idletask() would be enough...
    def busyUpdate(self):
        game = None
        if self.app: game = self.app.game
        if not game:
            self.update()
        elif not game.busy:
            game.busy = 1
            self.update()
            game.busy = 0

    # FIXME - make sleep interruptible
    def sleep(self, seconds):
        time.sleep(seconds)

    def wmDeleteWindow(self, *args):
        if self.app and self.app.menubar:
            self.app.menubar.mQuit()
        else:
            ##self.after_idle(self.quit)
            pass
        return TRUE


# /***********************************************************************
# //
# ************************************************************************/

class MfxImages(Images):
    def loadImage(self, file):
        return loadImage(file)

