## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import sys, os

# PySol imports
from mfxutil import EnvError                                        #bundle#
from util import PACKAGE, VERSION                                   #bundle#
from pysoltk import tkname, makeToplevel                            #bundle#
from pysoltk import MfxDialog                                       #bundle#
from pysoltk import tkHTMLViewer                                    #bundle#


# /***********************************************************************
# //
# ************************************************************************/

def helpAbout(app, timeout=0):
    d = MfxDialog(app.top, title="About " + PACKAGE, timeout=timeout,
               text=PACKAGE+"\nA Python Solitaire Game\nVersion " + VERSION +"\n\n" +
                    "Copyright (C) 1998, 1999 Markus F.X.J. Oberhumer\n" +
                    "<markus.oberhumer@jk.uni-linz.ac.at>\n\n" +
                    PACKAGE+" is distributed under the terms of the\n" +
                    "GNU General Public License\n\n" +
                    "For more information about this application visit\n" +
                    "http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html",
               image=app.jokers[2],
               strings=("Nice", "Credits..."), default=0,
               separatorwidth=2)
    if d.status == 0 and d.num == 1:
        helpCredits(app)
    return d.status


def helpCredits(app, timeout=0):
    t = ""
    if tkname == "tk": t = "Tcl/Tk, "
    elif tkname == "gnome": t = "GTK, GNOME, "
    elif tkname == "kde": t = "pyKDE, "
    d = MfxDialog(app.top, title=PACKAGE+" Credits", timeout=timeout,
               text=PACKAGE+" credits go to:\n\n" +
                    "Volker Weidner for getting me into Solitaire\n" +
                    "Guido van Rossum for the initial example program\n" +
                    "Zachary Roadhouse for the basis of the HTML widget\n" +
                    "John Fitzgibbon for providing the card images\n" +
                    "Fabio Bozzetto for additional cardsets and graphics\n" +
                    "The Gnome AisleRiot team for parts of the documentation\n" +
                    "\n" +
                    "The Python, " + t + "Linux & KDE crews\nfor making this program possible",
               image=app.jokers[3], image_side="right",
               separatorwidth=2)
    return d.status


# /***********************************************************************
# //
# ************************************************************************/

help_html_index = None

def helpHTML(app, document, dir):
    if not document:
        return
    try:
        doc = app.dataloader.findFile(document, dir)
        global help_html_index
        if help_html_index is None:
            document, dir = "index.html", "html"
            help_html_index = app.dataloader.findFile(document, dir)
    except EnvError:
        d = MfxDialog(app.top, title=PACKAGE + " HTML Problem",
                      text="Cannot find help document\n" + document,
                      bitmap="warning")
        return 0
    top = makeToplevel(app.top, title=PACKAGE+" Help")
    top.wm_minsize(400, 200)
    try: top.wm_iconbitmap("@" + app.dataloader.findFile("pysol.xbm"))
    except: pass
    viewer = tkHTMLViewer(top)
    viewer.app = app
    ##print doc, help_html_index
    viewer.home = help_html_index
    viewer.display(doc)
    return 1

