## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


#%ifndef BUNDLE

# imports
import os, sys
_os, _sys = os, sys
_path = sys.path[:]
del os, sys


# /***********************************************************************
# // Toolkit exporter
# ************************************************************************/

modules = None
default_modules = (
    "tkconst",
    "tkutil",
    "tkcanvas",
    "tkwrap",
    "tkwidget",
    "tkhtml",
    "toolbar",
    "statusbar",
    "progressbar",
    "menubar",
    "card",
)


# Tcl/Tk wrapper
if 1 and modules is None:
    _sys.path.insert(0, _os.path.join(_sys.path[0], "tk"))
    modules = default_modules


# GTK/GNOME wrapper
if 1 and modules is None:
    _sys.path.insert(0, _os.path.join(_sys.path[0], "gnome"))
    modules = default_modules


# /***********************************************************************
# //
# ************************************************************************/

# import module contents
for m in modules:
    exec "from " + m + " import *"

# delete modules
for m in modules:
    ##del _sys.modules[m]
    pass

# restore settings
del m, modules, default_modules
_sys.path = _path
del _path
del _os, _sys

#%endif /* BUNDLE */

