/*
 * Program XBLAST V2.5.15 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * October 18, 1998
 * started August 1993
 *
 * File: data.h
 * include file for data.c
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 3; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: data.h,v 1.2 1998/10/18 12:30:04 xblast Exp $
 * $Log: data.h,v $
 * Revision 1.2  1998/10/18 12:30:04  xblast
 * Morphing Bomb extra
 *
 * Revision 1.1  1998/01/03 14:11:26  xblast
 * Initial revision
 *
 */

#ifndef _DATA_H
#define _DATA_H



#include "include.h"

#include "mytypes.h"

/*
 * global variables
 */
#ifndef _DATA_C
extern BMLevelData *internal_maze_data[];
extern BMLevelData *score_board_data[];
extern BMLevelData *winning_data[];
#endif

/* 
 * game mode flags for levels 
 */
#define GM_Random     (1<<0)
#define GM_2_Player   (1<<1)
#define GM_3_Player   (1<<2)
#define GM_4_Player   (1<<3)
#define GM_5_Player   (1<<4)
#define GM_6_Player   (1<<5)
#define GM_NoGrid     (1<<6) 
#define GM_Single     (1<<7)
#define GM_Team       (1<<8)
#define GM_Double     (1<<9)
#define GM_LR_Players (1<<10)

#define GM_234_Player   (GM_2_Player|GM_3_Player|GM_4_Player)
#define GM_2456_Player  (GM_2_Player|GM_4_Player|GM_5_Player|GM_6_Player)
#define GM_2345_Player  (GM_234_Player|GM_5_Player)
#define GM_23456_Player (GM_2345_Player|GM_6_Player)

#define GM_All          (GM_Single|GM_Team|GM_Double|GM_LR_Players)
#define GM_SinglePlayer (GM_Single|GM_Team|GM_Double)

#define NUM_GM        11

/*
 * init flags for extras
 *   LF_ level start flag
 *   RF_ revive flag
 *   IF_ both of the above
 */
#define IF_None     0
/* kick extra */
#define LF_Kick     (1<<0)
#define RF_Kick     (1<<1)
#define IF_Kick     (RF_Kick|LF_Kick)
/* remote control */
#define LF_RC       (1<<2)
#define RF_RC       (1<<3)
#define IF_RC       (RF_RC|LF_RC)
/* teleporter */
#define LF_Teleport (1<<4)
#define RF_Teleport (1<<5)
#define IF_Teleport (RF_Teleport|LF_Teleport)
/* airpump */
#define LF_Airpump  (1<<6)
#define RF_Airpump  (1<<7)
#define IF_Airpump  (RF_Airpump|LF_Airpump)
/* cloak extra */
#define LF_Cloak    (1<<8)
#define RF_Cloak    (1<<9)
#define IF_Cloak    (RF_Cloak|LF_Cloak)
/* morph extra */
#define LF_Morph    (1<<10)
#define RF_Morph    (1<<11)
#define IF_Morph    (RF_Morph|LF_Morph)

#define NUM_IF 12

  /* extras */

#define EXNone 0

#endif
/*
 * end of file data.h
 */



