#include "xsw.h"



/*
 *      Front end to parse command input.
 */
int CmdHandleInput(char *input)
{
        char *strptr;

        char stringa[CLIENT_CMD_MAX];
        char stringb[CLIENT_CMD_MAX];
        char arg[CLIENT_CMD_MAX];
        char command[CLIENT_CMD_MAX];

        int status = 0;


        /* Input command must be atleast 1 character long. */
        if(input == NULL)
            return(-1);
        if(strlen(input) < 1)
            return(-1);
         
        /* Copy input string to stringa and sanitize stringa. */
        strncpy(stringa, input, CLIENT_CMD_MAX);
        stringa[CLIENT_CMD_MAX - 1] = '\0';
	StringStripSpaces(stringa);        

        strncpy(stringb, stringa, CLIENT_CMD_MAX);
        stringb[CLIENT_CMD_MAX - 1] = '\0';
        strncpy(stringa, stringb, CLIENT_CMD_MAX);
        stringa[CLIENT_CMD_MAX - 1] = '\0';
 
        stringa[CLIENT_CMD_MAX - 1] = '\0';
        strptr = strchr(stringa, '\n');
        if(strptr != NULL)
            *strptr = '\0';

 
        /* ******************************************************** */
        /* Begin parsing. */

	strptr = strchr(stringa, ' ');
        if(strptr != NULL)
        {
            strncpy(arg, (strptr + 1), CLIENT_CMD_MAX);
            arg[CLIENT_CMD_MAX - 1] = '\0';
            *strptr = '\0';
            strncpy(command, stringa, CLIENT_CMD_MAX);
            command[CLIENT_CMD_MAX - 1] = '\0';
        }
        else
        {
            strncpy(arg, "", CLIENT_CMD_MAX);
            strncpy(command, stringa, CLIENT_CMD_MAX);
            command[CLIENT_CMD_MAX - 1] = '\0';
        }
	StringStripSpaces(command);


        /* ****************************************************** */
        /* Handle command. */

        /* Debug. */
        if(!strcmp(command, "debug"))
        {
            status = CmdDebug(arg);
        }
        /* Test. */
        else if(!strcmp(command, "test"))
        {
            status = CmdTest(arg);
        }
        /* Help. */
        else if(!strcmp(command, "help") ||
                !strcmp(command, "hel") ||
                !strcmp(command, "he") ||
                !strcmp(command, "h") ||
                !strcmp(command, "?")
        )
        {
            status = CmdHelp(arg);
        }
        /* Version. */
        else if(!strcmp(command, "version") ||
                !strcmp(command, "versio") ||
                !strcmp(command, "versi") ||
                !strcmp(command, "vers") ||
                !strcmp(command, "ver")
        )
        {
            status = CmdVersion(arg);
        }
        /* Memory. */
        else if(!strcmp(command, "memory") ||
                !strcmp(command, "memor") ||
                !strcmp(command, "memo") ||
                !strcmp(command, "mem")
        )
        {
            status = CmdMemory(arg);
        }
        /* Auto interval tune state. */  
        else if(!strcmp(command, "autointerval") ||
                !strcmp(command, "autointerva") ||
                !strcmp(command, "autointerv") ||
                !strcmp(command, "autointer") ||
                !strcmp(command, "autointe") ||
                !strcmp(command, "autoint") ||
                !strcmp(command, "autoi") ||
                !strcmp(command, "aint")
        )
        {
            status = CmdAutoInterval(arg);
        }
	/* Script. */
        else if(!strcmp(command, "serverscript") ||
                !strcmp(command, "servscript") ||
                !strcmp(command, "script") ||
                !strcmp(command, "scrip") ||
                !strcmp(command, "scri") ||
                !strcmp(command, "scr") ||
                !strcmp(command, "sc")
        )
        {
            status = CmdServScript(arg);
        }
        /* Set. */
        else if(!strcmp(command, "set") ||
                !strcmp(command, "se") ||
                !strcmp(command, "s")
        )
        {
            status = CmdSet(arg);
        }
        /* Login name. */
        else if(!strcmp(command, "lname") ||
                !strcmp(command, "lnam") ||
                !strcmp(command, "lna") ||
                !strcmp(command, "ln")
        )
        {
            status = CmdLoginName(arg); 
        }
        /* Login password. */
        else if(!strcmp(command, "lpassword") ||
                !strcmp(command, "lpasswor") ||
                !strcmp(command, "lpasswo") ||
                !strcmp(command, "lpassw") ||
                !strcmp(command, "lpass") ||
                !strcmp(command, "lpas") ||
                !strcmp(command, "lpa") ||
                !strcmp(command, "lp") ||
                !strcmp(command, "lpasswd")   
        )
        {
            status = CmdLoginPassword(arg);
        }
	/* Log. */
        else if(!strcmp(command, "log"))
	{
	    status = CmdLog(arg);
	}
        /* Connect to server. */
        else if(!strcmp(command, "connect") ||
                !strcmp(command, "connec") ||
                !strcmp(command, "conne") ||
                !strcmp(command, "conn") ||
                !strcmp(command, "con") ||
                !strcmp(command, "online") ||
                !strcmp(command, "ol")
        )
        {
            status = CmdConnect(arg);
        }
        /* Disconnect. */
        else if(!strcmp(command, "disconnect") ||
                !strcmp(command, "disconnec") ||
                !strcmp(command, "disconne") ||
                !strcmp(command, "disconn") ||
                !strcmp(command, "discon") ||
                !strcmp(command, "disco") ||
                !strcmp(command, "disc") ||
                !strcmp(command, "dis") ||
                !strcmp(command, "bye") ||
                !strcmp(command, "handup") || 
                !strcmp(command, "hup")
        )
        {
            status = CmdDisconnect(arg);
        }
        /* Refresh. */
        else if(!strcmp(command, "refresh") ||
                !strcmp(command, "refres") ||
                !strcmp(command, "refre") ||
                !strcmp(command, "refr") ||
                !strcmp(command, "ref")
        )
        {
            status = CmdRefresh(arg);
        }
        /* Interval. */
        else if(!strcmp(command, "interval") ||
                !strcmp(command, "interva") ||
                !strcmp(command, "interv") ||
                !strcmp(command, "inter") ||
                !strcmp(command, "inte") ||
                !strcmp(command, "int")
        )
        {
            status = CmdNetInterval(arg);
        }
        /* Quit. */
        else if(!strcmp(command, "quit") ||  
                !strcmp(command, "qui") ||  
                !strcmp(command, "qu") ||  
                !strcmp(command, "q") ||  
                !strcmp(command, "exit") ||
                !strcmp(command, "exi")
        )
        {
            status = CmdExit("y");
        }
        /* Synctime. */
        else if(!strcmp(command, "synctime") ||
                !strcmp(command, "synctim") ||
                !strcmp(command, "syncti") ||
                !strcmp(command, "synct") ||
                !strcmp(command, "sync") ||
                !strcmp(command, "syn") ||
                !strcmp(command, "sy")
        )
        {
            status = CmdSynctime(arg);
        }
        else 
        {
            sprintf(stringa,
                "%s: no such command or macro.",
                command
            );
            MesgAdd(stringa, xsw_color.standard_text);
        }


        return(status);
}
