#include "swserv.h"
        

#define THIS_CMD_NAME		"createplayer"


/*
 *	OPM name for newly created player objects.  Newly created player
 *	objects get the OPM values from this OPM.
 */
#define DEF_PLAYER_OPM_NAME	"New Player"


int CmdCreatePlayer(int condescriptor, char *arg)
{
        long i, con_object_num, new_obj_num;
	xsw_object_struct *con_obj_ptr, *new_obj_ptr;

        char name[XSW_OBJ_NAME_MAX];
        char password[XSW_OBJ_PASSWORD_MAX];

	int opm_num;
	xsw_object_struct *opm_ptr;

        char name1[XSW_OBJ_NAME_MAX + 80];
        char name2[XSW_OBJ_NAME_MAX + 80];

        char larg[CS_DATA_MAX_LEN];
        char stringa[XSW_OBJ_NAME_MAX + 512];
        char sndbuf[CS_DATA_MAX_LEN];
        char *strptr;


        /* Get con_object_num from connection (assumed valid) */
        con_object_num = connection[condescriptor]->object_num; 
	if(DBIsObjectGarbage(con_object_num))
	    return(-1);
	else
	    con_obj_ptr = xsw_object[con_object_num];


	/* Print usage? */
        if((arg == NULL) ? 1 : (arg[0] == '\0'))
        {
            sprintf(sndbuf,
                "Usage: `%s <name>=<password>'",
		THIS_CMD_NAME
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }
	strptr = strchr(arg, '=');
        if(strptr == NULL)
        {
            sprintf(sndbuf,
                "Usage: `%s <name>=<password>'",
		THIS_CMD_NAME
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Copy arg to stringa. */
        strncpy(larg, arg, CS_DATA_MAX_LEN);
        larg[CS_DATA_MAX_LEN - 1] = '\0';
        StringStripSpaces(larg);


        /* Get name for new player object. */
        strncpy(name, larg, XSW_OBJ_NAME_MAX);
        name[XSW_OBJ_NAME_MAX - 1] = '\0';
        strptr = strchr(name, '='); 
        if(strptr != NULL)
            *strptr = '\0';
        StringStripSpaces(name);
        
        /* Sanitize name. */
        if(DBValidateObjectName(name))
        {
            sprintf(sndbuf,
                "%s: %s: Invalid name.",
		THIS_CMD_NAME,
                name
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }

        /* Get password for new player object. */
        strptr = strchr(larg, '=');
        strptr += 1;
        strncpy(password, strptr, XSW_OBJ_PASSWORD_MAX);
        password[XSW_OBJ_PASSWORD_MAX - 1] = '\0';
        StringStripSpaces(password);

        /* Sanitize password. */
        if(DBValidateObjectPassword(password))
        {
            sprintf(sndbuf,
                "%s: %s: Invalid password.",
                THIS_CMD_NAME,
		password
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }


        /* Check if object's permission allows create player. */
        if(con_obj_ptr->permission.uid > ACCESS_UID_CREATEPLAYER)
        {
            sprintf(sndbuf,
            "%s: Requires access level %i: Permission denied.",
                THIS_CMD_NAME,
		ACCESS_UID_CREATEPLAYER
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }


	/* Check if another object by that name exists already. */
	for(i = 0; i < total_objects; i++)
	{
	    if(xsw_object[i] == NULL)
		continue;

	    if(xsw_object[i]->type <= XSW_OBJ_TYPE_GARBAGE)
		continue;

	    if(!strcmp(xsw_object[i]->name, name))
	    {
		sprintf(sndbuf,
                    "%s: %s: An object by that name already exists.",
		    THIS_CMD_NAME,
                    name
                );
                NetSendLiveMessage(condescriptor, sndbuf);

		return(-3);
	    }
	}


        /* Begin creating new player object. */
        new_obj_num = DBCreateObject(
            ISREF_DEFAULT,
            XSW_OBJ_TYPE_PLAYER,   
            con_object_num,
            con_obj_ptr->x,
            con_obj_ptr->y,
            con_obj_ptr->z,
            con_obj_ptr->heading,
            con_obj_ptr->pitch,
            con_obj_ptr->bank  
        );
        if(DBIsObjectGarbage(new_obj_num))
        {
            sprintf(sndbuf,
                "%s: DBCreateObject(): Unable to create object.",
		THIS_CMD_NAME
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }
	else
	{
	    new_obj_ptr = xsw_object[new_obj_num];
	}


	/*   Model newly created player object to the parameters of
	 *   the OPM for newly created player objects.
	 */

	/* Get OPM for newly created player objects. */
	opm_num = OPMGetByName(
	    DEF_PLAYER_OPM_NAME,
	    XSW_OBJ_TYPE_PLAYER
	);
	if(OPMIsGarbage(opm_num))
	{
	    opm_ptr = NULL;

            sprintf(sndbuf,
                "%s: OPMGetByName(): `%s' not defined.",
                THIS_CMD_NAME,
		DEF_PLAYER_OPM_NAME
            );   
            NetSendLiveMessage(condescriptor, sndbuf);
	}
	else
	{
	    opm_ptr = opm[opm_num];

	    OPMModelObjectPtr(new_obj_ptr, opm_ptr);
	}


	/* Set name and password. */
	strncpy(
	    new_obj_ptr->name,
	    name,
	    XSW_OBJ_NAME_MAX
	);
	new_obj_ptr->name[XSW_OBJ_NAME_MAX - 1] = '\0';

        strncpy(
            new_obj_ptr->password,
            CryptHandleEncrypt(password),   
            XSW_OBJ_PASSWORD_MAX
        );
        new_obj_ptr->password[XSW_OBJ_PASSWORD_MAX - 1] = '\0';

        /* Clear the unencrypted password from memory! */
        memset(password, '\0', XSW_OBJ_PASSWORD_MAX);


	/* Players always own themselves. */
	new_obj_ptr->owner = new_obj_num;


	/* Place new player object at the position of the creator. */
        new_obj_ptr->sect_x = con_obj_ptr->sect_x;
        new_obj_ptr->sect_y = con_obj_ptr->sect_y;
        new_obj_ptr->sect_z = con_obj_ptr->sect_z;
        new_obj_ptr->x = con_obj_ptr->x;
        new_obj_ptr->y = con_obj_ptr->y;
	new_obj_ptr->z = con_obj_ptr->z;
        new_obj_ptr->heading = con_obj_ptr->heading;
        new_obj_ptr->pitch = con_obj_ptr->pitch;
        new_obj_ptr->bank = con_obj_ptr->bank;


	new_obj_ptr->birth_time = cur_millitime;


	/* New player object has been created. */


        /* Send updates to all connections. */
	NetSendCreateObject(-1, new_obj_num);
        NetSendObjectName(-1, new_obj_num);
        NetSendObjectSect(-1, new_obj_num);


        /* Print and log. */
	strncpy(
	    name1,
	    DBGetFormalNameStr(con_object_num),
	    XSW_OBJ_NAME_MAX + 80
	);
	name1[XSW_OBJ_NAME_MAX + 80 - 1] = '\0';
        strncpy(
            name2,
            DBGetFormalNameStr(new_obj_num),
            XSW_OBJ_NAME_MAX + 80
        );
        name2[XSW_OBJ_NAME_MAX + 80 - 1] = '\0';

        sprintf(sndbuf,
            "Created new player: %s",
            name2
        );
        NetSendLiveMessage(condescriptor, sndbuf);
        sprintf(stringa,
            "%s: Created new player: %s",
            name1,
            name2
        );
        if(sysparm.log_general)
            LogAppendLineFormatted(fname.primary_log, stringa);


        return(0);
}
