#include "swserv.h"
  
 
/*
 *      List processes.
 *      
 *      NOTE: This function is not completely formalized,
 *      information sent to connection is not standard.  
 */
int CmdPS(int condescriptor, char *arg)
{
        char sndbuf[CS_DATA_MAX_LEN];
        int schedual_num;
        char can_view_others;
        int uid;
        long object_num;
        int processes_listed;
        schedual_struct **shptr;
        
        
        /* Get object number. */
        object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(object_num))
            return(-1);


        /* Get uid. */
        uid = xsw_object[object_num]->permission.uid;

        /* Can connection view processes that belong to others? */
        can_view_others = (uid > ACCESS_UID_PSO) ? 0 : 1;


        /* Print header. */
        NetSendLiveMessage(
            condescriptor,
            "-   PID  STAT     INT  USER"
        );


        /* Begin printing schedualed events. */
        processes_listed = 0;
        shptr = (schedual_struct **)schedual;
        for(schedual_num = 0;
            schedual_num < total_scheduals;
            schedual_num++, shptr++
        )
        {
            if(!SchedualIsActive(schedual_num)) continue;

            /* Check if allowed to view others. */
            if((object_num != (*shptr)->run_owner) &&
               !can_view_others
            )
                continue;


            /* Print line. */
            sprintf(sndbuf, "-%6d  %4d  %6ld  %s",
                schedual_num,
                1,
                (*shptr)->act_int,
                DBGetFormalNameStr((*shptr)->run_owner)
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            processes_listed++;
        }


        /* Print footer. */
        sprintf(sndbuf, "%i processes.",
            processes_listed
        );
        NetSendLiveMessage(condescriptor, sndbuf);


        return(0);
}
