#include "swserv.h"



int NetHandleSetWeaponsLock(int condescriptor, char *arg)
{
        long object_num, con_object_num, tar_object_num, prev_object_num;
        xsw_object_struct *obj_ptr;


        con_object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(con_object_num))
            return(-1);
        else
            obj_ptr = xsw_object[con_object_num];


        /* Get current locked on object (maybe -1). */
        prev_object_num = obj_ptr->locked_on; 
        if(DBIsObjectGarbage(prev_object_num))
        {
            obj_ptr->locked_on = -1;
            prev_object_num = -1;
        }


        /*
         *   Format NET_CMD_WEAPONSLOCK:
         *
         *      object_num, tar_object_num
         */
        sscanf(arg, "%ld %ld",
                &object_num,
                &tar_object_num
        );


        /* Connection must own object. */
        if(object_num != con_object_num)
            return(-3);


        /* Unlock weapons. */
        if(tar_object_num == -1)
        {   
            obj_ptr->locked_on = -1;
        }
        /* Lock next object. */
        else if(tar_object_num == -2)
        {
            obj_ptr->locked_on = MatchWeaponsLock(
                object_num,
                prev_object_num,
                obj_ptr->scanner_range
            );
        } 
        /* Match object explicitly by name or number. */
        else if(!DBIsObjectGarbage(tar_object_num))
        {
            /* Matched, but check to see if within scanner range. */
            if(Mu3DInRange(object_num, tar_object_num,
                   obj_ptr->scanner_range *
                       DBGetObjectVisibilityPtr(xsw_object[tar_object_num])
               )
            )
            {
                /* Within range, set lock. */
                obj_ptr->locked_on = tar_object_num;
            }
            else
            {
                /* Too far away. */
                obj_ptr->locked_on = -1;
            }
        }

	/* Need to set values of target object first! */
	NetSendObjectMaximums(condescriptor, obj_ptr->locked_on);
/*
	NetSendObjectValues(condescriptor, obj_ptr->locked_on);
 */
	NetSendObjectName(condescriptor, obj_ptr->locked_on);

        /* Set next object values update to now so it gets updated now. */
        next.object_values = cur_millitime;


        return(0);
}


int NetSendSetWeaponsLock(int condescriptor)
{
	return(0);
}
