/*
                                 File IO

	Functions:

	char *FReadNextLineAlloc(FILE *fp, char comment_char)
        char *FReadNextLineAllocCount(
		FILE *fp,
		char comment_char,
		int *line_count
	)

	---


*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "../include/fio.h"


/*
 *	Allocate memory while reading a line from file in chunk size
 *	of this many bytes:
 */
#define FREAD_ALLOC_CHUNK_SIZE	8


/*
 *	Returns an allocated string containing the entire
 *	line or NULL on error or EOF.
 *
 *	If comment_char is '\0' then the next line is read regardless
 *	if it is a comment or not.
 *
 *	Calling function must free() the returned pointer.
 */
char *FReadNextLineAlloc(FILE *fp, char comment_char)
{
	return(FReadNextLineAllocCount(fp, comment_char, NULL));
}

char *FReadNextLineAllocCount(
	FILE *fp,
	char comment_char,
	int *line_count
)
{
	int i, m, n;
	char *strptr;


	if(fp == NULL)
	    return(NULL);

	/* Is comment character specified? */
	if(comment_char != '\0')
	{
	    /* Comment character is specified. */

	    /* Read past spaces, newlines, and comments. */
	    i = fgetc(fp);
	    if(i == EOF)
		return(NULL);

	    while((i == ' ') || (i == '\t') || (i == '\n') || (i == '\r') ||
                  (i == comment_char)
	    )
	    {
                if(i == EOF)
		    return(NULL);

		/* If newline, then increment line count. */
		if((i == '\n') ||
                   (i == '\r')
		)
		{
		    if(line_count != NULL)
			*line_count += 1;
		}

		/* If comment, then skip to next line. */
		if(i == comment_char)
		{
		    i = fgetc(fp);
		    while((i != '\n') && (i != '\r'))
		    {
			if(i == EOF)
			    return(NULL);
			i = fgetc(fp);
		    }
		    if(line_count != NULL)
			*line_count += 1;
		}

		/* Get next character. */
		i = fgetc(fp);
	    }

	    /* Begin adding characters to string. */
	    m = 0;	/* mem size. */
            n = 1;	/* chars read. */
            strptr = NULL;

	    while((i != '\n') && (i != '\r') && (i != '\0'))
	    {
		/* Escape character? */
		if(i == '\\')
		{
		    /* Read next character. */
		    i = fgetc(fp);

		    /* Skip newlines internally. */
		    if((i == '\n') || (i == '\r'))
		    {
			i = fgetc(fp);

			/* Still counts as a line though! */
                        if(line_count != NULL)
                            *line_count += 1;
		    }
		}

		if(i == EOF)
		    break;

		/* Allocate more memory as needed. */
		if(m < n)
		{
		    /* Allocate FREAD_ALLOC_CHUNK_SIZE more bytes. */
		    m += FREAD_ALLOC_CHUNK_SIZE;

		    strptr = (char *)realloc(strptr, m * sizeof(char));
		    if(strptr == NULL)
			return(NULL);
		}

		strptr[n - 1] = (char)i;

                /* Read next character from file. */
		i = fgetc(fp);
		n++;	/* Increment characters read. */
	    }

	    /* Add newline and null terminate. */
	    m += 2;	/* 2 more chars. */
            strptr = (char *)realloc(strptr, m * sizeof(char));
	    if(strptr == NULL)
		return(NULL);
	    strptr[n - 1] = '\n';
	    strptr[n] = '\0';

	    /* Increment line count. */
            if(line_count != NULL)
                *line_count += 1;
	}
	else
	{
	    /* Comment character is not specified. */

            i = fgetc(fp);
            if(i == EOF)
		return(NULL);

            /* Begin adding characters to string. */
            m = 0;      /* Memory size. */
            n = 1;      /* Characters read. */
            strptr = NULL;	/* Return string. */

            while((i != '\n') && (i != '\r') && (i != '\0'))
            {
                /* Escape character? */
                if(i == '\\')
                {
                    /* Read next character. */
                    i = fgetc(fp);

                    /* Skip newlines internally. */
                    if((i == '\n') || (i == '\r'))
		    {
                        i = fgetc(fp);

                        /* Still counts as a line though! */
                        if(line_count != NULL)
                            *line_count += 1;
                    }
                }

                if(i == EOF)
                    break;

                /* Allocate more memory as needed. */
                if(m < n)
                {
                    /* Allocate FREAD_ALLOC_CHUNK_SIZE more bytes. */
                    m += FREAD_ALLOC_CHUNK_SIZE;

                    strptr = (char *)realloc(strptr, m * sizeof(char));
                    if(strptr == NULL)
			return(NULL);
                }
        
                strptr[n - 1] = (char)i;

		/* Read next character from file. */
                i = fgetc(fp);
                n++;	/* Increment characters read. */
            }

            /* Add newline and null terminate. */
            m += 2;	/* 2 more chars. */
            strptr = (char *)realloc(strptr, m * sizeof(char));
            strptr[n - 1] = '\n';
            strptr[n] = '\0';

            /* Increment line count. */
            if(line_count != NULL)
                *line_count += 1;
	}


	return(strptr);
}
