/*****************************************************************************
 *                                                                           *
 * Widget:    gtkimreg                                                       *
 * Uses:      GTK+1.2, GdkImlib                                              *
 * Purpose:   get user defined coordinates inside an image                   *
 * Author:    Andreas Tille <tillea@rki.de>                                  *
 * Date:      December 11, 1998                                              *
 * Copyright: Andreas Tille, 1998, 1999                                      *
 * License:   LGPL                                                           *
 *                                                                           *
 *****************************************************************************/

#ifndef __GTK_IMREG_H__
#define __GTK_IMREG_H__

#include <gdk_imlib.h>
#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_IMREG            (gtk_imreg_get_type ())
#define GTK_IMREG(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_IMREG, GtkImReg))
#define GTK_IMREG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_IMREG, GtkImRegClass))
#define GTK_IS_IMREG(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_IMREG))
#define GTK_IS_IMREG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IMREG))

typedef struct _GtkImReg       GtkImReg;
typedef struct _GtkImRegClass  GtkImRegClass;

typedef struct { gint le, to, ri, bo; } _Rubber;

typedef enum {
   NOWHERE,
   OUTSIDE,
   OUT,
   LEFT, 
   TOP,
   RIGHT,
   BOTTOM,
   LEFTTOP,
   RIGHTTOP,
   RIGHTBOTTOM,
   LEFTBOTTOM,
   INNER
} _CursorLocation;
#define CORNER  (INNER + 1)

enum {
   GTK_IMREG_SIZE_VARIABLE,
   GTK_IMREG_SIZE_FIX
};

struct _GtkImReg
{
  GtkWindow       window;

  GtkWidget      *main_vbox;
  GtkWidget      *cut;    /* drawable to show pixmap                       */
  GtkWidget      *pos;    /* Label to show current position                */
  GtkWidget      *size;   /* Label to show current size                    */
  GtkWidget      *hruler, *vruler;
  GtkWidget      *parms;  /* hbox with parameters                          */
  GtkWidget      *ok_button;
  GtkWidget      *cancel_button;
  GtkAdjustment  *adj_le, *adj_to, *adj_ri, *adj_bo;
  GdkPixmap      *pm;     /* Backing pixmap for drawing area               */
  GdkGC          *XorGc;  /* GC for drawing XOR-lines                      */
  _Rubber        *r;
  _Rubber        *old;
  _CursorLocation where;
  GdkImlibImage  *im;     /* ImLib structur with pixmap of known dimension */
  gint            rw, rh; /* dimensions of the region to select            */
  gint            xi, yi; /* Cursor coordinates when moving whole box      */
  gint            var;    /* flag if region has variable or fixed size     */
  
  GtkWidget      *user_area;
};

struct _GtkImRegClass
{
  GtkWindowClass parent_class;
};


GtkType    gtk_imreg_get_type   (void);
GtkWidget* gtk_imreg_new        (const gchar *title, GdkImlibImage *im, gint rw, gint rh, 
                                 GtkWidget *user_area);
gint       gtk_imreg_get_left   (GtkImReg *imreg);
gint       gtk_imreg_get_top    (GtkImReg *imreg);
gint       gtk_imreg_get_right  (GtkImReg *imreg);
gint       gtk_imreg_get_bottom (GtkImReg *imreg);
gint       gtk_imreg_get        (GtkImReg *imreg, gint *le, gint *to, gint *ri, gint *bo);
gint       gtk_imreg_set_left   (GtkImReg *imreg, gint left);
gint       gtk_imreg_set_top    (GtkImReg *imreg, gint top);
gint       gtk_imreg_set_right  (GtkImReg *imreg, gint right);
gint       gtk_imreg_set_bottom (GtkImReg *imreg, gint bottom);
gint       gtk_imreg_set        (GtkImReg *imreg, gint left, gint top, gint right, gint bottom);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_IMREG_H__ */

