/***************************************************************************
                          rcadwidget.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rcadwidget.cpp 1998/08/24 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qapplication.h>
#include <qprinter.h>
#include <qpaintdevicemetrics.h>

#include "rcadwidget.h"

#include "rappwin.h"
#include "rgraphic.h"
#include "rlayoutdef.h"
#include "rlog.h"

// Constructor:
//
// _rw: read/write?
//
RCadWidget::RCadWidget(bool _rw,
                       RAppWin* _appWin,
                       QWidget* _parent, 
                       const char* _name, 
                       WFlags _f)
:RWidget(_parent, _name, _f)
{
  graphic=0;
  setBackgroundColor(darkGray);
  layerWidget=new RLayerWidget(_rw, this, "rlayerwidget");
  layerWidget->hide();
  infoWidget=new RInfoWidget(this, "rinfowidget");
  infoWidget->hide();
  printPreview=false;
  appWin = _appWin;
  show();
}



// Destructor:
//
RCadWidget::~RCadWidget()
{
}


// Get file name (from graphic):
//
QString
RCadWidget::getFileName() 
{ 
  if(graphic) {
    return graphic->getFileName(); 
  }
  else {
    return QString();
  }
}



// Set pointer to graphic:
//   connect graphic with layer list
//
void
RCadWidget::setGraphic(RGraphic* _graphic)
{
  bool reactivate=false;   // reactivate this graphic for simulation events
  
  RLOG("setGraphic");
  
  if(layerWidget && graphic) {
    // Disconnect old signals:
    //
    disconnect(graphic);
    disconnect(layerWidget,0, graphic,0);

    RLOG("\ndisconnected graphic");

    if(graphic && graphic->isActive()) {
      reactivate=true;
      graphic->setActive(false);
    }
  }

  // Set new Graphic pointer:
  //  
  graphic=_graphic;

  if(layerWidget) {
    layerWidget->setGraphic(graphic);
    if(graphic) {
      // Connect signal "updateLayers" from the current
      //   graphic document with slot "updateLayerList"
      //   from the layerWidget
      //
      connect(graphic,  SIGNAL(updateLayers()), 
              layerWidget, SLOT(updateLayerList()));
  
      // Connect signal "layerSwitched" from the LayerWidget
      //   with slot "switchLayer" from the current graphic 
      //   document:
      //
      connect(layerWidget, SIGNAL(layerSwitched(const char*)), 
              graphic,  SLOT(switchLayer(const char*)));

      // Connect signal "layerSelected" from the LayerWidget
      //   with slot "selectLayer" from the current graphic 
      //   document:
      //
      connect(layerWidget, SIGNAL(layerSelected(const char*)), 
              graphic,  SLOT(selectLayer(const char*)));

      if(reactivate) RAppWin::getRAppWin()->activateDocument(graphic);
    }
  }

  if(infoWidget) {
    infoWidget->setGraphic(graphic);

    if(graphic) {
      // Connect signal "graphicChanged" from the current
      //   graphic document with slot "updateInfo"
      //   from the infoWidget
      //
      connect(graphic,  SIGNAL(graphicChanged()), 
              infoWidget, SLOT(updateInfo()));
    }
  }
}



// Show cad widget and all widgets in it:
//
void 
RCadWidget::show()
{
  RWidget::show();
  
  if(graphic) {
    graphic->show();
  }
}



// Resize event:
//
void 
RCadWidget::resizeEvent(QResizeEvent* /*_ev*/ )
{
  //RWidget::resizeEvent(_ev);
  
  resizeChildren();
}



// Resize children:
//
void 
RCadWidget::resizeChildren()
{
  // Resize cad graphic:
  //
  if(graphic) {

    int rightBorder=width();    // Borders of graphic widget
    int bottomBorder=height();
    
    if(graphic) graphic->setUpdatesEnabled(false);
  
    if(infoWidget && isInfoWidgetVisible()) {
      bottomBorder=height()-DEF_INFOHEIGHT;
      infoWidget->setGeometry(0, bottomBorder,
                              width(), DEF_INFOHEIGHT);
    }
    
    if(layerWidget && isLayerWidgetVisible()) {
      QSize wdgSize=layerWidget->sizeHint();
      rightBorder=width()-wdgSize.width();
      layerWidget->setGeometry(rightBorder, 0, 
                               wdgSize.width(), bottomBorder);
    }
    
    // Print preview (resize to the paper size):
    //
    if(printPreview && appWin) {
    
      /*graphic->setGeometry(50,0, 
                           rightBorder-50, 
                           bottomBorder);*/
                           
      //appWin->updatePrintMetrics();
      
      if(appWin->getPaperHeight()>0 && appWin->getPaperWidth()>0) {
        float z;
        int w = appWin->getPaperWidth();
        int h = appWin->getPaperHeight();
        
        if((float)bottomBorder/h < (float)rightBorder/w) {
          z=(float)bottomBorder/h;
        }
        else {
          z=(float)rightBorder/w;
        }
        
        graphic->setGeometry((rightBorder-z*w)/2,
                             (bottomBorder-z*h)/2, 
                             rightBorder-(rightBorder-z*w), 
                             bottomBorder-(bottomBorder-z*h));
      }
      else {
        graphic->setGeometry(50,0, 
                             rightBorder-100, 
                             bottomBorder);
      }
                           
      /*QPrinter* printer = appWin->getPrinter();
      if(printer) {
        QPaintDeviceMetrics metrics(printer);
        
        if(metrics.height()>0 && metrics.width()>0) {
          float z;
          if(bottomBorder/metrics.height() < rightBorder/metrics.width()) {
            z=bottomBorder/metrics.height();
          }
          else {
            z=rightBorder/metrics.width();
          }
          
          graphic->setGeometry((rightBorder-z*metrics.width())/2,
                               (bottomBorder-z*metrics.height())/2, 
                               rightBorder-(rightBorder-z*metrics.width()), 
                               bottomBorder-(bottomBorder-z*metrics.height()));
        }
        else {
          graphic->setGeometry(50,0, 
                               rightBorder-100, 
                               bottomBorder);
        }
      }*/
    }
    
    // Normal mode:
    //
    else {
      graphic->setGeometry(0,0, 
                           rightBorder, 
                           bottomBorder);
    }
                         
    graphic->setUpdatesEnabled(true);
    
    graphic->update();
  }
}


// EOF

