/***************************************************************************
                          rcadwidget.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rcadwidget.h 1998/08/24 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RCADWIDGET_H
#define RCADWIDGET_H

#include "rappwin.h"
#include "rinfowidget.h"
#include "rlayerwidget.h"
#include "rwidget.h"


class RGraphic;

/*! CAD Widget<br>
    Contains the graphic doc, the layer widget and the info widget.<br>
    This class is responible for the correct resizing of these widgets.
*/
class RCadWidget : public RWidget
{
  Q_OBJECT
public:
  /*! Constructor
      \param _rw Read/write. true: The graphic is editable and the user can add/remove layers<br>
                             false: The graphic can not get changed and the buttons "add" aand "remove" in the layer widget are not visible.
      \param _parent The parent widget
      \param _name Name
      \param _f The widget flags. (e.g.: WStyle_NormalBorder, ...)
  */
  RCadWidget(bool _rw,
             RAppWin* _appWin,
             QWidget* _parent=0, 
             const char* _name=0, 
             WFlags _f=0);
  /*! Destructor
  */
  ~RCadWidget();
  
  /*! Get the name of the loaded file
  */
  QString getFileName();
  
  /*! Set pointer to the graphic doc
  */
  void      setGraphic(RGraphic* _graphic);
  /*! Get pointer to the graphic doc
  */
  RGraphic* getGraphic() { return graphic; }
  
  /*! Switches on/off print preview mode
  */
  void setPrintPreview(bool _prev) { if(graphic) {
                                       if(_prev) graphic->setFlag(G_PRINTPREV);
                                       else      graphic->delFlag(G_PRINTPREV);
                                     }
                                     printPreview=_prev;
                                   }
  
  /*! Returns if the print preview is on (=true) or off (=false)
  */
  bool getPrintPreview() { return printPreview; }
  
  /*! Check if a graphic document is available and active (black border)
      \return true: graphic doc active
              false: graphic doc not active or not available
  */
  bool    isActive() { if(graphic) return graphic->isActive();
                       else        return false;               }
  /*! Change activity of the graphic document included in this widget if there is one.
      \param _active true: set graphic to active
                     false: set graphic to inactive
  */
  void    setActive(bool _active) { if(graphic) graphic->setActive(_active); }
  
  /*! Check if the layer widget is visible
      \return true: Layer widget is visible
              false: Layer widget is invisible
  */
  bool    isLayerWidgetVisible() { if(layerWidget && layerWidget->isVisible()) return true;
                                   else                                        return false; }
  /*! Show/hide the layer widget
      \param _show true: show
                   false: hide
  */
  void    showLayerWidget(bool _show) { if(layerWidget) { if(_show) layerWidget->show();
                                                          else      layerWidget->hide(); } }
  /*! Check if the info widget is visible
      \return true: Info widget visible
              false: Info widget invisible
  */
  bool    isInfoWidgetVisible() { if(infoWidget && infoWidget->isVisible()) return true;
                                  else                                      return false; }
  /*! Show/hide the info widget
      \param _show true: show
                   false: hide
  */
  void    showInfoWidget(bool _show) { if(infoWidget) { if(_show) infoWidget->show();
                                                        else      infoWidget->hide(); } }

  /*! Resize child widgets
  */
  void    resizeChildren();

protected:
  /*! The resize event
  */
  virtual void resizeEvent(QResizeEvent* _ev);
    
public slots:
  /*! Show the whole CAD widget
  */
  virtual void show();

private:
  /*! Pointer to the application
  */
  RAppWin*      appWin;
  /*! Pointer to the graphic doc
  */
  RGraphic*     graphic;
  /*! Pointer to the layer widget
  */
  RLayerWidget* layerWidget;
  /*! Pointer to the info widget
  */
  RInfoWidget*  infoWidget;
  /*! Is this widget in print preview mode?
  */
  bool printPreview;
  
};


#endif

// EOF



