/***************************************************************************
                          rconfigmach.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rconfigmach.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <ctype.h>

#include <qfile.h>
#include <qfileinfo.h>
#include <qframe.h>
#include <qkeycode.h>
#include <qlayout.h>
#include <qlist.h>

#include <qscrollview.h>
#include <qstrlist.h>
#include <qtextstream.h>
#include <qtimer.h>
#include <qtooltip.h>

#include "rcheckbox.h"
#include "rconfigmach.h"
#include "rcombobox.h"
#include "rfile.h"
#include "rconfig.h"
#include "rinputdialog.h"
#include "rlabel.h"
#include "rlineedit.h"
#include "rlog.h"
#include "rprgdef.h"
#include "rpushbutton.h"
#include "rstring.h"
#include "rxpmorder.h"
#include "ryesnodialog.h"

#define SORT_A RMES(94)
#define SORT_L RMES(95)
#define SORT_C RMES(96)
#define SORT_N RMES(97)
#define DIR_N  RMES(98)
#define DIR_2  RMES(99)
#define DIR_3  RMES(100)
#define DIR_S  RMES(101)
#define NO_LIMIT RMES(102)
#define NO_DESCRIPTION "-"


// Constructor:
//
RConfigMach::RConfigMach(const char* _machFile,
                         QWidget* _parent, 
                         const char* _name)
  :QTabDialog(_parent, _name, true, WStyle_NormalBorder)
{
  int i;

  QString caption;
  caption.sprintf("%s '%s'",
                  RMES(103),
                  _machFile);
  setCaption(caption);
  
  setFixedSize(DEF_CONFIGMACH_WIDTH, DEF_CONFIGMACH_HEIGHT);

  setOkButton();
  setDefaultButton(RMES(48));
  setCancelButton();

  connect(this, SIGNAL(applyButtonPressed()),
          this, SLOT(okDialog()));

  machFile = _machFile;
  
  updateParameterActive=true;
  parameterHasChanged=true;
  autoUpdateOrders=true;

  pixInsertItem = new QPixmap(insertitem_xpm);
  pixDeleteItem = new QPixmap(deleteitem_xpm);
  boldFont      = new QFont("Helvetica", 14, QFont::Bold);

  // First page "Options":
  //
  wOptions = new QWidget(this, "woptions");

    // Stuff the Labels and Comboboxes into a grid layout:
    //
    QGridLayout * gl = new QGridLayout(wOptions, 11, 4, 5);
    gl->setColStretch(0, 5);
    gl->setColStretch(1, 6);
    gl->setColStretch(2, 5);
    gl->setColStretch(3, 6);

    gl->setRowStretch(0, 1);
    for(i=1; i<=9; ++i) gl->setRowStretch(i, 2);
    gl->setRowStretch(10, 1);
    
    // Extension:
    //
    lExtension = new RLabel(RMES(104), wOptions, "lextension");
    lExtension->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lExtension, RMES(105));
    gl->addWidget(lExtension, 1, 0);
    mbExtension = new RComboBox(true, wOptions, "mbextension");
    gl->addWidget(mbExtension, 1, 1);

    // Optimization:
    //
    lOptimization = new RLabel(RMES(106), wOptions, "loptimization");
    lOptimization->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lOptimization, RMES(107));
    gl->addWidget(lOptimization, 2, 0);
    mbOptimization = new RComboBox(false, wOptions, "mboptimization");
    mbOptimization->insertItem(RMES(108));  // On
    mbOptimization->insertItem(RMES(109));  // Cancel
    gl->addWidget(mbOptimization, 2, 1);

    // ContourCenter:
    //
    lContourCenter = new RLabel(RMES(110), wOptions, "lContourCenter");
    lContourCenter->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lContourCenter, RMES(111));
    gl->addWidget(lContourCenter, 3, 0);
    mbContourCenter = new RComboBox(false, wOptions, "mbContourCenter");
    mbContourCenter->insertItem(RMES(108));  // On
    mbContourCenter->insertItem(RMES(109));  // Cancel
    gl->addWidget(mbContourCenter, 3, 1);

    // Sorting:
    //
    lSorting = new RLabel(RMES(112), wOptions, "lSorting");
    lSorting->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lSorting, RMES(113));
    gl->addWidget(lSorting, 4, 0);
    mbSorting = new RComboBox(false, wOptions, "mbSorting");
    mbSorting->insertItem(SORT_N);
    mbSorting->insertItem(SORT_A);
    mbSorting->insertItem(SORT_L);
    mbSorting->insertItem(SORT_C);
    gl->addWidget(mbSorting, 4, 1);

    // Direction:
    //
    lDirection = new RLabel(RMES(114), wOptions, "lDirection");
    lDirection->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lDirection, RMES(115));
    gl->addWidget(lDirection, 5, 0);
    mbDirection = new RComboBox(false, wOptions, "mbDirection");
    mbDirection->insertItem(DIR_N);
    mbDirection->insertItem(DIR_2);
    mbDirection->insertItem(DIR_3);
    mbDirection->insertItem(DIR_S);
    gl->addWidget(mbDirection, 5, 1);

    // StartNumber:
    //
    lStartNumber = new RLabel(RMES(116), wOptions, "lStartNumber");
    lStartNumber->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lStartNumber, RMES(117));
    gl->addWidget(lStartNumber, 6, 0);
    mbStartNumber = new RComboBox(true, wOptions, "mbStartNumber");
    gl->addWidget(mbStartNumber, 6, 1);
    
    // NumberStep:
    //
    lNumberStep = new RLabel(RMES(118), wOptions, "lNumberStep");
    lNumberStep->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lNumberStep, RMES(119));
    gl->addWidget(lNumberStep, 7, 0);
    mbNumberStep = new RComboBox(true, wOptions, "mbNumberStep");
    gl->addWidget(mbNumberStep, 7, 1);

    // MaxArcAngle:
    //
    lMaxArcAngle = new RLabel(RMES(120), wOptions, "lMaxArcAngle");
    lMaxArcAngle->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lMaxArcAngle, RMES(121));
    gl->addWidget(lMaxArcAngle, 8, 0);
    mbMaxArcAngle = new RComboBox(true, wOptions, "mbMaxArcAngle");
    gl->addWidget(mbMaxArcAngle, 8, 1);

    // MaxArcLength:
    //
    lMaxArcLength = new RLabel(RMES(122), wOptions, "lMaxArcLength");
    lMaxArcLength->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lMaxArcLength, RMES(123));
    gl->addWidget(lMaxArcLength, 9, 0);
    mbMaxArcLength = new RComboBox(true, wOptions, "mbMaxArcLength");
    gl->addWidget(mbMaxArcLength, 9, 1);
    
    // Tolerance:
    //
    lTolerance = new RLabel(RMES(124), wOptions, "lTolerance");
    lTolerance->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lTolerance, RMES(125));
    gl->addWidget(lTolerance, 1, 2);
    mbTolerance = new RComboBox(true, wOptions, "mbTolerance");
    gl->addWidget(mbTolerance, 1, 3);

    // Factor:
    //
    lFactor = new RLabel(RMES(126), wOptions, "lFactor");
    lFactor->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lFactor, RMES(127));
    gl->addWidget(lFactor, 2, 2);
    mbFactor = new RComboBox(true, wOptions, "mbFactor");
    gl->addWidget(mbFactor, 2, 3);

    // Pointing:
    //
    lPointing = new RLabel(RMES(128), wOptions, "lPointing");
    lPointing->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lPointing, RMES(129));
    gl->addWidget(lPointing, 3, 2);
    mbPointing = new RComboBox(false, wOptions, "mbPointing");
    mbPointing->insertItem(RMES(108));  // On
    mbPointing->insertItem(RMES(109));  // Off
    gl->addWidget(mbPointing, 3, 3);
    
    // PointingAngle:
    //
    lPointingAngle = new RLabel(RMES(130), wOptions, "lPointingAngle");
    lPointingAngle->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lPointingAngle, RMES(131));
    gl->addWidget(lPointingAngle, 4, 2);
    mbPointingAngle = new RComboBox(true, wOptions, "mbPointingAngle");
    mbPointingAngle->insertItem("60.0");
    mbPointingAngle->insertItem("90.0");
    gl->addWidget(mbPointingAngle, 4, 3);

    // PointingDepth:
    //
    lPointingDepth = new RLabel(RMES(132), wOptions, "lPointingDepth");
    lPointingDepth->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lPointingDepth, RMES(133));
    gl->addWidget(lPointingDepth, 5, 2);
    mbPointingDepth = new RComboBox(true, wOptions, "mbPointingDepth");
    mbPointingDepth->insertItem("2.0");
    gl->addWidget(mbPointingDepth, 5, 3);

    // PointingLimit:
    //
    lPointingLimit = new RLabel(RMES(134), wOptions, "lPointingLimit");
    lPointingLimit->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lPointingLimit, RMES(135));
    gl->addWidget(lPointingLimit, 6, 2);
    mbPointingLimit = new RComboBox(true, wOptions, "mbPointingLimit");
    mbPointingLimit->insertItem("10.0");
    mbPointingLimit->insertItem("5.0");
    mbPointingLimit->insertItem("2.5");
    gl->addWidget(mbPointingLimit, 6, 3);

    // PointingMaxLength:
    //
    lPointingMaxLength = new RLabel(RMES(136), wOptions, "lPointingMaxLength");
    lPointingMaxLength->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lPointingMaxLength, RMES(137));
    gl->addWidget(lPointingMaxLength, 7, 2);
    mbPointingMaxLength = new RComboBox(true, wOptions, "mbPointingMaxLength");
    mbPointingMaxLength->insertItem("10.0");
    mbPointingMaxLength->insertItem("20.0");
    mbPointingMaxLength->insertItem("50.0");
    gl->addWidget(mbPointingMaxLength, 7, 3);

    
  // Second page "Parameter":
  //    
  wParameter = new QWidget(this, "wparameter");

    // Stuff the Labels and Comboboxes into a grid layout:
    //
    gl = new QGridLayout(wParameter, 11, 8, 7);

    gl->setColStretch(0, 1);
    gl->setColStretch(1, 1);
    gl->setColStretch(2, 1);
    gl->setColStretch(3, 1);
    gl->setColStretch(4, 1);
    gl->setColStretch(5, 1);
    gl->setColStretch(6, 1);
    gl->setColStretch(7, 1);

    gl->setRowStretch(0, 1);
    gl->setRowStretch(1, 2);
    gl->setRowStretch(2, 1);
    for(i=3; i<=9; ++i) gl->setRowStretch(i, 2);
    gl->setRowStretch(10, 1);
  
    lParameter = new RLabel(RMES(138), wParameter, "lparameter");
    lParameter->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lParameter, RMES(139));
    gl->addWidget(lParameter, 1, 0);

    mbParameter = new RComboBox(false, wParameter, "mbParameter");
    gl->addMultiCellWidget(mbParameter, 1, 1, 1, 2);
    connect(mbParameter, SIGNAL(activated(int)),
            this,        SLOT(parameterChanged(int)));

    bAddParameter = new RPushButton(RMES(140), wParameter, "bAddParameter");
    gl->addMultiCellWidget(bAddParameter, 1, 1, 4, 5);
    QToolTip::add(bAddParameter, RMES(141));
    connect(bAddParameter, SIGNAL(clicked()),
            this, SLOT(addParameter()));

    bDelParameter = new RPushButton(RMES(142), wParameter, "bDelParameter");
    gl->addMultiCellWidget(bDelParameter, 1, 1, 6, 7);
    QToolTip::add(bDelParameter, RMES(143));
    connect(bDelParameter, SIGNAL(clicked()),
            this, SLOT(delParameter()));

    fSep1 = new QFrame(wParameter, "fsep1");
    fSep1->setFrameStyle(QFrame::HLine|QFrame::Sunken);
    gl->addMultiCellWidget(fSep1, 2, 2, 0, 7);

    // --

    lCode = new RLabel(RMES(144), wParameter, "lCode");
    lCode->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lCode, RMES(145));
    gl->addMultiCellWidget(lCode, 3, 3, 2, 3);

    eCode = new RLineEdit(wParameter, "eCode");
    eCode->setMaxLength(1);
    gl->addWidget(eCode, 3, 4);
    connect(eCode, SIGNAL(textChanged(const QString&)),
            this,  SLOT(parameterCodeChanged(const QString&)));

    cbLayer = new RCheckBox(RMES(146), wParameter, "cblayer");
    QToolTip::add(cbLayer, RMES(147));
    gl->addMultiCellWidget(cbLayer, 4, 4, 4, 5);

    cbFix = new RCheckBox(RMES(148), wParameter, "cbfix");
    QToolTip::add(cbFix, RMES(149));
    gl->addMultiCellWidget(cbFix, 5, 5, 4, 5);

    lDescription = new RLabel(RMES(150), wParameter, "lDescription");
    lDescription->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lDescription, RMES(151));
    gl->addMultiCellWidget(lDescription, 6, 6, 2, 3);

    eDescription = new RLineEdit(wParameter, "eDescription");
    gl->addMultiCellWidget(eDescription, 6, 6, 4, 6);
    connect(eDescription, SIGNAL(textChanged(const QString&)),
            this,         SLOT(parameterDescriptionChanged(const QString&)));

    lValueList = new RLabel(RMES(152), wParameter, "lValueList");
    lValueList->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lValueList, RMES(153));
    gl->addMultiCellWidget(lValueList, 7, 7, 1, 3);

    eValueList = new RLineEdit(wParameter, "eValueList");
    gl->addMultiCellWidget(eValueList, 7, 7, 4, 6);

    lStandardValue = new RLabel(RMES(154), wParameter, "lStandardValue");
    lStandardValue->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lStandardValue, RMES(155));
    gl->addMultiCellWidget(lStandardValue, 8, 8, 2, 3);

    eStandardValue = new RLineEdit(wParameter, "eStandardValue");
    gl->addMultiCellWidget(eStandardValue, 8, 8, 4, 4);

    updateParameterActive=true;


  // Third page "Orders":
  //
  wOrder = new QWidget(this, "wOrder");

    lastOrderName[0]='\0';

    // Stuff the single items into auto-delete Lists
    //
    bDeleteItem.setAutoDelete(true);
    bInsertItem.setAutoDelete(true);
    mbItem.setAutoDelete(true);
    sOldItem.setAutoDelete(true);
    lItem.setAutoDelete(true);
    fItemSep.setAutoDelete(true);

    // Stuff the Labels and Comboboxes into a grid layout:
    //
    gl = new QGridLayout(wOrder, 11, 8, 7);

    gl->setRowStretch(0, 1);
    gl->setRowStretch(1, 2);
    gl->setRowStretch(2, 1);
    for(i=3; i<=9; ++i) gl->setRowStretch(i, 2);
    gl->setRowStretch(10, 1);

    lOrder = new RLabel(RMES(156), wOrder, "lOrder");
    lOrder->setAlignment(AlignRight|AlignVCenter);
    QToolTip::add(lOrder, RMES(157));
    gl->addWidget(lOrder, 1, 0);

    mbOrder = new RComboBox(false, wOrder, "mbOrder");
    gl->addMultiCellWidget(mbOrder, 1, 1, 1, 2);
    connect(mbOrder, SIGNAL(activated(const QString&)),
            this,    SLOT(orderChanged(const QString&)));

    bAddOrder = new RPushButton(RMES(158), wOrder, "bAddOrder");
    gl->addMultiCellWidget(bAddOrder, 1, 1, 4, 5);
    QToolTip::add(bAddOrder, RMES(159));
    connect(bAddOrder, SIGNAL(clicked()),
            this, SLOT(addOrder()));

    bDelOrder = new RPushButton(RMES(160), wOrder, "bDelOrder");
    gl->addMultiCellWidget(bDelOrder, 1, 1, 6, 7);
    QToolTip::add(bDelOrder, RMES(161));
    connect(bDelOrder, SIGNAL(clicked()),
            this, SLOT(delOrder()));

    fSep2 = new QFrame(wOrder, "fsep2");
    fSep2->setFrameStyle(QFrame::HLine|QFrame::Sunken);
    gl->addMultiCellWidget(fSep2, 2, 2, 0, 7);

    // --

    scOrder = new QScrollView(wOrder, "scOrder");
    wdOrder = new QWidget(scOrder, "wdOrder");
    scOrder->addChild(wdOrder);
    scOrder->setVScrollBarMode(QScrollView::AlwaysOn);
    scOrder->setHScrollBarMode(QScrollView::AlwaysOff);
    gl->addMultiCellWidget(scOrder, 3, 10, 0, 7);

  updateParametersFromGenerator();
  fillOptionLists();
  updateOptionsFromGenerator();
  updateOrdersFromGenerator();
  
  addTab(wOptions, RMES(162));
  addTab(wParameter, RMES(163));
  addTab(wOrder, RMES(164));

  connect(this, SIGNAL(selected(const QString&)),
          this, SLOT(tabSelected(const QString&)));
}



// Destructor:
//
RConfigMach::~RConfigMach()
{

}



//
// First Page: Options:
//



// Update values in Comboboxes (Page "Options")
//   from machine generator:
//
bool
RConfigMach::updateOptionsFromGenerator()
{
  QString machineGeneratorPath = fileSearchFile("machines", machFile);
  QFile maFile(machineGeneratorPath);

  // Reset layout to standard values:
  //
  mbExtension->setEditText("");
  mbOptimization->setEditText(RMES(108));
  mbContourCenter->setEditText(RMES(109));
  mbSorting->setEditText(SORT_N);
  mbDirection->setEditText(DIR_N);
  mbStartNumber->setEditText("10");
  mbNumberStep->setEditText("10");
  mbMaxArcAngle->setEditText(NO_LIMIT);
  mbMaxArcLength->setEditText(NO_LIMIT);
  mbTolerance->setEditText("0.001");
  mbFactor->setEditText("1.0");
  mbPointing->setEditText(RMES(109));
  mbPointingAngle->setEditText("60.0");
  mbPointingDepth->setEditText("0.2");
  mbPointingLimit->setEditText("5.0");
  mbPointingMaxLength->setEditText("20.0");

  // Read entries from mach-File:
  //
  if(maFile.open(IO_ReadOnly)) {
    QTextStream maStream(&maFile);
    QString maLine;        // a line
    QString maSection;     // a section (e.g.: "[Standards]")

    while(!maStream.eof()) {
      maLine=maStream.readLine();
      maLine=maLine.stripWhiteSpace();

      // New section:
      //
      if(maLine.at(0)=='[') {
        maSection=maLine.latin1();
      }
      else {
        if(maSection=="[Standards]") {
          if(maLine.contains("Extension")) {
            mbExtension->setEditText(strGetStringFromIniLine(maLine).latin1());
          }
          
          if(maLine.contains("Optimization")) {
            bool opt=(bool)strGetIntFromIniLine(maLine);
            if(opt) mbOptimization->setEditText("On");
            else    mbOptimization->setEditText("Off");
          }

          if(maLine.contains("ContourCenter")) {
            bool cont=(bool)strGetIntFromIniLine(maLine);
            if(cont) mbContourCenter->setEditText("On");
            else     mbContourCenter->setEditText("Off");
          }

          if(maLine.contains("Sorting")) {
            switch(strGetStringFromIniLine(maLine).at(0).latin1()) {
              case 'a':
                mbSorting->setEditText(SORT_A);
                break;
              case 'l':
                mbSorting->setEditText(SORT_L);
                break;
              case 'c':
                mbSorting->setEditText(SORT_C);
                break;
              default:
                mbSorting->setEditText(SORT_N);
                break;
            }
          }

          if(maLine.contains("Direction")) {
            switch(strGetStringFromIniLine(maLine).at(0).latin1()) {
              case '2':
                mbDirection->setEditText(DIR_2);
                break;
              case '3':
                mbDirection->setEditText(DIR_3);
                break;
              case 's':
                mbDirection->setEditText(DIR_S);
                break;
              default:
                mbDirection->setEditText(DIR_N);
                break;
            }
          }

          if(maLine.contains("StartNumber")) {
            mbStartNumber->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("NumberStep")) {
            mbNumberStep->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("MaxArcAngle")) {
            mbMaxArcAngle->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("MaxArcLength")) {
            mbMaxArcLength->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("Tolerance")) {
            mbTolerance->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("Factor")) {
            mbFactor->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("Pointing")) {
            bool pt=(bool)strGetIntFromIniLine(maLine);
            if(pt) mbPointing->setEditText("On");
            else   mbPointing->setEditText("Off");
          }

          if(maLine.contains("PointingAngle")) {
            mbPointingAngle->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("PointingDepth")) {
            mbPointingDepth->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("PointingLimit")) {
            mbPointingLimit->setEditText(strGetStringFromIniLine(maLine));
          }

          if(maLine.contains("PointingMaxLength")) {
            mbPointingMaxLength->setEditText(strGetStringFromIniLine(maLine));
          }
        }
      }
    }
    maFile.close();
    return true;
  }
  else {
    return false;
  }
}




// Fill the option lists with values and parameters:
//
bool
RConfigMach::fillOptionLists()
{
  // Some Combobox-Lists can change their contents:
  //
  if(mbParameter) {
    if(mbExtension) {
      mbExtension->fillInItemsFrom(mbParameter);
      mbExtension->insertItem("D", 0);
      mbExtension->insertItem("CNC", 0);
      mbExtension->insertItem("NC", 0);
    }
    if(mbStartNumber) {
      mbStartNumber->fillInItemsFrom(mbParameter);
      mbStartNumber->insertItem("10", 0);
      mbStartNumber->insertItem("5", 0);
      mbStartNumber->insertItem("1", 0);
    }
    if(mbNumberStep) {
      mbNumberStep->fillInItemsFrom(mbParameter);
      mbNumberStep->insertItem("10", 0);
      mbNumberStep->insertItem("5", 0);
      mbNumberStep->insertItem("1", 0);
    }
    if(mbMaxArcAngle) {
      mbMaxArcAngle->fillInItemsFrom(mbParameter);
      mbMaxArcAngle->insertItem("180.0", 0);
      mbMaxArcAngle->insertItem("90.0", 0);
      mbMaxArcAngle->insertItem("45.0", 0);
      mbMaxArcAngle->insertItem(NO_LIMIT, 0);
    }
    if(mbMaxArcLength) {
      mbMaxArcLength->fillInItemsFrom(mbParameter);
      mbMaxArcLength->insertItem("5.0", 0);
      mbMaxArcLength->insertItem("2.0", 0);
      mbMaxArcLength->insertItem(NO_LIMIT, 0);
    }
    if(mbTolerance) {
      mbTolerance->fillInItemsFrom(mbParameter);
      mbTolerance->insertItem("0.005", 0);
      mbTolerance->insertItem("0.004", 0);
      mbTolerance->insertItem("0.003", 0);
      mbTolerance->insertItem("0.002", 0);
      mbTolerance->insertItem("0.001", 0);
    }
    if(mbFactor) {
      mbFactor->fillInItemsFrom(mbParameter);
      mbFactor->insertItem("1.0", 0);
    }
  }
  parameterHasChanged=false;
  
  return true;
}



// 
// Second Page: Parameters:
//



// Update values in Layout (Page "Parameters")
//   from machine generator
//   and fill parameter / parameterString for
//   presaving / temporary saving:
//
bool
RConfigMach::updateParametersFromGenerator()
{
  if(mbParameter && cbLayer && cbFix && eDescription &&
     eValueList && eStandardValue) {
    QString machineGeneratorPath = fileSearchFile("machines", machFile);
    QFile maFile(machineGeneratorPath);
  
    // Reset layout:
    //
    mbParameter->fillInParameters(machFile.latin1());
    cbLayer->setChecked(false);
    cbFix->setChecked(false);
    eDescription->setText("");
    eValueList->setText("");
    eStandardValue->setText("");
    
    // Read entries from mach-File:
    //
    if(maFile.open(IO_ReadOnly)) {
      QTextStream maStream(&maFile);
      QString maLine;        // a line
      QString maSection;     // a section (e.g.: "[Standards]")

      parameterString="";
  
      while(!maStream.eof()) {
        maLine=maStream.readLine();
        maLine=maLine.stripWhiteSpace();
  
        // New section:
        //
        if(maLine.at(0)=='[') {
          maSection=maLine.latin1();
        }
        else {
          if(maSection=="[Parameter]" || maSection=="[LayerParameter]") {
            if(maLine.contains("Parameter")) {
              char  scode;            // Code for parameter
              char  slabel[128];      // Label for parameter
              bool  sreadwrite;       // Read/write (fixed/free)
              bool  slayer;           // layer dependence?
              char  sstd[64];         // Standard value
              char  slist[256];       // List of other values seperated with spaces
              
              sreadwrite=true;
              slayer=false;
              slabel[0]='\0';
              sstd[0]='\0';
              slist[0]='\0';
              
              strGetValuesFromParameterLine(maLine.latin1(),
                                            &slayer,
                                            &sreadwrite,
                                            &scode,
                                            slabel,
                                            sstd,
                                            slist);

              if((int)strlen(slabel)==0) strcpy(slabel, NO_DESCRIPTION);
              if((int)strlen(sstd)==0) strcpy(sstd, "0");
              if((int)strlen(slist)==0) strcpy(slist, "0");
  
              RLOG("\nupdateParameterFromGenerator: $");
              RLOG(scode);
              RLOG(" ");
              RLOG(slabel);
              RLOG(" ");
              RLOG(sstd);
              RLOG(" ");
              RLOG(slist);
  
              // Save code in parameter string:
              //
              parameterString+=scode;

              RLOG("\nparameterString: ");
              RLOG(parameterString);

              // Presave tis parameter:
              //
              int numParameter=parameterString.length()-1;
  
              if(numParameter>=0 && numParameter<DEF_MAXPARAMETERS) {
                if(slayer)     parameter[numParameter] = "LayerParameter ";
                else           parameter[numParameter] = "Parameter ";
                if(sreadwrite) parameter[numParameter] += "free ";
                else           parameter[numParameter] += "fixed ";
                parameter[numParameter] += "$";
                parameter[numParameter] += scode;
                parameter[numParameter] += " ";
                parameter[numParameter] += slabel;
                parameter[numParameter] += " ";
                parameter[numParameter] += sstd;
                parameter[numParameter] += " ";
                parameter[numParameter] += slist;

                RLOG("\nparameter[");
                RLOG(numParameter);
                RLOG("] = ");
                RLOG(maLine.latin1());
              }
            }
          }
        }
      }
      maFile.close();
  
      updateParameterValues();
      return true;
    }
  }
  return false;
}
  
  
  
// Update values in Layout (Page "Parameters")
//   from selected item in combo box "Parameter:"
//   take values from  parameter / parameterString from
//   presaving / temporary saving:
//
bool
RConfigMach::updateParameterValues()
{
  bool ret=false;
  
  if(mbParameter && cbLayer && cbFix && 
     eDescription && eValueList && eStandardValue) {

    updateParameterActive=false;
    
    QString parStr;   // e.g.: "$e (Extension)"
    char parCode;     // e.g.: 'e'
    int parLine;      // e.g.: "Parameter free $e Extension NC  CNC D"
    int where;        // index where to find the parameter code
    
    // Find parameter code from combobox:
    //
    parStr=mbParameter->currentText();
    where=parStr.find('$');
    if(where>=0) {
      parCode=parStr.at(where+1).latin1();
      if(isalpha(parCode)) {

        // Find presaved data:
        //
        parLine=getParameterLineIndex(parCode);
    
        if(parLine>=0 && parLine<(int)parameterString.length()) {
          char  slabel[128];      // Label for parameter
          bool  sreadwrite;       // Read/write (fixed/free)
          bool  slayer;           // layer dependence?
          char  sstd[64];         // Standard value
          char  slist[256];       // List of other values seperated with spaces
    
          strGetValuesFromParameterLine(parameter[parLine].latin1(),
                                        &slayer,
                                        &sreadwrite,
                                        0,
                                        slabel,
                                        sstd,
                                        slist);
                                        
          // Fill presaved data into layout objects:
          //
          char buf[2];
          buf[0] = parCode;
          buf[1] = '\0';
          cbLayer->setChecked(slayer);
          cbFix->setChecked(!sreadwrite);
          eDescription->setText(slabel);
          eValueList->setText(slist);
          eStandardValue->setText(sstd);
          eCode->setText(buf);
          
          correctInputValues();

          RLOG("\nupdateParameterValues: $");
          RLOG(parCode);
          ret=true;
        }
      }
    }

    updateParameterActive=true;
  }
  return ret;
}



// Get parameter line from presaved which fits for
//   code _code:
//
//   e.g.: "Parameter free $e Extension NC  CNC D" for code 'e'
// 
int
RConfigMach::getParameterLineIndex(char _code)
{
  return parameterString.find(_code);
}



// User changed current Parameter in 
//   ComboBox (Page "Parameter"):
//
void 
RConfigMach::parameterChanged(int)
{
  static char lastParameter=-1;

  if(cbLayer && cbFix && eCode) {

    QString parStr;   // e.g.: "$e (Extension)"
    char parCode;     // e.g.: 'e'
    int where;        // index where to find the parameter code
    
    parStr=mbParameter->currentText();
    where=parStr.find('$');
    if(where>=0) {
      parCode=parStr.at(where+1).latin1();

      if(isalpha(parCode)) {
    
        // Save settings of parameter which WAS active:
        //
        if(lastParameter!=-1) {
          presaveParameter(lastParameter);
        }
    
        // Fill layout elements with values of new active parameter:
        //
        updateParameterValues();
    
        lastParameter=parCode;
      }
    }
  }
}



// Presave parameter:
//   take values from layout objects and code from arg
//
void 
RConfigMach::presaveParameter(char _code) 
{
  if(eCode && eDescription && cbLayer && cbFix &&
     eStandardValue && eValueList &&
     eCode->text()[0]==mbParameter->currentText()[1] ) {
    int i;
    i=getParameterLineIndex(_code);
    if(i>=0 && 
       i<(int)parameterString.length()) {
      bool lay = cbLayer->isChecked();
      bool fix = cbFix->isChecked();
      char descr[256];

      // EVERY Value must contain at least one char:
      //
      correctInputValues();
      
      //sscanf(eDescription->text(), "%255s", descr);
      qstrncpy(descr, eDescription->text(), 255);
      strReplaceChar(descr, ' ', '_');
      parameter[i].sprintf("%s %s $%c %s %s %s",
                           lay ? "LayerParameter" : "Parameter",
                           fix ? "fixed" : "free",
                           _code,
                           descr,
                           eStandardValue->text().latin1(),
                           eValueList->text().latin1());
      parameterString.at(i) = _code;

      RLOG("\npresaveParameter: $");
      RLOG(_code);

      RLOG("\nparameter[");
      RLOG(i);
      RLOG("] = ");
      RLOG(parameter[i]);

      RLOG("\nparameterString: ");
      RLOG(parameterString);
    }
  }
}



// Code for parameter has changed:
//
void 
RConfigMach::parameterCodeChanged(const QString& _text)
{
  if(updateParameterActive &&
     mbParameter && 
     (int)strlen(mbParameter->currentText())>1 &&
     !_text.isEmpty()) {

    updateParameterActive=false;

    // Index of old parameter code
    //
    //int ind=parameterString.find(mbParameter->currentText()[1]);
    int ind=0;
    ind = parameterString.find(mbParameter->currentText().at(1));

    // Control if new parameter code already exists:
    //
    int ctr=0;
    ctr = parameterString.find(_text.at(0).latin1());

    // Set new parameter code in presave memory:
    //
    if(ind>=0 && 
       ind<(int)parameterString.length() &&
       ctr==-1) {
       
      parameterString.at(ind) = _text.at(0);
    
      int  curItem;        // Save current item and set it back after refil
      char newEntry[256];  // New entry in ComboBox list
    
      curItem = mbParameter->currentItem();

      correctInputValues();
      
      sprintf(newEntry, "$%c (%s)", _text.at(0).latin1(), eDescription->text().latin1());
  
      RLOG("\nnewEntry: ");
      RLOG(newEntry);
  
      mbParameter->changeItem(newEntry, curItem);

      mbParameter->setCurrentItem(curItem);
      mbParameter->repaint();
    }

    updateParameterActive=true;

    // Update lists in Options-Comboboxes:
    //
    parameterHasChanged=true;
  }
  
}



// Description for parameter has changed:
//
void 
RConfigMach::parameterDescriptionChanged(const QString& _text)
{
  if(updateParameterActive &&
     mbParameter && 
     eCode && (int)strlen(eCode->text())>0 && 
     !_text.isEmpty()) {

    updateParameterActive=false;
    
    int  curItem;        // Save current item and set it back after refil
    char newEntry[256];  // New entry in ComboBox list
  
    if((int)strlen(eCode->text())==1) {
      curItem=mbParameter->currentItem();
    
      sprintf(newEntry, "$%c (%s)", eCode->text().at(0).latin1(), _text.latin1());

      RLOG("\nnewEntry: ");
      RLOG(newEntry);

      mbParameter->changeItem(newEntry, curItem);

      mbParameter->setCurrentItem(curItem);
      mbParameter->repaint();

      updateParameterActive=true;

      // Update lists in Options-Comboboxes:
      //
      parameterHasChanged=true;
    }
  }
}



// add a new parameter:
//
void
RConfigMach::addParameter()
{
  RLOG("\naddParameter...");
  
  bool repeat;        // Repeat?
  bool esc=false;     // Cancled?
  RInputDialog inpLetter(RMES(165),
                         1, 0, this, "inpLetter"); 
  
  do {
    repeat=false;
    if(inpLetter.exec()) {
      if(parameterString.find(inpLetter.getInput()[0])!=-1) {
      
        // Parameter does already exist / repeat!
        //
        RYesNoDialog mes(RMES(166),
                         RMES(46), RMES(47),
                         this, "rmes");
        if(mes.exec()) {
          repeat=true;
        }
        else {
          esc=true;
        }
      }
    }
    else {
      esc=true;
    }
  }while(repeat);

  if(!esc) {
    // Add parameter:
    //
    if(parameterString.length()<DEF_MAXPARAMETERS &&
       isalpha(inpLetter.getInput()[0])) {

      if(strlen(mbParameter->currentText())>1) 
        presaveParameter(mbParameter->currentText().at(1).latin1()); // []
      
      parameterString+=inpLetter.getInput()[0];
      char newEntry[256];  // New entry in ComboBox list
      sprintf(newEntry, "$%c (%s)", inpLetter.getInput()[0], NO_DESCRIPTION); // []
      mbParameter->insertItem(newEntry);
      int ind=parameterString.length()-1;
      parameter[ind] = "Parameter free ";
      parameter[ind]+= "$";
      parameter[ind]+=inpLetter.getInput()[0];
      parameter[ind]+= " ";
      parameter[ind]+= NO_DESCRIPTION;
      parameter[ind]+= " 0 0";
      mbParameter->setEditText(newEntry);
      //parameterChanged(0);
      updateParameterValues();
      presaveParameter(mbParameter->currentText().at(1).latin1());
      parameterHasChanged=true;
      
      // Enable Layout objects for parameter data:
      //
      tabSelected(QString("&Parameter"));
    }
  }
}



// del a new parameter:
//
void
RConfigMach::delParameter()
{
  RLOG("\ndelParameter...");
  
  char parCode;     // e.g.: 'e'
  int where;        // index where to find the parameter code
  QString parStr;   // Parameter-Text
    
  parStr=mbParameter->currentText();
  where=parStr.find('$');
  if(where>=0) {
    parCode=parStr.at(where+1).latin1();

    QString mes;
    mes.sprintf("%s '%c'?",
                RMES(167),
                parCode);
  
    RYesNoDialog ynd(mes.latin1(),
                     RMES(168), RMES(47),
                     this, "ynd");
    if(ynd.exec()) {
      // Index of parameter code
      //
      int ind=parameterString.find(parCode);
      int i;
      if(ind>=0 && ind<DEF_MAXPARAMETERS) {
        
        for(i=ind; i<(int)parameterString.length()-1; ++i) {
          if(i+1<DEF_MAXPARAMETERS) {
            parameter[i] = parameter[i+1].latin1();
          }
        }
        parameterString.remove(ind, 1);
        if(mbParameter->currentItem()>=0) {
          mbParameter->removeItem(mbParameter->currentItem());
        }
        mbParameter->setCurrentItem(0);

        if(parameterString.length()==0) {
          tabSelected(QString("&Parameter"));
        }
        
        parameterChanged(0);
        parameterHasChanged=true;
      }
    }
  }
}



// Correct values inputed by user:
//
void  
RConfigMach::correctInputValues()
{
  // No Parameter code typed:
  //
  if(eCode) {
    if((int)strlen(eCode->text())==0 && 
       mbParameter && 
       (int)strlen(mbParameter->currentText())>1) {
      char buf[2];
      buf[0] = mbParameter->currentText().at(1).latin1();
      buf[1] = '\0';
      eCode->setText(buf);
    }
  }

  // No description typed:
  //
  if(eDescription) {
    if((int)strlen(eDescription->text())==0) {
      eDescription->setText(NO_DESCRIPTION);
    }
    else {
      QString buf = eDescription->text();
      if(buf.find('_')!=-1) {
        char cbuf[1024];
        strncpy(cbuf, buf.latin1(), 1023);
        strReplaceChar(cbuf, '_', ' ');
        eDescription->setText(cbuf);
      }
    }
  }

  // No value list typed:
  //
  if(eValueList) {
    if((int)strlen(eValueList->text())==0) {
      eValueList->setText("0");
    }
  }

  // No standard value typed:
  //
  if(eStandardValue) {
    if((int)strlen(eStandardValue->text())==0) {
      eStandardValue->setText("0");
    }
  }
}



// 
// Third Page: Orders:
//



// Update Orders from Generator:
//
bool  
RConfigMach::updateOrdersFromGenerator()
{
  QString machineGeneratorPath = fileSearchFile("machines", machFile);
  QFile maFile(machineGeneratorPath);

  // Reset layout to standard values:
  //
  mbOrder->fillInOrders(machFile.latin1());

  // Read entries from mach-File:
  //
  if(maFile.open(IO_ReadOnly)) {
    QTextStream maStream(&maFile);
    QString maLine;        // a line
    QString maSection;     // a section (e.g.: "[Standards]")
    QString* tmpStr;       // Temp buffer for order names / contents

    order.clear();

    while(!maStream.eof()) {
      maLine=maStream.readLine();
      maLine=maLine.stripWhiteSpace();

      // New section:
      //
      if(maLine.at(0)=='[') {
        maSection=maLine.latin1();
      }
      else {
        if(maSection=="[Code]") {
          // User Defined Codes:
          //
          // Exclude comments and empty lines:
          //
          if(!maLine.isEmpty() &&
             strncmp(maLine.latin1(), "//", 2)) {
           
            while(!maLine.contains('}') &&
                  !maStream.eof()) {
              maLine+="\n";
              maLine+=maStream.readLine().latin1();
            }
	    
	    /* ### UNSURE ### */

            // Order Name / Contents:
            //
            tmpStr = new QString(maLine.copy());

            RLOG("\ntmpStr: ");
            RLOG(tmpStr->data());

            order.append(tmpStr);
          }
        }
      }
    }
    maFile.close();

    //qstrncpy(lastOrderName, mbOrder->currentText(), 127);
    return true;
  }
  else {
    return false;
  }
}



// User has selected an other order (SLOT):
//
void
RConfigMach::orderChanged(const QString& _name)
{
  if(strlen(lastOrderName)>0) presaveOrder(lastOrderName);
  updateOrderFromString(_name);

  qstrncpy(lastOrderName, _name.latin1(), 127);

  // Activate / Deactivate Delete Button:
  //
  if(!strcmp(_name, "OrderPoint") ||
     !strcmp(_name, "OrderLine") ||
     !strcmp(_name, "OrderLineOffsetLeft") ||
     !strcmp(_name, "OrderLineOffsetRight") ||
     !strcmp(_name, "OrderLineOffsetOff") ||
     !strcmp(_name, "OrderArcCW") ||
     !strcmp(_name, "OrderArcCCW") ||
     !strcmp(_name, "OrderContourStart") ||
     !strcmp(_name, "OrderContourEnd") ||
     !strcmp(_name, "OrderLayerStart") ||
     !strcmp(_name, "OrderLayerEnd") ||
     !strcmp(_name, "ProgramStart") ||
     !strcmp(_name, "ProgramEnd")    ) {
     
    bDelOrder->setEnabled(false);
  }
  else {
    bDelOrder->setEnabled(true);
  }
}



// Check if we have to update the layout / do it if so:
//   (happens, if the user selects an <if> or <mod> item)
//
void 
RConfigMach::checkOrders(const QString& _name)
{
  if(!_name.isEmpty()) {
    
    // Parameter selected / remove description:
    //
    if(!strncmp(_name.latin1(), "$", 1)) {
      presaveOrder();
    }
    
    // If / mod selected / create new if / mod:
    //
    else if(!strcmp(_name.latin1(), "<if:>") ||
            !strcmp(_name.latin1(), "<mod:>")) {
      presaveOrder();
      QTimer::singleShot(100, this, SLOT(updateOrderLayout()));
    }
  }
}



// Update Orders (Layout) from presaved Strings:
//
bool
RConfigMach::updateOrderFromString(const QString& _name) 
{
  //if(!autoUpdateOrders) return false;
  //else                  autoUpdateOrders=false;
  
  RLOG("\nupdateOrderFromString...");

  if(_name && strlen(_name.latin1())>0 &&
     !order.isEmpty() && wdOrder && scOrder) {
    QString* ord;              // Walk through orders
    const char* selectedOrder=0;  // Copy of selected Order ### UNSURE ###
    const char* itemPtr;          // Walk through order
    char     item[32700];      // Contents of a single item
    QString  itemStr;          // Item as string

    // Find selected Order:
    //
    for(ord=order.first(); ord!=0; ord=order.next()) {
      if(!strncmp(_name.latin1(), ord->data(), strlen(_name.latin1()))) {
        RLOG("\nSelected: ");
        RLOG(ord->data());

        selectedOrder = ord->data();
        break;
      }
    }

    if(selectedOrder) {

      // Walk through Items (<...>) and create Layout:
      //
      //itemPtr = selectedOrder->data();
      itemPtr = selectedOrder;

      // Step forward to '{':
      //
      while(itemPtr[0]!='{' && itemPtr[0]!='\0') ++itemPtr;
      if(itemPtr[0]=='{') ++itemPtr;
  
      QToolButton* bTmp;       // temp button for creation
      RComboBox* mbTmp;        // temp combobox for creation
      QFrame* fTmp;            // temp frame for creation
      RLabel* lTmp;            // temp label for creation
      int x=0;                 // Current X-Value (indenting)
      int y=0;                 // Current Y-Value
      int itemWidth;           // Width of an item
      int border=10;           // Border
      bool hasComboBox;        // Current Item uses Combo-Box?
      bool hasDeleteButton;    // Current Item has a delete button?
      RComboBox* mbFirstItem=0; // First item / We copy the list from this

      // Delete old layout elements:
      //
      if(!bDeleteItem.isEmpty()) bDeleteItem.clear();
      if(!bInsertItem.isEmpty()) bInsertItem.clear();
      if(!mbItem.isEmpty())      mbItem.clear();
      if(!lItem.isEmpty())       lItem.clear();
      if(!fItemSep.isEmpty())    fItemSep.clear();
      
      wdOrder->setFixedWidth(scOrder->width()*2);
      wdOrder->move(-scOrder->width(), wdOrder->y());

      itemWidth = scOrder->width()-2*DEF_BUTINSERTORDER_WIDTH-4*border;

      if(scOrder->verticalScrollBar()) 
        itemWidth-=scOrder->verticalScrollBar()->width();

      // First Button for Inserting an item:
      //
      RLOG("\nFirst Insert-Button");
      
      bTmp = new QToolButton(wdOrder, "bInsertItem");
      bTmp->setPixmap(*pixInsertItem);
      QToolTip::add(bTmp, RMES(170));
      bTmp->setGeometry(border, y,
                        DEF_BUTINSERTORDER_WIDTH,
                        18);
      bTmp->setToggleButton(true);
      bTmp->show();
      connect(bTmp, SIGNAL(toggled(bool)),
              this, SLOT(insertItem(bool)));
      bInsertItem.append(bTmp);
      y+=9;

      do {
        hasComboBox=true;
        hasDeleteButton=true;
        strcpy(item, "");
        
        // Special Item (<...>):
        //
        if(itemPtr[0]=='<') {
          sscanf(itemPtr, "%32698[^>}]", item);
          strcat(item, ">");
          while(itemPtr[0]!='>' && itemPtr[0]!='\0') ++itemPtr;
          if(itemPtr[0]=='>') ++itemPtr;
        }

        // Special Item ($x):
        //
        else if(itemPtr[0]=='$') {
          ++itemPtr;
          item[0]='$';
          item[1]=itemPtr[0];
          item[2]='\0';
          
          if(itemPtr[0]!='\0') ++itemPtr;
        }

        // Text-Item:
        //
        else {
          sscanf(itemPtr, "%32698[^<}$]", item);
          while(itemPtr[0]!='<' && 
                itemPtr[0]!='}' && 
                itemPtr[0]!='$' &&
                itemPtr[0]!='\0') ++itemPtr;
        }

        RLOG("\nItem: ");
        RLOG(item);

        if(item[0]!='}') {

          // Add Layout-Elements for this Item:
          //
          
          // Indent:
          //
          if(!strncmp(item, "<if:", 4) || 
             !strncmp(item, "<mod:", 5)) {
             
            y+=12;

            // Seperator:
            //
            fTmp = new QFrame(wdOrder, "fOrderSeperator");
            fTmp->setFrameStyle(QFrame::HLine|QFrame::Sunken);
            fTmp->setGeometry(border+x, y,
                              scOrder->width()-2*border-x, 10);
            fTmp->show();
            fItemSep.append(fTmp);

            y+=15;
          }
          
          // Indent <if:...>:
          //
          if(!strncmp(item, "<if:", 4)) {
            char* iPtr;            // Item-Pointer (walks through item)
            char  scode[128];      // Code of parameter
            char  ssign[3];        // Sign (= / !=)
            char  svalue[128];     // Value
            bool  dollarParameter=false; // Parameter is a dollar param. ($e not poschanged)

            scode[0]='\0';
            ssign[0]='\0';
            svalue[0]='\0';
            
            iPtr=item;
            iPtr+=4;

            RLOG("\nIf: ");

            // Get if-Parameter code:
            //
            if(iPtr[0]!='\0') {
              if(iPtr[0]=='$') {
                sscanf(iPtr, "%2s", scode);   // e.g.: '$e'

                RLOG("\nIf-code: ");
                RLOG(scode);

                // Get if-Parameter sign:
                //
                if(strlen(iPtr)>2) {
                  while(iPtr[0]!='\0' && 
                        iPtr[0]!='='  &&
                        iPtr[0]!='!'     ) ++iPtr;
                  sscanf(iPtr, "%2[!=]", ssign);

                  RLOG("\nSign: ");
                  RLOG(ssign);
                }

                // Get if-Parameter value:
                //
                while(iPtr[0]!='\0' && 
                      (iPtr[0]=='=' ||
                       iPtr[0]=='!'    ) ) ++iPtr;

                sscanf(iPtr, "%127[^>]", svalue);

                RLOG("\nValue: ");
                RLOG(svalue);

                dollarParameter=true;
              }
              else {
                sscanf(iPtr, "%127[^>]", scode); // e.g.: 'poschanged1'

                RLOG("\nIf-code (no para): ");
                RLOG(scode);
                dollarParameter=false;
              }
            }

            hasComboBox=false;
            lTmp = new RLabel("If", wdOrder, "ltmp");
            lTmp->setGeometry(border+x, 
                              y,
                              15, 20);
            lTmp->setAlignment(AlignCenter);
            lTmp->setFont(*boldFont);
            lTmp->show();
            lItem.append(lTmp);

            // ComboBox '$e':
            //
            mbTmp = new RComboBox(wdOrder, "mbifparameter");
            mbTmp->setGeometry(2*border+15+x,
                               y,
                               120, 22);
            mbTmp->fillInItemsFrom(mbParameter);
            mbTmp->fillInIfItems(false);
            mbTmp->show();
            mbTmp->setParameter(scode);
            sscanf(mbTmp->currentText(), "%127s", scode);

            RLOG("\nComboBox: scode: ");
            RLOG(scode);
            
            connect(mbTmp, SIGNAL(activated(const QString&)),
                    this,  SLOT(ifParameterChanged(const QString&)));
            mbItem.append(mbTmp);

            // ComboBox '=':
            //
            mbTmp = new RComboBox(wdOrder, "mbifequal");
            mbTmp->setGeometry(2*border+135+x,
                               y,
                               40, 22);
            mbTmp->insertItem("=");
            mbTmp->insertItem("!=");
            mbTmp->show();
            if(strlen(ssign)>0) mbTmp->setEditText(ssign);
            if(!dollarParameter) mbTmp->setEnabled(false);

            RLOG("\nComboBox: ssign: ");
            RLOG(ssign);
            
            mbItem.append(mbTmp);

            // ComboBox 'on':
            //
            mbTmp = new RComboBox(true, wdOrder, "mbifvalue");
            mbTmp->setGeometry(2*border+175+x,
                               y,
                               70, 22);
            mbTmp->show();

            RLOG("\nComboBox: svalue: ");
            RLOG(svalue);
            
            // If-Value-List:
            //
            fillComboBoxWithParameterValues(mbTmp, scode[1]);
            if(strlen(svalue)>0) mbTmp->setEditText(svalue);
            if(!dollarParameter) mbTmp->setEnabled(false);
            mbItem.append(mbTmp);
          }

          // Indent <mod:..>:
          //
          if(!strncmp(item, "<mod:", 5)) {
            char* iPtr;      // Item-Pointer (walks through item)
            char  group[16]; // Modal Group

            iPtr=item;
            iPtr+=5;

            // Get modal-group:
            //
            if(iPtr[0]!='\0') {
              sscanf(iPtr, "%[0-9]", group);   // e.g.: '1'
          
              lTmp = new RLabel("Modal", wdOrder, "ltmp");
              lTmp->setGeometry(2*border+x, 
                                y,
                                50, 20);
              lTmp->setAlignment(AlignCenter);
              lTmp->setFont(*boldFont);
              lTmp->show();
              lItem.append(lTmp);

              // ComboBox '1' (Group):
              //
              mbTmp = new RComboBox(wdOrder, "mbmodgroup");
              mbTmp->setGeometry(2*border+65+x,
                                 y,
                                 40, 22);
              mbTmp->fillInItemsFromString("0 1 2 3 4 5 6 7 8 9", true);
              mbTmp->setEditText(group);
              mbTmp->setSizeLimit(5);
              mbTmp->show();
              connect(mbTmp, SIGNAL(activated(const QString&)),
                      this,  SLOT(modParameterChanged(const QString&)));
              mbItem.append(mbTmp);
            }

            hasComboBox=false;
          }
  
          // Unindent </if>:
          //
          if(!strncmp(item, "</if>", 5)) {
            mbTmp = new RComboBox(wdOrder, "mbifend");
            mbTmp->hide();
            mbItem.append(mbTmp);
            hasComboBox=false;
            hasDeleteButton=false;
          }

          // Unindent </mod:..>:
          //
          if(!strncmp(item, "</mod:", 6)) {
            char* iPtr;      // Item-Pointer (walks through item)
            char  group[16]; // Modal Group

            iPtr=item;
            iPtr+=6;

            // Get modal-group:
            //
            if(iPtr[0]!='\0') {
              sscanf(iPtr, "%[0-9]", group);   // e.g.: '1'
              mbTmp = new RComboBox(wdOrder, "mbmodend");
              mbTmp->insertItem(group);
              mbTmp->setEditText(group);
              mbTmp->hide();
              mbItem.append(mbTmp);
              hasComboBox=false;
              hasDeleteButton=false;
            }
          }

          // Delete-Button:
          //
          if(hasDeleteButton) {
            RLOG("\ndelete-Button");
              
            bTmp = new QToolButton(wdOrder, "bDeleteItem");
            bTmp->setPixmap(*pixDeleteItem);
            QToolTip::add(bTmp, RMES(171));
            bTmp->setGeometry(DEF_BUTINSERTORDER_WIDTH+itemWidth+3*border, 
                              y+2, 
                              DEF_BUTINSERTORDER_WIDTH,
                              18);
            bTmp->setToggleButton(true);
            bTmp->show();
            connect(bTmp, SIGNAL(toggled(bool)),
                    this, SLOT(deleteItem(bool)));
            bDeleteItem.append(bTmp);
          }

          if(!strncmp(item, "<if:", 4) ||
             !strncmp(item, "<mod:", 5)   ) {
            x+=20;
            y+=12;
          }

          if(hasComboBox) {

            // ComboBox:
            //

            RLOG("\nComboBox");
            
            mbTmp = new RComboBox(true, wdOrder, "mbOrderItem");
            if(!mbFirstItem) {
              char exception[1024];
              strcpy(exception, "<");
              strncat(exception, _name, 1000);
              strcat(exception, ">");
              
              mbTmp->fillInOrderItems(order, exception, true);
              mbTmp->fillInItemsFrom(mbParameter, false);
              mbFirstItem=mbTmp;
            }
            else {
              mbTmp->fillInItemsFrom(mbFirstItem);
            }
            mbTmp->setGeometry(DEF_BUTINSERTORDER_WIDTH+2*border+x, 
                               y, 
                               itemWidth-x,
                               22);
            mbTmp->show();
            itemStr=item;
            itemStr.simplifyWhiteSpace();
            mbTmp->setEditText(itemStr.latin1());
            connect(mbTmp, SIGNAL(activated(const QString&)),
                    this, SLOT(checkOrders(const QString&)));
            mbItem.append(mbTmp);
          }
          
          // Unindent:
          //
          if(!strncmp(item, "</if>", 5) ||
             !strncmp(item, "</mod:", 6)   ) {
            y+=12;
            x-=20;
            fTmp = new QFrame(wdOrder, "fOrderSeperator");
            fTmp->setFrameStyle(QFrame::HLine|QFrame::Sunken);
            fTmp->setGeometry(border+x, y,
                              scOrder->width()-2*border, 10);
            fTmp->show();
            fItemSep.append(fTmp);
          }
  
          // Unindent </if:...>:
          //
          /*if(!strncmp(item, "</if>", 5)) {
            hasComboBox=false;
          }*/

          // Unindent </mod:..>:
          //
          /*if(!strncmp(item, "</mod:", 6)) {
            hasComboBox=false;
          }*/

          // Insert-Button:
          //
          y+=14;

          RLOG("\nInsert-Button");
          
          bTmp = new QToolButton(wdOrder, "bInsertItem");
          bTmp->setPixmap(*pixInsertItem);
          QToolTip::add(bTmp, RMES(172));
          bTmp->setGeometry(border+x, 
                            y,
                            DEF_BUTINSERTORDER_WIDTH,
                            18);
          bTmp->setToggleButton(true);
          bTmp->show();
          connect(bTmp, SIGNAL(toggled(bool)),
                  this, SLOT(insertItem(bool)));
          bInsertItem.append(bTmp);
          
          y+=9;
        }
      }while(itemPtr[0]!='\0' && itemPtr[0]!='}');

      RLOG("\nAdjust ScrollView");

      // Adjust Scroll-View-Height:
      //
      y+=2*border;
      if(y>scOrder->height()) {
        wdOrder->setFixedHeight(y);
      }
      else {
        wdOrder->setFixedHeight(scOrder->height());
      }
      wdOrder->setFixedWidth(x+scOrder->width());
      wdOrder->move(0, wdOrder->y());
      //wdOrder->show();

      RLOG("\nReturn");
      
      autoUpdateOrders=true;
      saveOldItems();
      return true;
    }
  }
  autoUpdateOrders=true;
  return false;
}



// If Parameter ('$e') has changed -> adjust if values:
//
void 
RConfigMach::ifParameterChanged(const QString& _code)
{
  RLOG("\nifParameterChanged...");
  
  // Update ALL possible values for ALL if constructs:
  //
  RComboBox* cb;
  QString*   sOld=0;

  // Step through comboboxes:
  //
  for(cb=mbItem.first(); cb!=0; cb=mbItem.next()) {
    if(!sOldItem.isEmpty() && sOldItem.count()==mbItem.count()) {
      sOld = sOldItem.at(mbItem.at()); 
    }

    if(!sOld || strcmp(cb->currentText(), sOld->data())) {
      int where = mbItem.at();
      const char* codeStr=cb->currentText();
      if(codeStr && strlen(codeStr)>1 &&
         !strcmp(_code.latin1(), codeStr) &&
         !strcmp(cb->name(), "mbifparameter")) {
          
        // An if-construct 'poschanged':
        //
        if(codeStr[0]!='$') {
          QString cont;
          cont = "<if:";
          cont+= cb->currentText();
          cont+= ">";
          
          deleteItemAt(where, false, false);
          insertItemAt(where, cont.latin1(), false);
          
          cb=mbItem.next();
  
          // Clear / Disable sign-box:
          //
          if(cb) {
            cb->setEnabled(false);
            cb->setEditText("=");
          }
  
          cb=mbItem.next();
  
          // Clear / Disable value-box:
          //
          if(cb) {
            cb->setEnabled(false);
            cb->setEditText("");
          }
          
        }
  
        // An if-construct '$e=Yes':
        //
        else {
          char scode=codeStr[1]; // Code Letter of if-parameter
          QString cont;
          
          cont = "<if:";
          cont+= cb->currentText()[0];
          cont+= cb->currentText()[1];
          
          cb=mbItem.next();
           
          // if-Sign:
          //
          if(cb) {
            cb->setEnabled(true);
            cont+= cb->currentText();
            cb=mbItem.next();
          }
          
          // Fill the value list into if-values combobox:
          //
          if(cb) {
            // If-Value-List:
            //
            fillComboBoxWithParameterValues(cb, scode);
            cont+= cb->currentText();
          }
          
          cont+= ">";

          deleteItemAt(where, false, false);
          insertItemAt(where, cont.latin1(), false);
        }
      }
    }
  }

  // Save old items:
  //
  saveOldItems();
  /*QString* sTmp;
  if(!sOldItem.isEmpty()) sOldItem.clear();
  
  if(!mbItem.isEmpty()) {
    for(cb=mbItem.first(); cb!=0; cb=mbItem.next()) {
      sTmp = new QString;
      *sTmp = cb->currentText();
      sOldItem.append(sTmp);
    }
  }*/
  
}



// Mod Parameter (1) has changed -> adjust number of end of mod:
//
void 
RConfigMach::modParameterChanged(const QString& _code)
{
  RLOG("\nmodParameterChanged...: ");
  RLOG(_code);
  
  // Update ALL possible values for ALL if constructs:
  //
  RComboBox* cb;
  QString*   sOld=0;
  int        where=-1;

  // Step through comboboxes:
  //
  for(cb=mbItem.first(); cb!=0; cb=mbItem.next()) {
    if(!sOldItem.isEmpty() && sOldItem.count()==mbItem.count()) {
      sOld = sOldItem.at(mbItem.at()); 
    }

    if(strcmp(cb->name(), "mbifequal") &&
       strcmp(cb->name(), "mbifvalue")    ) ++where;

    if(!sOld || strcmp(cb->currentText(), sOld->data())) {
    
      if(sOld) {
        RLOG("\nChanged: ");
        RLOG(sOld->data());
        RLOG(" to ");
        RLOG(cb->currentText());
      }
    
      RLOG("\nWhere: ");
      RLOG(where);
      
      int ipos;
      const char* codeStr=cb->currentText();
      if(codeStr && strlen(codeStr)>0 &&
         !strcmp(_code.latin1(), codeStr) &&
         !strcmp(cb->name(), "mbmodgroup") &&
         where>=0) {

        // Find selected Order:
        //
        QString* selectedOrder;    // Ptr to selected Order
        char     modCode1[16];     // Code of mod start (mod:1>)
        char     modCode2[16];     // Code of mod end (</mod:1>)
        selectedOrder = getSelectedOrder();
        
        RLOG("\nOld: ");
        RLOG(selectedOrder->data());
      
        if(selectedOrder) {
          
          // Step to mod start:
          //
          ipos = strStepToOrderItem(selectedOrder->data(), where, false);
          if(ipos>=0 && ipos<(int)strlen(selectedOrder->data())) {
            RLOG("\nNow 1 we're at: ");
            RLOG(&selectedOrder->data()[ipos]);
          
            ipos+=5;

            RLOG("\nNow 2 we're at: ");
            RLOG(&selectedOrder->data()[ipos]);

            // Old code:
            //
            if(sscanf(&selectedOrder->data()[ipos], "%15[0-9]", modCode1)==1) {
              sprintf(modCode2, "</mod:%s>", modCode1);
              
              // Replace start mod group by new one:
              //
              //selectedOrder->data()[ipos] = codeStr[0];
	      selectedOrder[ipos] = codeStr[0];
  
              RLOG("\nmodCode1: ");
              RLOG(modCode1);
              RLOG("\nmodCode2: ");
              RLOG(modCode2);
              
              // Step to mod end:
              //
              while(selectedOrder->data()[ipos]!='\0' &&
                    strncmp(&selectedOrder->data()[ipos], modCode2, strlen(modCode2))) {
                ++ipos;
              }

              if(selectedOrder->data()[ipos]!='\0') {
  
                RLOG("\nNow 3 we're at: ");
                RLOG(&selectedOrder->data()[ipos]);
  
                ipos+=6;
    
                RLOG("\nNow 4 we're at: ");
                RLOG(&selectedOrder->data()[ipos]);
    
                // Replace end mod group by new one:
                //
                //selectedOrder->data()[ipos] = codeStr[0];
		selectedOrder[ipos] = codeStr[0];
        
                RLOG("\nNow we're at: ");
                RLOG(&selectedOrder->data()[ipos]);
              }
            }
          }
        }

        RLOG("\nNew: ");
        RLOG(selectedOrder->data());
      }
    }
  }

  // Save old items:
  //
  saveOldItems();
  /*
  QString* sTmp;
  if(!sOldItem.isEmpty()) sOldItem.clear();
  
  if(!mbItem.isEmpty()) {
    for(cb=mbItem.first(); cb!=0; cb=mbItem.next()) {
      sTmp = new QString;
      *sTmp = cb->currentText();
      sOldItem.append(sTmp);
    }
  }
  */
  
}



// Save old items (Comboboxes):
//
void 
RConfigMach::saveOldItems()
{
  // Save old items:
  //
  RComboBox* cb;
  QString* sTmp;
  if(!sOldItem.isEmpty()) sOldItem.clear();
  
  if(!mbItem.isEmpty()) {
    for(cb=mbItem.first(); cb!=0; cb=mbItem.next()) {
      sTmp = new QString;
      *sTmp = cb->currentText();
      sOldItem.append(sTmp);
    }
  }
}



// Update Order Layout: (SLOT)
//   Take order name from combobox
//
void 
RConfigMach::updateOrderLayout()
{
  if(mbOrder && strlen(mbOrder->currentText())>0) {
    updateOrderFromString(mbOrder->currentText());
  }
}




// Get the selected order (name from combobox):
//
QString*
RConfigMach::getSelectedOrder()
{
  // Find selected Order:
  //
  QString* ord=0;            // Ptr (walks through orders)
  QString* selectedOrder=0;  // Ptr to selected Order
  if(mbOrder && strlen(mbOrder->currentText())>0) {
    for(ord=order.first(); ord!=0; ord=order.next()) {
      if(!strncmp(mbOrder->currentText(), ord->data(), strlen(mbOrder->currentText()))) {
        selectedOrder = ord;
        break;
      }
    }
  }

  return selectedOrder;
}




// Get order (name from parameter):
//
QString*
RConfigMach::getOrder(const QString& _name)
{
  // Find Order _name:
  //
  QString* ord;       // Ptr (walks through orders)
  QString* norder=0;   // Ptr to Order
  if(_name && strlen(_name.latin1())>0) {
    for(ord=order.first(); ord!=0; ord=order.next()) {
      if(!strncmp(_name.latin1(), ord->data(), strlen(_name.latin1()))) {
        norder = ord;
        break;
      }
    }
  }
  return norder;

}



// Slot (called when user presses an "Insert"-Button 
//   (Order-Page)
//
void
RConfigMach::insertItem(bool)
{
  RLOG("\nInsert Item");

  presaveOrder();

  if(!bInsertItem.isEmpty() && 
     mbOrder && 
     strlen(mbOrder->currentText())>0) {

    // Find out number of pressed button:
    //
    QToolButton* tb;  // Ptr (walks through buttons)
    int   where=-1;   // Number of pressed button 
    
    for(tb=bInsertItem.first(); tb!=0; tb=bInsertItem.next()) {
      if(tb->isOn()) {
        where=bInsertItem.at();
        break;
      }
    }

    RLOG("\nwhere (number of pressed button): ");
    RLOG(where);

    insertItemAt(where);
  }
}



// Insert an Item at position _pos:
//   _what: New Item <item> or 0 for <>
//
void
RConfigMach::insertItemAt(int _pos, const char* _what, bool _update)
{
  RLOG("\nInsert Item at: ");
  RLOG(_pos);
  RLOG(" : ");
  RLOG(_what);
  
  if(_pos>=0) {
    int   ipos;       // Position where to insert an item in the string as int
  
    // Find selected Order:
    //
    QString* selectedOrder;    // Ptr to selected Order
    selectedOrder = getSelectedOrder();
      
    if(selectedOrder) {
      RLOG("\nOld Order: ");
      RLOG(selectedOrder->data());
      
      // Find out Position in String:
      //
      ipos = strStepToOrderItem(selectedOrder->data(), _pos, false);

      if(ipos<(int)selectedOrder->length() && ipos>0) {
        if(!_what) selectedOrder->insert(ipos, "<>");
        else       selectedOrder->insert(ipos, _what);
      }

      RLOG("\nNew Order: ");
      RLOG(selectedOrder->data());

      if(_update) QTimer::singleShot(100, this, SLOT(updateOrderLayout()));
    }
  }
}
      
    
    
// Slot (called when user presses a "Delete"-Button 
//   (Order-Page)
//
void
RConfigMach::deleteItem(bool)
{
  RLOG("\nDelete Item");

  presaveOrder();

  if(!bDeleteItem.isEmpty() && 
     mbOrder && 
     strlen(mbOrder->currentText())>0) {

    // Find out number of pressed button:
    //
    QToolButton* tb;  // Ptr (walks through buttons)
    int   where=-1;   // Number of pressed button 
    
    for(tb=bDeleteItem.first(); tb!=0; tb=bDeleteItem.next()) {
      if(tb->isOn()) {
        where=bDeleteItem.at();
        break;
      }
    }

    RLOG("\nwhere (number of pressed button): ");
    RLOG(where);

    deleteItemAt(where);
  }
}



// Delete an Item at position _pos
//
//  _pos: index of the item (not char)
//  _delIfEnd: Delete if's end (</if>)     if we have deleted an if?
//             "      mod's    (</mod...>) "                  a mod?
//  _update: Update Layout?
//
void
RConfigMach::deleteItemAt(int _pos, bool _delIfEnd, bool _update)
{
  RLOG("\nDelete Item at: ");
  RLOG(_pos);
  
  if(_pos>=0) {
    int   ipos;       // Position where to insert an item in the string as int
    int   len;        // Length of an item in the string

    // Find selected Order:
    //
    QString* selectedOrder;    // Ptr to selected Order
    selectedOrder = getSelectedOrder();
      
    if(selectedOrder) {
      RLOG("\nOld Order: ");
      RLOG(selectedOrder->data());
      
      // Find out Position in String:
      //
      ipos = strStepToOrderItem(selectedOrder->data(), _pos, true);

      if(ipos<(int)selectedOrder->length() && ipos>0) {
        // Find out length of order item:
        //
        len = strOrderItemLength(&selectedOrder->data()[ipos]);
        if(len>0 && len<=(int)strlen(&selectedOrder->data()[ipos])) {

          // Backup order:
          //
          QString orderBak = &selectedOrder->data()[ipos];
        
          // Remove item:
          //
          selectedOrder->remove(ipos, len);

          // IF-Item : remove its end: (</if>)
          //
          if(_delIfEnd &&
             !strncmp(orderBak.latin1(), "<if:", 4)) {
            int others=0;   // Other if-items in this one found
            for(int i=ipos; i<ipos+(int)strlen(&selectedOrder->data()[ipos]); ++i) {
              if(!strncmp(&selectedOrder->data()[i], "<if:", 4)) {
                ++others;
              }
              else if(!strncmp(&selectedOrder->data()[i], "</if>", 5)) {
                if(others==0) {
                  selectedOrder->remove(i, 5);
                  break;
                }
                else {
                  --others;
                }
              }
            }
          }

          // MOD-Item : remove its end: (</mod>)
          //
          if(_delIfEnd &&
             !strncmp(orderBak.latin1(), "<mod:", 5)) {
            // Find out modal number:
            //
            int modNum=-1;
            sscanf(&orderBak.latin1()[5], "%d", &modNum);
            if(modNum>=0) {
              char endItem[128];
              sprintf(endItem, "</mod:%d>", modNum);
              for(int i=ipos; i<ipos+(int)strlen(&selectedOrder->data()[ipos]); ++i) {
                if(!strncmp(&selectedOrder->data()[i], endItem, strlen(endItem))) {
                  selectedOrder->remove(i, strlen(endItem));
                  break;
                }
              }
            }
          }
        }
      }

      RLOG("\nNew Order: ");
      RLOG(selectedOrder->data());

      if(_update) QTimer::singleShot(100, this, SLOT(updateOrderLayout()));
    }
  }
}



// Fill ComboBox with possible parameter values
//   ($e -> NC, CNC, D)
//
void     
RConfigMach::fillComboBoxWithParameterValues(RComboBox* _mb, char _code)
{
  if(_mb) {
    char sstd[64];         // Standard value
    char slist[256];       // List of other values seperated with spaces
  
    sstd[0]='\0';
    slist[0]='\0';
    int ind=getParameterLineIndex(_code);
    strGetValuesFromParameterLine(parameter[ind],
                                  0, 0, 0, 0, sstd,
                                  slist);
    _mb->setEnabled(true);
    _mb->fillInItemsFromString(slist);
    if(strlen(sstd)>0) {
      _mb->insertItem(sstd);
      _mb->setEditText(sstd);
    }
  }
}
  
  
  
// Presave Order (from Layout) to String:
//
//  _name: 0 : take name from combobox
//         name of order
//
void
RConfigMach::presaveOrder(const QString& _name)
{
  RLOG("\npresaveOrder...: ");
  if(!_name.isEmpty()) RLOG(_name.latin1());

  QString* selectedOrder;  // Ptr to selected Order
  RComboBox* mb;           // Combobox Ptr (walks through mbItem)
  if(_name==0) selectedOrder = getSelectedOrder();
  else         selectedOrder = getOrder(_name);

  if(selectedOrder && strlen(selectedOrder->data())>0) {

    RLOG("\nOld Order: ");
    RLOG(selectedOrder->data());
    
    if(selectedOrder->find('{')>=0) {
      selectedOrder->truncate(selectedOrder->find('{'));
    }
  
    *selectedOrder += "{";
  
    for(mb=mbItem.first(); mb!=0; mb=mbItem.next()) {
  
      // If:
      //
      if(!strcmp(mb->name(), "mbifparameter")) {
      
        *selectedOrder += "<if:";
        
        // No valid contents:
        //
        if(strlen(mb->currentText())==0) {
          *selectedOrder += "poschanged1";
        }
        else if(mb->currentText()[0]=='$' &&
           strlen(mb->currentText())>1) {
          *selectedOrder += '$';
          *selectedOrder += mb->currentText()[1];
  
          mb=mbItem.next();
  
          if(mb && !strcmp(mb->name(), "mbifequal")) {
            *selectedOrder += mb->currentText();
  
            mb=mbItem.next();
  
            if(mb && !strcmp(mb->name(), "mbifvalue")) {
              *selectedOrder += mb->currentText();
            }
          }
        }
        else {
          *selectedOrder += mb->currentText();
          mb=mbItem.next();
          if(mb) /*mb=*/mbItem.next();
        }
  
        *selectedOrder += ">";
      }
  
      // Mod:
      //
      else if(!strcmp(mb->name(), "mbmodgroup")) {
        *selectedOrder += "<mod:";
        *selectedOrder += mb->currentText();
        *selectedOrder += ">";
      }
      
      // If end:
      //
      else if(!strcmp(mb->name(), "mbifend")) {
        *selectedOrder += "</if>";
      }
  
      // Mod end:
      //
      else if(!strcmp(mb->name(), "mbmodend")) {
        *selectedOrder += "</mod:";
        *selectedOrder += mb->currentText();
        *selectedOrder += ">";
      }
  
      // Normal Item:
      //
      else {
  
        // A new inserted if (<if:>):
        //   replace with a complete if
        //
        if(!strcmp(mb->currentText(), "<if:>")) {
          *selectedOrder += "<if:poschanged1></if>";
        }
  
        // A new inserted mod (<mod:>):
        //   replace with a complete mod
        //
        else if(!strcmp(mb->currentText(), "<mod:>")) {
          *selectedOrder += "<mod:0></mod:0>";
        }
  
        // A Parameter (cut away description):
        //
        else if(!strncmp(mb->currentText(), "$", 1)) {
          char newText[3];
          sprintf(newText, "$%c", mb->currentText().at(1).latin1());
          mb->setEditText(newText);
          *selectedOrder += newText;
        }
  
        // A normal text string:
        //
        else if(strlen(mb->currentText())>0) {
          *selectedOrder += mb->currentText();
        }
      }
    }
  
    *selectedOrder += "}";
  
    RLOG("\nNew Order: ");
    RLOG(selectedOrder->data());
  }
}



// Add an order:
//
void
RConfigMach::addOrder()
{
  bool repeat;        // Repeat?
  bool esc=false;     // Cancled?
  RInputDialog inpName(RMES(173),
                       255, 0, this, "inpName"); 
  QString name;       // user given name
  
  do {
    repeat=false;

    // Ask for name:
    //
    if(inpName.exec()) {

      // Test if name already exists:
      //
      name="";
      name+=inpName.getInput();

      if(mbOrder->findItem(name.latin1())!=-1) {
      
        // Order does already exist / repeat!
        //
        RYesNoDialog mes(RMES(174),
                         RMES(46), RMES(47),
                         this, "rmes");
        if(mes.exec()) {
          repeat=true;
        }
        else {
          esc=true;
        }
      }
    }
    else {
      esc=true;
    }
  }while(repeat);

  if(!esc) {
    // Add order:
    //
    QString* sTmp = new QString(name.latin1());

    RLOG("\nAdd Order: ");
    RLOG(name.latin1());

    mbOrder->insertItem(sTmp->data());
    mbOrder->setEditText(sTmp->data());
    
    *sTmp+="\n  {}";
    order.append(sTmp);
    orderChanged(sTmp->data());
  }
}



// Delete an order:
//
void
RConfigMach::delOrder()
{
  QString* selectedOrder;  // Ptr to selected Order
  selectedOrder = getSelectedOrder();

  if(selectedOrder) {

    // Are you sure that you want to\ndelete order ...:
    //
    QString mes;
    mes = RMES(175);
    mes+= " ";
    mes+= mbOrder->currentText();
    mes+= " ?";
    RYesNoDialog ynd(mes.latin1(),
                     RMES(46), RMES(47),
                     this, "rmes");
    if(ynd.exec()) {
      RLOG("\nDel Order: ");
      RLOG(mbOrder->currentText());
      
      mbOrder->removeItem(mbOrder->currentText());
      order.removeRef(selectedOrder);
      lastOrderName[0] = '\0';
      mbOrder->setCurrentItem(0);
      orderChanged(mbOrder->currentText());
    }
  }
}



// 
// General:
//

  
// A Tab was selected:
//
void 
RConfigMach::tabSelected(const QString& _tabLabel)
{
  correctInputValues();

  // Select Options-Tab:
  //
  if(!strcmp(_tabLabel.latin1(), RMES(162))) {
    if(parameterHasChanged) fillOptionLists();
  }

  // Select Parameter-Tab:
  //
  if(!strcmp(_tabLabel.latin1(), RMES(163))) {
    if(mbParameter) {
      if((int)strlen(mbParameter->currentText())==0) {
        // Disable layout-objects for parameter data:
        //
        mbParameter->setEnabled(false);
        lParameter->setEnabled(false);
        eCode->setText("");
        eCode->setEnabled(false);
        lCode->setEnabled(false);
        cbFix->setChecked(false);
        cbFix->setEnabled(false);
        cbLayer->setChecked(false);
        cbLayer->setEnabled(false);
        eDescription->setText("");
        eDescription->setEnabled(false);
        lDescription->setEnabled(false);
        eValueList->setText("");
        eValueList->setEnabled(false);
        lValueList->setEnabled(false);
        eStandardValue->setText("");
        eStandardValue->setEnabled(false);
        lStandardValue->setEnabled(false);
      }
      else {
        // Enable layout-objects for parameter data:
        //
        mbParameter->setEnabled(true);
        lParameter->setEnabled(true);
        eCode->setEnabled(true);
        lCode->setEnabled(true);
        cbFix->setEnabled(true);
        cbLayer->setEnabled(true);
        eDescription->setEnabled(true);
        lDescription->setEnabled(true);
        eValueList->setEnabled(true);
        lValueList->setEnabled(true);
        eStandardValue->setEnabled(true);
        lStandardValue->setEnabled(true);
      }
    }
  }

  // Select Order-Tab:
  //
  if(!strcmp(_tabLabel.latin1(), RMES(164))) {
    if(mbOrder) {
      if((int)strlen(mbOrder->currentText())>0) {
        orderChanged(mbOrder->currentText());
        //updateOrderFromString(mbOrder->currentText());
      }
    }
  }
}



// Save all options / parameters / orders to file:
//
void
RConfigMach::saveMachine()
{
  RLOG("\nsaveMachine");
  
  //parameterChanged(0);

  QString parStr;   // e.g.: "$e (Extension)"
  char parCode;     // e.g.: 'e'
  int where;        // index where to find the parameter code
    
  parStr=mbParameter->currentText();
  where=parStr.find('$');
  if(where>=0) {
    parCode=parStr.at(where+1).latin1();
    if(isalpha(parCode)) {
      // Save settings of parameter which IS active:
      //
      presaveParameter(parCode);
    }
  }
  
  orderChanged(mbOrder->currentText());

  QString machineGeneratorPath = fileSearchFile("machines", machFile);
  QFile maFile(machineGeneratorPath.latin1());

  RLOG("\nMachine: ");
  RLOG(machineGeneratorPath.latin1());
  
  if(maFile.open(IO_WriteOnly)) {
    QTextStream maStream(&maFile);
    int i;                     // counter
    QString* ord;              // Walk through orders

    maStream << "[Description]\n" 
                "{Selfmade}\n\n";

    maStream << "[Standards]\n";

    if(strlen(mbExtension->currentText())>0) {
      if(mbExtension->currentText()[0]=='$') {
        maStream << "Extension            = $" << mbExtension->currentText().at(1).latin1() << "\n";
      }
      else {
        maStream << "Extension            = " << mbExtension->currentText() << "\n";
      }
    }
    
    maStream << "ContourStartInHeader = 0\n";
    maStream << "LayerStartInHeader   = 0\n";
    
    maStream << "Optimization         = ";
    if(!strcmp(mbOptimization->currentText(), "on"))  maStream << 1 << "\n";
    else                                              maStream << 0 << "\n";
    
    maStream << "ContourCenter        = ";
    if(!strcmp(mbContourCenter->currentText(), "on")) maStream << 1 << "\n";
    else                                              maStream << 0 << "\n";

    maStream << "Sorting              = ";
         if(!strcmp(mbSorting->currentText(), SORT_A)) maStream << 'a';
    else if(!strcmp(mbSorting->currentText(), SORT_L)) maStream << 'l';
    else if(!strcmp(mbSorting->currentText(), SORT_C)) maStream << 'c';
    else maStream << 'n';
    maStream << "\n";

    maStream << "Direction            = ";
         if(!strcmp(mbDirection->currentText(), DIR_2)) maStream << '2';
    else if(!strcmp(mbDirection->currentText(), DIR_3)) maStream << '3';
    else if(!strcmp(mbDirection->currentText(), DIR_S)) maStream << 's';
    else maStream << 'n';
    maStream << "\n";

    if(strlen(mbStartNumber->currentText())>0) {
      if(mbStartNumber->currentText()[0]=='$') {
        maStream << "StartNumber          = $" << mbStartNumber->currentText().at(1).latin1() << "\n";
      }
      else {
        maStream << "StartNumber          = " << mbStartNumber->currentText() << "\n";
      }
    }

    if(strlen(mbNumberStep->currentText())>0) {
      if(mbNumberStep->currentText()[0]=='$') {
        maStream << "NumberStep           = $" << mbNumberStep->currentText().at(1).latin1() << "\n";
      }
      else {
        maStream << "NumberStep           = " << mbNumberStep->currentText() << "\n";
      }
    }

    if(strlen(mbMaxArcAngle->currentText())>0) {
      if(mbMaxArcAngle->currentText()[0]=='$') {
        maStream << "MaxArcAngle          = $" << mbMaxArcAngle->currentText().at(1).latin1() << "\n";
      }
      else {
        maStream << "MaxArcAngle          = " << mbMaxArcAngle->currentText() << "\n";
      }
    }

    if(strlen(mbMaxArcLength->currentText())>0) {
      if(mbMaxArcLength->currentText()[0]=='$') {
        maStream << "MaxArcLength         = $" << mbMaxArcLength->currentText().at(1).latin1() << "\n";
      }
      else {
        maStream << "MaxArcLength         = " << mbMaxArcLength->currentText() << "\n";
      }
    }

    if(strlen(mbTolerance->currentText())>0) {
      if(mbTolerance->currentText()[0]=='$') {
        maStream << "Tolerance            = $" << mbTolerance->currentText().at(1).latin1() << "\n";
      }
      else {
        maStream << "Tolerance            = " << mbTolerance->currentText() << "\n";
      }
    }

    if(strlen(mbFactor->currentText())>0) {
      if(mbFactor->currentText()[0]=='$') {
        maStream << "Factor               = $" << mbFactor->currentText().at(1).latin1() << "\n";
      }
      else {
        maStream << "Factor               = " << mbFactor->currentText() << "\n";
      }
    }

    maStream << "\n[Pointing]\n";
    maStream << "Pointing             = ";
    if(!strcmp(mbPointing->currentText(), "on")) maStream << 1 << "\n";
    else                                         maStream << 0 << "\n";
    maStream << "PointingAngle        = " << mbPointingAngle->currentText() << "\n";
    maStream << "PointingDepth        = " << mbPointingDepth->currentText() << "\n";
    maStream << "PointingLimit        = " << mbPointingLimit->currentText() << "\n";
    maStream << "PointingMaxLength    = " << mbPointingMaxLength->currentText() << "\n";

    maStream << "\n[Parameter]\n";
    for(i=0; i<(int)parameterString.length(); ++i) {
      if(!strncmp(parameter[i].latin1(), "Parameter", 9)) {
        maStream << parameter[i].latin1() << "\n";
      }
    }

    maStream << "\n[LayerParameter]\n";
    for(i=0; i<(int)parameterString.length(); ++i) {
      if(!strncmp(parameter[i].latin1(), "LayerParameter", 14)) {
        maStream << parameter[i].latin1() << "\n";
      }
    }

    maStream << "\n[Code]\n";
    for(ord=order.first(); ord!=0; ord=order.next()) {
      maStream << ord->data() << "\n\n";
    }

    maStream << "\n\n//EOF";
    maFile.close();
  }
}



// OK button was clicked:
//
void 
RConfigMach::okDialog()
{
  // Save all:
  //
  saveMachine();
}







// EOF

