/***************************************************************************
                          rfileplt.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rfileplt.cpp 1998/10/08 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rfileplt.h"

#include <stdlib.h>

#include <qstring.h>
#include <qtextstream.h>
#include <qdatetime.h>

#include "rappwin.h"
#include "rfilebase.h"
#include "rgraphdef.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rlog.h"
#include "rmath.h"
#include "rprgdef.h"
#include "rstatuspanel.h"

// Constructor:
//
RFilePlt::RFilePlt(const char* _name, RGraphic* _graphic)
  :RFileBase(_name)
{
  graphic=_graphic;
}



// Destructor:
//
RFilePlt::~RFilePlt()
{
  
}



// load a plt file (read in buffer / count / read from buufer):
//
bool
RFilePlt::load(bool add)
{
  if(readFileInBuffer()) {
    //replaceBinaryBytesBy(10);
    seperateBuf(10, 13, ';', ':');
    return readFromBuffer(add);
  }
  else {
    return false;
  }
}



// read a plt file from buffer:
//
bool
RFilePlt::readFromBuffer(bool add)
{
  bool      ret;                    // returned value
  QString   pltLine;                // A line in the plt file
  const char* pltCode;                // A code in the plt file
  
  char      pOrder=-1;              // P-Order ('U' 'D' 'A' 'R')
  char      aOrder=-1;              // A-Order ('R' 'A' 'T')
  char      cOrder=-1;              // C-Order ('I')
  char      sOrder=-1;              // S-Order ('P')
  float     xValue=DEF_AREAMAX;     // X-Value (Coordinate)
  float     yValue=DEF_AREAMAX;     // Y-Value (Coordinate)
  float     aValue=DEF_AREAMAX;     // A-Value (Angle)
  int       sValue;                 // Tool Number
  char      curLayer[32];           // Current Layer
  
  float     curX=0.0,               // current X-Value (in mm)
            curY=0.0;               // current Y-Value
            
  bool      xChange;                // x changed in this line
  bool      yChange;                // y changed in this line

  bool      toolIsDown=false;       // Is the tool down?

  int       currentLayerNum;        // Current layer number

  float     unitFactor=1.0;         // factor from filedata (inch, mm, mil) to mm
  
  if(!add) graphic->clearLayers();

  currentLayerNum=graphic->addLayer(DEF_DEFAULTLAYER);

  resetBufP();

  statusPanel()->iniProgress(fSize, RMES(292));

  if(fBuf) {
    do {
      pltLine=(char*)getBufLine();
      if(!pltLine) break;

      pltCode=pltLine.latin1();
      statusPanel()->setProgress(fBufP, 1000);

      RLOG("\npltCode: ");
      RLOG(pltCode);

      if(!pltLine.isEmpty() && strlen(pltCode)>0) {
        xChange=false;
        yChange=false;
        pOrder=-1;        // P-Order ('U' 'D' 'A' 'R')
        aOrder=-1;        // A-Order ('R' 'A' 'T')
        cOrder=-1;        // C-Order ('I')
        sOrder=-1;        // S-Order ('P')

        // Special codes:
        //

        // Switch to INCH mode:
        //
        if(!strncmp(pltCode, "IN", 2)) {
          unitFactor=0.025;
        }

        // P-Order:
        //
        if(pltCode[0]=='P') {
          ++pltCode;
          sscanf(pltCode, "%c", &pOrder);
          ++pltCode;
        }
        
        // A-Order:
        //
        if(pltCode[0]=='A') {
          ++pltCode;
          sscanf(pltCode, "%c", &aOrder);
          ++pltCode;
        }
        
        // C-Order:
        //
        if(pltCode[0]=='C') {
          ++pltCode;
          sscanf(pltCode, "%c", &cOrder);
          ++pltCode;
        }

        // S-Order:
        //
        if(pltCode[0]=='S') {
          ++pltCode;
          sscanf(pltCode, "%c", &sOrder);
          ++pltCode;

          if(sscanf(pltCode, "%*[^0-9.PAC,-]%d", &sValue)==1) {
            pltCode+=strcspn(pltCode, ", ");            // Overread value
          }
        }

        // Get values:
        //
        // PA, PD, PR, PU, AA, AR
        //
        if(pOrder=='A' || pOrder=='D' || pOrder=='R' || pOrder=='U' ||
           aOrder=='A' || aOrder=='R' ) {
           
          // X-Move:
          //
          if(pltCode[0]) {
            // Formally: "%*[^0-9.PAC,-]%f"
            if(sscanf(pltCode, "%f", &xValue)==1) {
              xChange=true;
              pltCode+=strcspn(pltCode, ", ");            // Overread 1st value
              pltCode+=strcspn(pltCode, "0123456789.-");  // Overread comma
            }
          }
  
          // Y-Move:
          //
          if(pltCode[0]) {
            if(sscanf(pltCode, "%f", &yValue)==1) {
              yChange=true;
              pltCode+=strcspn(pltCode, ", ");            // Overread 1st value
              pltCode+=strcspn(pltCode, "0123456789.-");  // Overread comma
            }
          }

          // Angle change:
          //
          if(pltCode[0]) {
            if(sscanf(pltCode, "%f", &aValue)==1) {
              pltCode+=strcspn(pltCode, ", ");            // Overread 1st value
              pltCode+=strcspn(pltCode, "0123456789.-");  // Overread comma
            }
          }
        }

        // ========
        // P-Order:
        // ========
        //
        // PU, PD, PA, PR
        //
        switch(pOrder) {
        
          // -------
          // Pen Up:
          // -------
          case 'U':
            toolIsDown=false;
            curX=xValue;
            curY=yValue;
            
            RLOG("\nPen up");
            
            break;
            
          // ---------
          // Pen Down:
          // ---------
          case 'D':
            toolIsDown=true;
            if(xChange || yChange) {
              if(!mtCompFloat(curX, xValue) ||
                 !mtCompFloat(curY, yValue)    ) {

                graphic->addLine(curX*unitFactor, curY*unitFactor, 
                                 xValue*unitFactor, yValue*unitFactor, 
                                 currentLayerNum);
              }
    
              curX=xValue;
              curY=yValue;
            }
            
            RLOG("\nPen down / line");
            break;

          // ---------
          // Line Abs:
          // ---------
          case 'A':
            if(xChange || yChange) {
              if(toolIsDown) {
                do {
                  if(!mtCompFloat(curX, xValue) ||
                     !mtCompFloat(curY, yValue)    ) {
                    graphic->addLine(curX*unitFactor, curY*unitFactor, 
                                     xValue*unitFactor, yValue*unitFactor, 
                                     currentLayerNum);
                    RLOG("\nLine abs");
                  }
                  curX=xValue;
                  curY=yValue;
    
                } while(sscanf(pltCode, "%*[A-Z]%f,%f", &xValue, &yValue)==2);
              }
              else {
                curX=xValue;
                curY=yValue;
              }
            }
            toolIsDown=true;
            break;

          // ---------
          // Line Rel:
          // ---------
          case 'R':
            if(xChange || yChange) {
              if(toolIsDown) {
                do {
                  if(!mtCompFloat(curX, (curX+xValue)) ||
                     !mtCompFloat(curY, (curY+yValue))    ) {
                    graphic->addLine(curX*unitFactor, curY*unitFactor, 
                                     (curX+xValue)*unitFactor, (curY+yValue)*unitFactor, 
                                     currentLayerNum);
                    RLOG("\nLine rel");
                  }
                  curX+=xValue;
                  curY+=yValue;
    
                } while(sscanf(pltCode, "%*[A-Z]%f,%f", &xValue, &yValue)==2);
              }
              else {
                curX+=xValue;
                curY+=yValue;
              }
            }
            toolIsDown=true;
            break;

          default:
            break;
        }

        // ========
        // A-Order:
        // ========
        //
        // AA, AR
        //
        switch(aOrder) {

          // --------
          // Arc Abs:
          // --------
          case 'A':
            if(xChange || yChange) {
              if(toolIsDown) {
                if(!mtCompFloat(curX, xValue) || 
                   !mtCompFloat(curY, yValue)    ) {
                  if(mtCompFloat(aValue, 360.0) || mtCompFloat(aValue, -360.0)) {
                    // Circle:
                    //
                    graphic->addCircle(xValue*unitFactor, yValue*unitFactor, 
                                       mtGetDistance(curX, curY, xValue, yValue)*unitFactor,
                                       0.0, 360.0, 
                                       false, 
                                       currentLayerNum);
                  }
                  else {
                    // Arc:
                    //
                    graphic->addArc(xValue*unitFactor, yValue*unitFactor, 
                                    mtGetDistance(curX, curY, xValue, yValue)*unitFactor,
                                    mtGetAngle(xValue, yValue, curX, curY),
                                    mtGetAngle(xValue, yValue, curX, curY)+aValue,
                                    aValue<0, currentLayerNum);
                  }
                  curX=graphic->elementCurrent()->getX2()/unitFactor;
                  curY=graphic->elementCurrent()->getY2()/unitFactor;
                }
              }
            }
            toolIsDown=true;
            break;
        
          // --------
          // Arc Rel:
          // --------
          case 'R':
            if(xChange || yChange) {
              if(!mtCompFloat(0.0, xValue) || 
                 !mtCompFloat(0.0, yValue)    ) {
                if(toolIsDown) {
                  if(mtCompFloat(aValue, 360.0) || mtCompFloat(aValue, -360.0)) {
                    // Circle:
                    //
                    graphic->addCircle((curX+xValue)*unitFactor, 
                                       (curY+yValue)*unitFactor, 
                                       mtGetDistance(curX, curY, curX+xValue, curY+yValue)*unitFactor,
                                       0.0, 360.0, 
                                       false, 
                                       currentLayerNum);
                  }
                  else {
                    // Arc:
                    //
                    graphic->addArc((curX+xValue)*unitFactor, 
                                    (curY+yValue)*unitFactor, 
                                    mtGetDistance(curX, curY, curX+xValue, curY+yValue)*unitFactor,
                                    mtGetAngle(curX+xValue, curY+yValue, curX, curY),
                                    mtGetAngle(curX+xValue, curY+yValue, curX, curY)+aValue,
                                    aValue<0, 
                                    currentLayerNum);
                  }
                  curX=graphic->elementCurrent()->getX2()/unitFactor;
                  curY=graphic->elementCurrent()->getY2()/unitFactor;
                }
              }
            }
            toolIsDown=true;
            break;

          default:
            break;
        }

        // ========
        // S-Order:
        // ========
        //
        // SP
        //
        switch(sOrder) {
        
          // -----------
          // Switch Pen:
          // -----------
          case 'P':
            sprintf(curLayer, "%d", sValue);
            currentLayerNum=graphic->addLayer(curLayer);
            break;

          default:
            break;
        }
      }
    }while(pltLine!=NULL);

    ret=true;
  }
  else {
    ret=false;
  }

  statusPanel()->delProgress();

  return ret;
}


// EOF




