/***************************************************************************
                          rgraphdef.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

// Graphic defines:
//

#ifndef RGRAPHDEF_H
#define RGRAPHDEF_H

#define DEF_MMTOL         0.001       // Tolerance
#define DEF_ZOOMBORDER    40          // Border of autozoom in pixel
//#define DEF_AREAMAX       32768       // Max drawing area
//#define DEF_AREAMIN       -32768      // Min drawing area

#define DEF_AREAMAX       1000000      // Max drawing area
#define DEF_AREAMIN       -1000000     // Min drawing area

#define DEF_MAXLAYERS     256         // Max number of layers
#define DEF_MAXPARAMETERS 64          // Max number of parameters
#define DEF_SPEEDRES      1000        // Resolution of speed slider
#define DEF_DEFAULTLAYER  "default"   // Name for default Layer
#define DEF_MAXUNDO       250         // Max number of undo levels
#define DEF_UNDOSHIFT     50          // Shift undo steps by ... steps if full


// Start Flags with 2 / 1 is used for defaults!!!
//
#define G_DEFAULT         0x00000001  // Default value for flags
#define G_GRID            0x00000002  // Flag for grid setting (on/off)
#define G_GRIDWIDTH       0x00000004  // Flag for grid width (on/off)
#define G_ZERO            0x00000008  // Flag for Zero point (visible/not visible)
#define G_INFO            0x00000010  // Flag for showing information (on/off)
#define G_TAGGEDONLY      0x00000020  // Flag for drawing tagged elements only
#define G_TAGGEDCOLOR     0x00000040  // Flag for drawing the tagged elements
                                      //   in a different color
#define G_RAPID           0x00000080  // Flag for showing rapid move
#define G_DETAILS         0x00000100  // Flag for showing details
#define G_BROKEN          0x00000200  // Flag for highlighting broken contours
#define G_CHANGED         0x00000400  // Flag for changed graphics
#define G_PRINTPREV       0x00000800  // Flag for graphics in print preview mode

#endif

// EOF






