/***************************************************************************
                          rhatchdialog.h  -  description
                             -------------------
    begin                : Tue Oct 19 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : mustun@ribbonsoft.com
 ***************************************************************************/


#ifndef RHATCHDIALOG_H
#define RHATCHDIALOG_H

#include <qdialog.h>
#include <qtooltip.h>
#include <qpushbutton.h>

#include "rlabel.h"
#include "rcombobox.h"

#define DEF_HATCHDLG_WIDTH  256
#define DEF_HATCHDLG_HEIGHT 120


/**
 * A dialog for choosing a pattern and a factor for a hatch.
 * @author Andreas Mustun
 */
class RHatchDialog : public QDialog  {
  Q_OBJECT
public:
	RHatchDialog(const char* _caption,
	             const char* _label,
               QWidget* _parent=0);

	~RHatchDialog();
	
	
	QString getPattern();
	float getFactor();
	
private:
  QPushButton* bOk;
  QPushButton* bCancel;
  QPushButton* bHelp;

  RLabel*      lText;
  RComboBox*   cbPattern;
  RComboBox*   cbFactor;
};

#endif

