/***************************************************************************
                          rlineedit.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rlineedit.cpp 1998/09/19 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <qlineedit.h>

#include "rlineedit.h"
#include "rstring.h"
#include "rconfig.h"


// Constructor:
//
RLineEdit::RLineEdit(QWidget* _parent, const char* _name)
:QLineEdit(_parent, _name)
{
  setFont(QFont("helvetica", RCONFIG->getSettingInt("Application:FontSize0")));
}


// Destructor:
//
RLineEdit::~RLineEdit()
{
}



// Set a float value:
//
void
RLineEdit::setFloat(float _value)
{
  QString str;
  str.setNum(_value, 'g', 3);
  setText(str);
  //setText(strFloatToString(_value));
}


// Set a integer value:
//
void
RLineEdit::setInteger(int _value)
{
  /*char strValue[128];
  sprintf(strValue, "%d", _value);
  setText(strValue);*/
  
  QString str;
  str.setNum(_value);
  setText(str);
}


// Get the contents of this box as a float value:
//
float
RLineEdit::getFloat()
{
  //return atof(text());
  return text().toFloat();
}


// Get the contents of this box as an int value:
//
int
RLineEdit::getInt()
{
  //return atoi(text());
  return text().toInt();
}

// EOF

