/***************************************************************************
                          rwidget.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rwidget.h 1998/08/24 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RWIDGET_H
#define RWIDGET_H

#include <qframe.h>

#include "rwidget.h"

#include "rprgdef.h"

class RWidget : public QFrame
{
  Q_OBJECT
public:
  /*! Constructor
      \param _parent The parent widget
      \param _name Name
      \param _f Flags
      \param _forwardRightClick Must we forward the right click of the mouse
      \param _forwardRightClick Must we forward the moves of the mouse
  */
  RWidget(QWidget* _parent=0, 
          const char* _name=0, 
          WFlags _f=0,
          bool _forwardRightClick=false,
          bool _forwardMouseMove=false);
  /*! Destructor
  */
  ~RWidget();
    
protected:
  /*! Mouse button released
  */
  virtual void mouseReleaseEvent(QMouseEvent* _ev);

  /*! Mouse moved
  */
  virtual void mouseMoveEvent(QMouseEvent* _ev);
    
private:
  /*! Must we forward the right click of the mouse?
  */
  bool forwardRightClick;

  /*! Must we forward the mouse moves to parent?
  */
  bool forwardMouseMove;
  
};


#endif

// EOF


