/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "GuiColormapLinear.h"
#include <stdio.h>
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


#define LOAD		0
#define SAVE		1
#define BANDSIZE	15


/*
 *  constructor: initialize everything
 */
GuiColormapLinear::GuiColormapLinear (Gtk_Widget *parent, int maxcolors) : 
		      GuiColormap (parent, maxcolors)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ GuiColormapLinear\n");

	this->d_linear = TRUE;
}


/*
 *  destructor: nothing to clean up
 */
GuiColormapLinear::~GuiColormapLinear ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- GuiColormapLinear\n");
}


/*
 *  allocColors: allocate the required colors into the colormap
 */
int GuiColormapLinear::allocColors ( int nShades, 
					float fr, float fg, float fb,	 // floor color
					float cr, float cg, float cb )   // ceil color
{
	int		i;
	GdkColor	col;
	float		r = fr*MAXBRIGHT, 
			g = fg*MAXBRIGHT, 
			b = fb*MAXBRIGHT,
			ir = (cr-fr)*MAXBRIGHT/nShades,
			ig = (cg-fg)*MAXBRIGHT/nShades,
			ib = (cb-fb)*MAXBRIGHT/nShades;
	char 		buf[80];

	if ( SanityCheck::warning ((fr==cr && fg==cg && fb==cb), 
	     "constant color range", "GuiColormapLinear::allocColors") )
		return -1;

	GlobalTrace::trace (GlobalTrace::TRACE_VERBOSE, "Colormap: "); 

	for (i=0; i<nShades; i++)
		{
		r += ir; 
		g += ig;
		b += ib;
		col.red = (int)r;
		col.green = (int)g;
		col.blue = (int)b;
		if (!this->addColor (&col))
			{
			fprintf (stderr, _("Error allocating color %d, %d, %d ... Exiting\n"), 
				col.red, col.green, col.blue);
			exit (1);
			}
		}

	sprintf (buf, "allocated %d color shades ...\n", i); 
	GlobalTrace::trace (GlobalTrace::TRACE_VERBOSE, buf);

	return (d_ncolors);
}


/*
 *  allocColors: allocate the required colors into the colormap
 */
int GuiColormapLinear::allocColors ( int nShades, 
					float fr, float fg, float fb,	 // floor color
					float ambient)
{
	int		i;
	GdkColor	col;
	float		r = fr*MAXBRIGHT, 
			g = fg*MAXBRIGHT, 
			b = fb*MAXBRIGHT,
			ir = -(r-r*(1-ambient))/nShades,
			ig = -(r-g*(1-ambient))/nShades,
			ib = -(r-b*(1-ambient))/nShades;
	char 		buf[80];

	if ( SanityCheck::warning ((ambient<=0), "ambient==0", "GuiColormapLinear::allocColors") )
		return -1;

	GlobalTrace::trace (GlobalTrace::TRACE_VERBOSE, "Colormap: "); 

	for (i=0; i<nShades; i++)
		{
		r += ir; 
		g += ig;
		b += ib;
		col.red = (int)r;
		col.green = (int)g;
		col.blue = (int)b;
		if (!this->addColor (&col))
			{
			fprintf (stderr, _("Error allocating color %d, %d, %d ... Exiting\n"), 
				col.red, col.green, col.blue);
			exit (1);
			}
		}

	sprintf (buf, "allocated %d ambient shades ...\n", i); 
	GlobalTrace::trace (GlobalTrace::TRACE_VERBOSE, buf);

	return (d_ncolors);
	return (0);
}
