/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_BASE_DIALOG_H
#define _TF_BASE_DIALOG_H 1


#include "GuiDialogOAC.h"			// includes gtk, gtk--
#include "HeightFieldOps.h"
#include "HeightFieldDraw.h"


/*
 *  TFBaseDialog: extend GuiDialogOAC to provide integration 
 *	of HF data into the dialog. This is a base class for 
 * 	other preview dialogs. 
 */
class TFBaseDialog : public GuiDialogOAC
	{
	public: 
				TFBaseDialog (HeightField *HF, HeightFieldDraw *HFD, 
						 char *winTitle, char *paramTitle);
				~TFBaseDialog (); 
		void		setHFobjs (HeightField *HF, HeightFieldDraw *HFD);


	protected:
		virtual void 	fillVBox () {;}

		Gtk_VBox 		d_vbOptions; 
		HeightField		*p_HF; 
		HeightFieldDraw		*p_HFD; 
		HeightFieldOps		*p_HFO; 
	};


#endif // _TF_BASE_DIALOG_H
