/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_MERGE_H
#define _TF_DIALOG_MERGE_H 1


#include "GuiDialogOAC.h"				// include gtk, gtk--
#include "TFWindowHandler.h"
#include "flexarray.h"


#define MENU_MERGE_ADD		"Add"
#define MENU_MERGE_SUB		"Subtract"
#define MENU_MERGE_MULT		"Multiply"
#define MENU_MERGE_DIV		"Divide"
#define MENU_MERGE_MIN		"Minimum"
#define MENU_MERGE_MAX		"Maximum"



/*
 *  TFDialogMerge: display the merge dialog 
 */
class TFDialogMerge : public GuiDialogOAC
	{
	public: 
				TFDialogMerge (FlexArray *winList);
				~TFDialogMerge (); 
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();
		void		initHeightFields (TFWindowHandler *TFWH=NULL);
		void		rebuildCList ();

	protected:
		void		insertCList();
		void		insertAssignButtons ();
		void		insertSourcePreviews ();
		void		insertDestPreviews ();
		void		rowSelectedCallback (int row, int col, GdkEvent *e);
		void		button1Callback ();
		void		button2Callback ();
		gint		processCListButtonPress (GdkEventButton *e);
		void		updatePreviewCallback ();
		gint		delete_event_impl (GdkEventAny *s);

		int			d_lastSelect;
		Gtk_VBox		d_vBox1,
					d_vBox2,
					d_vBox3,
					d_vBox4;
		Gtk_HBox		d_hbMain,
					d_hbFactor1, d_hbFactor2;
		Gtk_Button		d_btn1, d_btn2;
		Gtk_HSeparator		d_hSep;
		FlexArray		*d_winList;
		HeightField		*p_HF1, *p_HF1Preview,
					*p_HF2, *p_HF2Preview,	
					*p_HF3, *p_HF3Preview;	
		HeightFieldDraw		*p_HFD1, *p_HFD1Preview,
					*p_HFD2, *p_HFD2Preview,
					*p_HFD3, *p_HFD3Preview;
		GuiBufferedDrawingArea	*p_drawArea1, *p_drawArea2, *p_drawArea3;
		Gtk_CList		*p_cList;
		Gtk_Combo		*p_cmbMethod;
		GList			*p_glstMethod;
		Gtk_Frame		*p_pvwFrame1,
					*p_pvwFrame2,
					*p_pvwFrame3,
					*p_frmGrp1,
					*p_frmGrp2;
		Gtk_ScrolledWindow	*p_scrolledWin;
		Gtk_Adjustment		*p_adjFactor1, *p_adjFactor2;
		Gtk_HScale		*p_hsFactor1, *p_hsFactor2;
		Gtk_Pixmap		*p_pixmap1, *p_pixmap2;
		Gtk_Packer		*p_packSourceMain, *p_packSourceGrp1, 
					*p_packSourceGrp2, *p_packAssignButtons;
	};


#endif // _TF_DIALOG_MERGE_H
