/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_OPTIONS_TABLE_H
#define _TF_OPTIONS_TABLE_H 1


#include "tf_flexarrCharPtr.h"
#include "glib--hash.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


// defined in TFWindow.cc
extern guint TFWhash (gconstpointer key);
extern gint TFWhashcmp (gconstpointer a, gconstpointer b);     

// defined in TFOptions.cc
extern void hash_key_fetcher (gpointer key, gpointer data, gpointer user_data);


#define TF_OPT_FILL_SEA			"b_fill_sea"
#define TF_OPT_DRAW_DERIVED_DATA	"b_draw_derived_data"
#define TF_OPT_FAST_HALF_RES		"b_fast_half_res"
#define TF_OPT_FAST_HALF_Y_SCALE 	"b_fast_half_yscale"
#define TF_OPT_YSCALE			"f_half_yscale"
#define TF_OPT_FAST_ZROT		"b_fast_zrot"
#define TF_OPT_SCALE			"i_scale"
#define TF_OPT_SYNC_RATE		"i_sync_rate"
#define TF_OPT_RESOLUTION		"i_resolution"
#define TF_OPT_SEALEVEL			"f_sealevel"
#define TF_OPT_POV_FILE 		"s_pov_file"
#define TF_OPT_POV_WIDTH		"i_pov_width"
#define TF_OPT_POV_YSCALE		"b_pov_half_yscale"
#define TF_OPT_POV_KEEP_FILES		"f_pov_keep_files"


/*
 *  TFOptionsTable: provide a symbol table for the available options which 
 * 	can be set in the RC file. 
 */
class TFOptionsTable : public Glib_Hash
	{
	public:
				TFOptionsTable ();
				~TFOptionsTable ();
		int		setKeyVal (gpointer key, gpointer value);
		TFFlexArrayCharPtr *collectOptions ();
	};


/*
 *  constructor: fill the slots for the recognized options. This basically 
 *	abuses a hash table as a parser. Insert the recognized keys
 *	and then check whatever you parse against the contents of 
 *	the hash table. If a record isn't found, it's a syntax error. 
 */
inline TFOptionsTable::TFOptionsTable ()
		      : Glib_Hash (TFWhash, TFWhashcmp)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFOptionsTable\n");

	// create symbol table entries (keys) with no value
	this->insert (strdup(TF_OPT_FILL_SEA), NULL);
	this->insert (strdup(TF_OPT_DRAW_DERIVED_DATA), NULL);
	this->insert (strdup(TF_OPT_FAST_HALF_RES), NULL);
	this->insert (strdup(TF_OPT_FAST_HALF_Y_SCALE), NULL);
	this->insert (strdup(TF_OPT_FAST_ZROT), NULL);
	this->insert (strdup(TF_OPT_SCALE), NULL);
	this->insert (strdup(TF_OPT_SYNC_RATE), NULL);
	this->insert (strdup(TF_OPT_RESOLUTION), NULL);
	this->insert (strdup(TF_OPT_YSCALE), NULL);
	this->insert (strdup(TF_OPT_SEALEVEL), NULL);
	this->insert (strdup(TF_OPT_POV_FILE), NULL);
	this->insert (strdup(TF_OPT_POV_WIDTH), NULL);
	this->insert (strdup(TF_OPT_POV_YSCALE), NULL);
	this->insert (strdup(TF_OPT_POV_KEEP_FILES), NULL);
}


/*
 *  destructor: clean up 
 */
inline TFOptionsTable::~TFOptionsTable ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFOptionsTable\n");
}


/*
 *  setKeyVal: check if the key we're given is a recognized keyword. If so, 
 * 	delete the old (NULL) entry and insert a new one. 
 */
inline int TFOptionsTable::setKeyVal (gpointer key, gpointer value)
{
	char 	*v;

	if (!value || !strlen((char*)value))
		return -1;

	v = (char*)this->lookup (key);

	this->remove (key);
	this->insert (key, value);
	return (0);
}


/*
 * collectOptions: collect a sorted list of RC file options in a FlexArray
 */
inline TFFlexArrayCharPtr *TFOptionsTable::collectOptions ()
{
	TFFlexArrayCharPtr *flArr = new TFFlexArrayCharPtr (10);
	int		lim, rc;
	char		**data, *t;

	this->foreach (hash_key_fetcher, flArr);

	data = static_cast<char**>(flArr->getData());
	lim = flArr->getSize ();

	// quick & simple bubble sort
	for (int i=0; i<lim; i++)
	    for (int j=0; j<lim; j++)
		{
		rc = strcmp (data[j], data[i]);
		if (rc > 0)
			{
			t = data[j];
			data[j] = data[i];
			data[i] = t;
			}
		}

	return flArr;
}


#endif // _TF_OPTIONS_TABLE_H
