/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "terraform.h"

#include <math.h>
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "GuiDialogOAC.h"
#include "HeightField.h"
#include "HeightFieldGenRandom.h"
#include "HeightFieldIO.h"
#include "MathGauss.h"
#include "PrintOptions.h"
#include "TFGui.h"
#include "TFOptions.h"


//
// instantiate static data members
//
const int 	GuiDialogOAC::s_HBOff=3;
const int 	GuiDialogOAC::s_VBOff=3;
const int 	MathGauss::s_gaussNRand=4;
const double 	MathGauss::s_maxRand=pow(2.0, 15.0)-1.0;
double 		MathGauss::s_gaussAdd=0.0;
double 		MathGauss::s_gaussFac=0.0;
int 		GlobalTrace::s_traceLevel=0;
string		PrintOptions::s_paperSize = "A4";
char		PrintOptions::s_orientation = 'P';
char		PrintOptions::s_color = 'C';
float		PrintOptions::s_marginT = 2.8222;
float		PrintOptions::s_marginB = 2.8222;
float		PrintOptions::s_marginL = 2.8222;
float		PrintOptions::s_marginR = 2.8222;
float		PrintOptions::s_paperHeight = 42.0;
float		PrintOptions::s_paperWidth = 29.7;
float		PrintOptions::s_scaleFactor = 100;
bool 		TFOptions::s_fillSea=TRUE;
bool 		TFOptions::s_drawDerivedData=TRUE;
bool 		TFOptions::s_fastHalfRes=TRUE;
bool 		TFOptions::s_fastHalfYscale=TRUE;
bool 		TFOptions::s_fastZrot=FALSE;
int 		TFOptions::s_scale=1;
int 		TFOptions::s_syncRate=250;
int 		TFOptions::s_resolution=10;
float 		TFOptions::s_yscale=0.33;
float 		TFOptions::s_sealevel=0.33;
char		*TFOptions::s_POVfile=NULL;
int 		TFOptions::s_POVwidth=400;
bool		TFOptions::s_POVhalfYscale=TRUE;
bool		TFOptions::s_POVkeepFiles=FALSE;
bool		TFOptions::s_large=FALSE;
bool		TFOptions::s_POV30=FALSE;
char		*TFOptions::s_POVexec=NULL;
bool		TFOptions::s_fixedMenus=FALSE;
bool		TFOptions::s_saveSettings=TRUE;
bool		TFOptions::s_settingsAreChanged=FALSE;


#ifdef TF_DEBUG
#include "signal.h"
extern void tf_segfault_handler (int sig);
#endif

int readhf (HeightField **HF, char *fname, bool haveGUI);


/*
 *  readhf: create a new HF object and then read into it
 */
int readhf (HeightField **HF, char *fname, bool haveGUI)
{
	int		rc=0;
	char		*ext;
	HeightFieldIO	*HFIO=NULL;

	SanityCheck::bailout ((*HF), "*HF!=NULL", "readhf()");
	SanityCheck::bailout ((!fname), "fname==NULL", "readhf()");
	SanityCheck::bailout ((!strlen(fname)), "strlen(fname)==0", "readhf()");

	
	*HF = new HeightField ();
	HFIO = new HeightFieldIO (fname);

	ext = HFIO->getExtension();
	if (!ext)			// make sure we don't dump core 
		ext = "";		// in the following strcmp calls 

	if (!haveGUI &&
	    (!strcmp(ext,"png") || !strcmp(ext,"tiff") || !strcmp(ext,"tif")) )
		{
		delete HFIO;
		printf (_("Sorry -- PNG and TIFF read not supported from command line\n"));
		delete *HF;
		*HF = NULL;
		return 1;
		}

	rc = HFIO->read (*HF);
	if (rc)
		delete *HF;
	HFIO->close ();
	delete HFIO;	

	return (rc);
}


/*
 *  main: run the terraform program 
 */
int main (int argc, char *argv[])
{
	int		do_gui=TRUE;
	HeightField	*HF=NULL;
	TFOptions	*tfOpt = new TFOptions ();

	// alloc memory for char string 
	TFOptions::s_POVexec = strdup ("povray");
	TFOptions::s_POVfile = (char *)malloc(256);
	sprintf (TFOptions::s_POVfile, "%s/%s", TF_DATADIR, TF_DEFAULT_POV_FILE);

#ifdef TF_DEBUG	
	signal(SIGSEGV, tf_segfault_handler);
#endif

#ifdef ENABLE_NLS
	textdomain (PACKAGE);
	setlocale (LC_MESSAGES, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
#endif

	// process all args 
	tfOpt->processArgs (&HF, argc, argv);

	// use graphical user interface
	if (do_gui)
		{
		Gtk_Main	gtkMain (&argc, &argv);
		TFGui	*tfGui;

		gdk_rgb_init ();		// needed for RGB draw
		tfGui = new TFGui ();		// init TFGui data structures
		if (HF)
			tfGui->addHeightField (HF);
		gtkMain.run();
		}
/*
	// use command line interface
	else
		{
		if (!(HFP = new HeightFieldParser (verbose)))
			{
			cerr << "Error instantiating HeightFieldParser ... Exiting\n";
			exit (NOGOOD);
			}
		HFP->P_Parse ();
		delete HFP;
		exit (1);
		}
*/

	free (TFOptions::s_POVfile);
	exit (0);
}
