// na9file.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef NA9FILE_H
#define NA9FILE_H

#include "nafile.h"

#define NA9_CALL_SIZE            12

class RNa9File : public RNaFile {
// The first 800 bytes of the .QDF consists of this header
// Thereafter, the file is filled with NaQso records
typedef struct Na9Headerstruct {
    char id;
    char callsign[NA9_CALL_SIZE];
    // LINUX doesn't like anonymous structs, Watcom does not like
    // "typedef" structs in an anonymous union.  So, let's name
    // them both and please everyone.
    union {
        char nickname[8];               // For NA QSO Party
        struct ss_struct {                        // For SS
            char ss_prec;
            char ss_filler[5];
            char ss_check[2];
        } ss;
        char ex_info[8];
    } misc;
    char location[4];
    char name[30];
    char addressCallsign[6];
    char address[30];
    char city[30];
    char state[2];
    char zip[5];
    char clubName[30];
    short contest;                  // Not valid for NA9 files.  Look in contestName[].
    short category;                 // 0 = SO, 1 = MO
    short mode;                     // 0 = CW, 1 = SSB
    short power;                    // 0 = 5W, 1 = 150W, 2 = 1500W
    char filler1[12];
    short SSBPort;                  // 0 = None, 1-3 = LPT1-3
    char filler5[2];
    short tnc;                      // 0 = None, 1 = Local, 2 = Remote
    short radio;                    // 0=None,1=IC735,2=IC751,3=IC761,4=IC765,5=IC781,6=KENWOOD
    unsigned char stationNumber;
    unsigned char com1;            // 0=1200,16=2400,32=4800,48=9600 - 0=None,1=TNC,2=XCVR,3=LINK,
    unsigned char com2;
    char filler4[2];
    char cq_msg[32];
    char ex_msg[32];
    char qrz_msg[32];
    char call_msg[32];
    char b4_msg[32];
    char ques_msg[32];
    char filler2[11];
    char contestName[8];
    char filler6[13];
    char filler[385];
} Na9Header;

typedef struct Na9QsoStruct {
    long date;                  // Seconds since midnight 1/1/1980!
    union {
        char mode:2;
        long freq;              // In tenths of kHz minus lowest two bits
    };
    char misc;
    char callsign[NA9_CALL_SIZE];
    char info[11];
    char qth[4];
    char filler[4];
} Na9Qso;

Na9Header na9header;

public:

    RNa9File()                   {location = 0;};
    RNa9File(char *name);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
    boolean writeHeader(header_data newheader);  /* Write new header to the file. */
    virtual boolean nextQso(qso_data *);         /* Return next generic QSO record */
    virtual boolean writeQso(qso_data *);        /* Write a generic QSO record */
};
#endif
