// qsodata.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "qsodata.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

void qso_data::addMult(char *mult)
{
    if (strlen(multipliers) == 0)
    {
        strcpy(multipliers, mult);
        multCount = 1;
    }
    else
    {
        strcat(multipliers, " ");
        strcat(multipliers, mult);
        multCount++;
    }
}

const unsigned char qso_data::getCallsignLength()
{
    return (unsigned char)strlen(callsign);
}

const unsigned char qso_data::getInfoLength()
{
    return (unsigned char)strlen(info);
}

const unsigned char qso_data::getNameLength()
{
    return (unsigned char)strlen(name);
}

const unsigned char qso_data::getQthLength()
{
    return (unsigned char)strlen(qth);
}

void qso_data::init()
{
    memset(this, '\0', sizeof(qso_data));

    // The following files must be initialized to
    // some value other than 0
    ss.precedence = ' ';
    fd.category = ' ';
}

const bool qso_data::isInfoNumeric()
{
    if (isdigit(info[0]))
                return TRUE;
        else
                return FALSE;
}

void qso_data::setAge(char *newAge)
{
    age = (unsigned char)atoi(newAge);
}

void qso_data::setARCInumber(char *num)
{
    ARCInumber = (unsigned short)atoi(num);
}

void qso_data::setCallsign(char *call)
{
    if (strlen(call) < QSO_DATA_CALL_SIZE)
        strcpy(callsign, call);
    else
        strncpy(callsign, call, QSO_DATA_CALL_SIZE-1);
    return;
}

void qso_data::setCallsign(char *call, int length)
{
    char *pLastSpace;
    
    memset(callsign, '\0', QSO_DATA_CALL_SIZE);
    
    if (length < QSO_DATA_CALL_SIZE)
    {
        strncpy(callsign, call, length);
        pLastSpace = strchr(callsign, ' ');
        if (pLastSpace)
            *pLastSpace = (char)NULL;
    }
    else
    {
        strncpy(callsign, call, QSO_DATA_CALL_SIZE - 1);
        callsign[QSO_DATA_CALL_SIZE - 1] = (char)NULL;
    }
}

void qso_data::setContest(unsigned char newContest)
{
    contest = newContest;
}

void qso_data::setCqZone(char *zone)
{
    cqZone = atoi(zone);
}

void qso_data::setFdTransmitters(char *transNum)
{
    fd.transmitters = (unsigned char)atoi(transNum);
}

void qso_data::setInfo(char *newInfo)
{
    strcpy(info, newInfo);
}

void qso_data::setInfo(char *newInfo, int size)
{
    strncpy(info, newInfo, size);
}

void qso_data::setItuZone(char *zone)
{
    ituZone = atoi(zone);
}

void qso_data::setName(char *newName)
{
    strcpy(name, newName);
}

void qso_data::setQslReceived(char received)
{
    qsl_rcvd = received;
}

void qso_data::setQslSent(char sent)
{
    qsl_sent = sent;
}

void qso_data::setQsoPoints(char *points)
{
    qsoPoints = (unsigned char)atoi(points);
}

void qso_data::setQth(char *newQth)
{
    strcpy(qth, newQth);
}

void qso_data::setQth(char *newQth, int size)
{
    strncpy(qth, newQth, size);
}

void qso_data::setReceivedRST(char *rst)
{
    receivedRST = atoi(rst);
}

void qso_data::setSection(char *newSection)
{
    strcpy(section, newSection);
}

void qso_data::setSection(char *newSection, int size)
{
    strncpy(section, newSection, size);
}

void qso_data::setSentRST(char *rst)
{
    sentRST = atoi(rst);
}

void qso_data::setSerialNumber(char *serialNum)
{
    serialNumber = atoi(serialNum);
}

void qso_data::setSerialNumberSent(char *serialNum)
{
    serialNumSent = atoi(serialNum);
}

void qso_data::setState(char *newState, int size)
{
    strncpy(state, newState, size);
}

void qso_data::setSSCheck(char *chk)
{
    ss.check = (unsigned char)atoi(chk);
}

void qso_data::setTenTenNumber(char *tenTen)
{
    tenTenNumber = (unsigned int)atoi(tenTen);
}

void qso_data::setTime(int year, int month, int day,
              int hour, int minutes)
{
    struct tm dosTime;

    memset(&dosTime, '\0', sizeof(struct tm));
    
    dosTime.tm_mday = day;
    dosTime.tm_mon = month;
    dosTime.tm_year = year;
    dosTime.tm_hour = hour;
    dosTime.tm_min = minutes;
    dosTime.tm_sec = 0;
    dosTime.tm_isdst = 0;
    
    time = mktime(&dosTime) - timezone;
}

void qso_data::setTxPower(int power)
{
    txPower = power;
}

void qso_data::setTxPower(char *power)
{
    txPower = atoi(power);
}


