// wrtc.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "wrtc.h"

#include <stdlib.h>                     // for atoi()
#include <string.h>

#define MAX_WRTC_LINE_SIZE     80

static char *bands[] = {0,"160","80","40","30","20","18","15","12","10"};
static char *modes[] = {NULL, "CW", "SSB"};
                              
RWrtcFile::RWrtcFile(char *name)
{
    RWrtcFile::open(name);
}

boolean RWrtcFile::open(char *name, int mode)
{
    char buffer[MAX_WRTC_LINE_SIZE];
    
    if (!RFile::open(name, mode))
        return FALSE;

    if (!(mode & ios::out))
    {
        RFile::getString((char *)buffer, MAX_WRTC_LINE_SIZE);
        strcpy(header.callsign, strtok(&buffer[5], " "));
        strncpy(header.year, strtok(&buffer[18], "/"), 4);
        RFile::position(0);                             // Go back to the beginning of the file.

        header.contest = IARU_CONTEST;
        strcpy(header.contestName, "IARU HF Championships");
    }
    
    location = 0;

    return TRUE;
}

boolean RWrtcFile::nextQso(qso_data *qso)
{
    char buffer[MAX_WRTC_LINE_SIZE];
    char *tmpPtr;
    struct tm dosTime;
             
    qso->init();
    if (RFile::getString((char *)buffer, MAX_WRTC_LINE_SIZE))
    {
        qso->setSerialNumber(strtok(&buffer[0], " "));
        strtok(NULL, " ");                      // Get user's callsign, throw away.
        
        tmpPtr = strtok(NULL, " ");
        for (unsigned char n = BAND_160M; n <= BAND_10M; n++)
            if (strcmp(tmpPtr, bands[n]) == 0)
                qso->setBand(n);

        tmpPtr = strtok(NULL, " ");
        if (strcmp(tmpPtr, modes[CW_MODE]) == 0)
            qso->setMode(CW_MODE);
        else if (strcmp(tmpPtr, modes[SSB_MODE]) == 0)
            qso->setMode(SSB_MODE);
        else
            return FALSE;

        dosTime.tm_year = atoi(strtok(NULL, "/")) - 1900;
        dosTime.tm_mon = atoi(strtok(NULL, "/")) - 1;
        dosTime.tm_mday = atoi(strtok(NULL, " "));
        dosTime.tm_hour = atoi(strtok(NULL, ":"));
        dosTime.tm_min = atoi(strtok(NULL, ":"));
        dosTime.tm_sec = atoi(strtok(NULL, " "));
        dosTime.tm_isdst = 0;
        qso->setTime(mktime(&dosTime) - timezone);

        qso->setCallsign(strtok(NULL, " "));

        qso->setReceivedRST(strtok(NULL, " "));
        qso->setInfo(strtok(NULL, " \r"));
        
        location++;
    }
    else
        return FALSE;
    return TRUE;
}

// No support for outputing these types of files at this time.
boolean RWrtcFile::writeQso(qso_data *qso)
{
    qso = qso;
    return FALSE;
}

boolean RWrtcFile::writeHeader(header_data header)
{
    header = header;
    return FALSE;
}
