// ---------------------------------------------------------------------------
// - Builtin.hpp                                                             -
// - aleph engine - builtin functions definitions                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_BUILTIN_HPP
#define  ALEPH_BUILTIN_HPP

#ifndef  ALEPH_OBJECT_HPP
#include "Object.hpp"
#endif

namespace aleph {
  // reserved keywords
  Object* builtin_if      (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_do      (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_for     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_try     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_eval    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_const   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_trans   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_class   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_block   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_while   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_gamma   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_throw   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_lambda  (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_switch  (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_return  (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_protect (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_nameset (Interp* interp, Nameset* nset, Cons* args);

  // standard operators
  Object* builtin_add     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_sub     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_mul     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_div     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_eql     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_neq     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_geq     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_gth     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_leq     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_lth     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_assert  (Interp* interp, Nameset* nset, Cons* args);

  // logical operator
  Object* builtin_or      (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_not     (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_and     (Interp* interp, Nameset* nset, Cons* args);

  // standard predicates
  Object* builtin_nilp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_intp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_nump    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_strp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_litp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_vecp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_nstp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_ashp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_clsp    (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_instp   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_realp   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_boolp   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_charp   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_consp   (Interp* interp, Nameset* nset, Cons* args);
  Object* builtin_listp   (Interp* interp, Nameset* nset, Cons* args);
}

#endif
