// ---------------------------------------------------------------------------
// - Nameset.cpp                                                            -
// - aleph engine - nameset class implementation                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Symbol.hpp"
#include "Nameset.hpp"
#include "Exception.hpp"

namespace aleph {

  // create a default nameset

  Nameset::Nameset (void) {
    p_parent = nilp;
  }

  // destroy this nameset

  Nameset::~Nameset (void) {
    Object::dref (p_parent);
  }

  // set the parent nameset 

  void Nameset::setparent (Nameset* nset) {
    if (p_parent != nilp) {
      remove ("..");
      Object::dref (p_parent);
    }
    Object::iref (nset);
    p_parent = nset;
    if (nset != nilp) symcst ("..", nset);
  }

  // create a new const symbol

  void Nameset::symcst (const String& name, Object* object) {
    Symbol* sym = new Symbol (name, object);
    sym->setconst (true);
    this->bind (name, sym);
  }

  // create a new symbol

  void Nameset::symdef (const String& name, Object* object) {
    Symbol* sym = new Symbol (name, object);
    this->bind (name, sym);
  }
}
